/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.structure.presentation;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.jupyter.core.jupyter.structure.model.JupyterStructureElementState;
import com.intellij.jupyter.core.jupyter.structure.presentation.JupyterStructureTextAttributes;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B5\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ;\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u00032\b\u0010\u001e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\nH\u0000\u00a2\u0006\u0002\b!J\b\u0010\"\u001a\u00020\bH\u0002J\b\u0010#\u001a\u00020\u0003H\u0016J\n\u0010$\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\u00062\u0006\u0010&\u001a\u00020\bH\u0016J\b\u0010'\u001a\u00020(H\u0016J\t\u0010)\u001a\u00020\u0003H\u00c2\u0003J\u000b\u0010*\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J\u000b\u0010+\u001a\u0004\u0018\u00010\u0006H\u00c2\u0003J\t\u0010,\u001a\u00020\bH\u00c2\u0003J\t\u0010-\u001a\u00020\nH\u00c2\u0003J?\u0010.\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0014\u0010/\u001a\u00020\b2\b\u00100\u001a\u0004\u0018\u000101H\u00d6\u0083\u0004J\n\u00102\u001a\u000203H\u00d6\u0081\u0004J\n\u00104\u001a\u00020\u0003H\u00d6\u0081\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00065"}, d2={"Lcom/intellij/jupyter/core/jupyter/structure/presentation/JupyterStructureItemPresentation;", "Lcom/intellij/ide/projectView/PresentationData;", "myText", "", "myLocation", "myNodeIcon", "Ljavax/swing/Icon;", "myIsHeader", "", "myExecutionState", "Lcom/intellij/jupyter/core/jupyter/structure/model/JupyterStructureElementState;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;ZLcom/intellij/jupyter/core/jupyter/structure/model/JupyterStructureElementState;)V", "text", "getText", "()Ljava/lang/String;", "location", "getLocation", "nodeIcon", "getNodeIcon", "()Ljavax/swing/Icon;", "isHeader", "()Z", "executionState", "getExecutionState", "()Lcom/intellij/jupyter/core/jupyter/structure/model/JupyterStructureElementState;", "update", "", "newText", "newLocation", "newIcon", "newIsHeader", "newExecutionState", "update$intellij_jupyter_core", "shouldAddSpace", "getPresentableText", "getLocationString", "getIcon", "open", "getTextAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "toString", "intellij.jupyter.core"})
public final class JupyterStructureItemPresentation
extends PresentationData {
    @NotNull
    private String myText;
    @Nullable
    private String myLocation;
    @Nullable
    private Icon myNodeIcon;
    private boolean myIsHeader;
    @NotNull
    private JupyterStructureElementState myExecutionState;

    public JupyterStructureItemPresentation(@NlsContexts.Label @NotNull String myText, @Nullable String myLocation, @Nullable Icon myNodeIcon, boolean myIsHeader, @NotNull JupyterStructureElementState myExecutionState) {
        Intrinsics.checkNotNullParameter((Object)myText, (String)"myText");
        Intrinsics.checkNotNullParameter((Object)((Object)myExecutionState), (String)"myExecutionState");
        this.myText = myText;
        this.myLocation = myLocation;
        this.myNodeIcon = myNodeIcon;
        this.myIsHeader = myIsHeader;
        this.myExecutionState = myExecutionState;
        this.setIcon(this.myNodeIcon);
        SimpleTextAttributes titleAttributes = this.myIsHeader ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        this.addText(this.myText, titleAttributes);
        if (this.shouldAddSpace()) {
            this.addText(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    @NlsContexts.Label
    @NotNull
    public final String getText() {
        return this.myText;
    }

    @Nullable
    public final String getLocation() {
        return this.myLocation;
    }

    @Nullable
    public final Icon getNodeIcon() {
        return this.myNodeIcon;
    }

    public final boolean isHeader() {
        return this.myIsHeader;
    }

    @NotNull
    public final JupyterStructureElementState getExecutionState() {
        return this.myExecutionState;
    }

    public final void update$intellij_jupyter_core(@NlsContexts.Label @NotNull String newText, @Nullable String newLocation, @Nullable Icon newIcon, boolean newIsHeader, @NotNull JupyterStructureElementState newExecutionState) {
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        Intrinsics.checkNotNullParameter((Object)((Object)newExecutionState), (String)"newExecutionState");
        this.myText = newText;
        this.myLocation = newLocation;
        this.myNodeIcon = newIcon;
        this.myIsHeader = newIsHeader;
        this.myExecutionState = newExecutionState;
        this.setIcon(this.myNodeIcon);
        this.clearText();
        SimpleTextAttributes titleAttributes = this.myIsHeader ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        this.addText(this.myText, titleAttributes);
        if (this.shouldAddSpace()) {
            this.addText(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    private final boolean shouldAddSpace() {
        return this.myLocation != null && !this.myExecutionState.isRunningOrQueued();
    }

    @NotNull
    public String getPresentableText() {
        return this.getText();
    }

    @Nullable
    public String getLocationString() {
        return this.getLocation();
    }

    @Nullable
    public Icon getIcon(boolean open) {
        return this.getNodeIcon();
    }

    @NotNull
    public TextAttributesKey getTextAttributesKey() {
        return this.isHeader() ? JupyterStructureTextAttributes.INSTANCE.getMARKDOWN_HEADER_BOLD() : JupyterStructureTextAttributes.INSTANCE.getMARKDOWN_HEADER();
    }

    private final String component1() {
        return this.myText;
    }

    private final String component2() {
        return this.myLocation;
    }

    private final Icon component3() {
        return this.myNodeIcon;
    }

    private final boolean component4() {
        return this.myIsHeader;
    }

    private final JupyterStructureElementState component5() {
        return this.myExecutionState;
    }

    @NotNull
    public final JupyterStructureItemPresentation copy(@NlsContexts.Label @NotNull String myText, @Nullable String myLocation, @Nullable Icon myNodeIcon, boolean myIsHeader, @NotNull JupyterStructureElementState myExecutionState) {
        Intrinsics.checkNotNullParameter((Object)myText, (String)"myText");
        Intrinsics.checkNotNullParameter((Object)((Object)myExecutionState), (String)"myExecutionState");
        return new JupyterStructureItemPresentation(myText, myLocation, myNodeIcon, myIsHeader, myExecutionState);
    }

    public static /* synthetic */ JupyterStructureItemPresentation copy$default(JupyterStructureItemPresentation jupyterStructureItemPresentation, String string, String string2, Icon icon, boolean bl, JupyterStructureElementState jupyterStructureElementState, int n, Object object) {
        if ((n & 1) != 0) {
            string = jupyterStructureItemPresentation.myText;
        }
        if ((n & 2) != 0) {
            string2 = jupyterStructureItemPresentation.myLocation;
        }
        if ((n & 4) != 0) {
            icon = jupyterStructureItemPresentation.myNodeIcon;
        }
        if ((n & 8) != 0) {
            bl = jupyterStructureItemPresentation.myIsHeader;
        }
        if ((n & 0x10) != 0) {
            jupyterStructureElementState = jupyterStructureItemPresentation.myExecutionState;
        }
        return jupyterStructureItemPresentation.copy(string, string2, icon, bl, jupyterStructureElementState);
    }

    @NotNull
    public String toString() {
        return "JupyterStructureItemPresentation(myText=" + this.myText + ", myLocation=" + this.myLocation + ", myNodeIcon=" + this.myNodeIcon + ", myIsHeader=" + this.myIsHeader + ", myExecutionState=" + this.myExecutionState + ")";
    }

    public int hashCode() {
        int result2 = this.myText.hashCode();
        result2 = result2 * 31 + (this.myLocation == null ? 0 : this.myLocation.hashCode());
        result2 = result2 * 31 + (this.myNodeIcon == null ? 0 : this.myNodeIcon.hashCode());
        result2 = result2 * 31 + Boolean.hashCode(this.myIsHeader);
        result2 = result2 * 31 + this.myExecutionState.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JupyterStructureItemPresentation)) {
            return false;
        }
        JupyterStructureItemPresentation jupyterStructureItemPresentation = (JupyterStructureItemPresentation)((Object)other);
        if (!Intrinsics.areEqual((Object)this.myText, (Object)jupyterStructureItemPresentation.myText)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.myLocation, (Object)jupyterStructureItemPresentation.myLocation)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.myNodeIcon, (Object)jupyterStructureItemPresentation.myNodeIcon)) {
            return false;
        }
        if (this.myIsHeader != jupyterStructureItemPresentation.myIsHeader) {
            return false;
        }
        return this.myExecutionState == jupyterStructureItemPresentation.myExecutionState;
    }
}

