/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grid.scripting.impl;

import com.intellij.database.extensions.ExtensionScriptsUtil;
import com.intellij.database.extensions.ExtractorScripts;
import com.intellij.grid.scripting.impl.DataLoaderManager;
import com.intellij.grid.scripting.rt.util.DatabaseExtensionScriptRunnerBase;
import com.intellij.ide.script.IdeScriptEngine;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.ClassLoaderUtil;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u0006\u0010\u0017\u001a\u00020\u0010J\u001f\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001b\u00a2\u0006\u0002\u0010\u001cR\u0015\u0010\b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/intellij/grid/scripting/impl/DatabaseExtensionScriptRunnerInIde;", "Lcom/intellij/grid/scripting/rt/util/DatabaseExtensionScriptRunnerBase;", "scriptPath", "Ljava/nio/file/Path;", "consumer", "Lcom/intellij/grid/scripting/rt/util/DatabaseExtensionScriptRunnerBase$ProgressMessagesConsumer;", "<init>", "(Ljava/nio/file/Path;Lcom/intellij/grid/scripting/rt/util/DatabaseExtensionScriptRunnerBase$ProgressMessagesConsumer;)V", "classLoader", "Ljava/lang/ClassLoader;", "Lorg/jetbrains/annotations/Nullable;", "engine", "Lcom/intellij/ide/script/IdeScriptEngine;", "getEngine", "()Lcom/intellij/ide/script/IdeScriptEngine;", "bind", "", "name", "", "what", "", "eval", "text", "cleanup", "callBack", "T", "f", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.grid.scripting.impl"})
public final class DatabaseExtensionScriptRunnerInIde
extends DatabaseExtensionScriptRunnerBase {
    @Nullable
    private final ClassLoader classLoader;
    @NotNull
    private final IdeScriptEngine engine;

    public DatabaseExtensionScriptRunnerInIde(@NotNull Path scriptPath, @NotNull DatabaseExtensionScriptRunnerBase.ProgressMessagesConsumer consumer) {
        Intrinsics.checkNotNullParameter((Object)scriptPath, (String)"scriptPath");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        this.classLoader = ExtensionScriptsUtil.getClassLoader((PluginId)ExtractorScripts.getPluginId());
        IdeScriptEngine ideScriptEngine = ExtensionScriptsUtil.getEngineFor(null, (ClassLoader)this.classLoader, (Path)scriptPath, null, (boolean)true);
        if (ideScriptEngine == null) {
            throw new ProcessCanceledException();
        }
        this.engine = ideScriptEngine;
        this.setDependenciesProgressConsumer(consumer);
        System.setProperty("grape.root", ((Object)DataLoaderManager.Companion.getGrapeDir$intellij_grid_scripting_impl()).toString());
        this.initEngine(this.engine.getLanguage());
    }

    @NotNull
    public final IdeScriptEngine getEngine() {
        return this.engine;
    }

    public void bind(@NotNull String name, @Nullable Object what) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.engine.setBinding(name, what);
    }

    @Nullable
    public Object eval(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.engine.eval(text);
    }

    public final void cleanup() {
    }

    public final <T> T callBack(@NotNull Function0<? extends T> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        return (T)ClassLoaderUtil.computeWithClassLoader((ClassLoader)this.classLoader, () -> DatabaseExtensionScriptRunnerInIde.callBack$lambda$0(f));
    }

    private static final Object callBack$lambda$0(Function0 $f) {
        return $f.invoke();
    }
}

