/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.MakeVoidQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTypes;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.model.highlighting.jam.MethodParametersRemovingFix;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0004\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/spring/model/highlighting/jam/ScheduledMethodInspection;", "Lcom/intellij/spring/model/highlighting/jam/SpringUastInspectionBase;", "<init>", "()V", "checkMethod", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "method", "Lorg/jetbrains/uast/UMethod;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lorg/jetbrains/uast/UMethod;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "isSpring6OrHigher", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "intellij.spring.core"})
public final class ScheduledMethodInspection
extends SpringUastInspectionBase {
    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull UMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        PsiMethod psiMethod = method.getJavaPsi();
        UElement uElement = method.getUastAnchor();
        if (uElement == null || (uElement = uElement.getSourcePsi()) == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        UElement anchor = uElement;
        if (MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiMethod), (Collection)CollectionsKt.listOf((Object)"org.springframework.scheduling.annotation.Scheduled"))) {
            LocalQuickFix[] localQuickFixArray;
            ProblemsHolder problemsHolder = new ProblemsHolder(manager, psiMethod.getContainingFile(), isOnTheFly);
            if (!this.isSpring6OrHigher(psiMethod) && !Intrinsics.areEqual((Object)PsiTypes.voidType(), (Object)psiMethod.getReturnType())) {
                localQuickFixArray = new LocalQuickFix[]{new MakeVoidQuickFix(null)};
                problemsHolder.registerProblem((PsiElement)anchor, SpringBundle.message("ScheduledMethodInspection.non.void.return.type", new Object[0]), localQuickFixArray);
            }
            if (psiMethod.getParameterList().getParametersCount() > 0) {
                localQuickFixArray = new LocalQuickFix[]{new MethodParametersRemovingFix(psiMethod)};
                problemsHolder.registerProblem((PsiElement)anchor, SpringBundle.message("ScheduledMethodInspection.has.parameters", new Object[0]), localQuickFixArray);
            }
            return problemsHolder.getResultsArray();
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    private final boolean isSpring6OrHigher(PsiMethod psiMethod) {
        return SpringLibraryUtil.isAtLeastVersion((Module)ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiMethod)), (SpringLibraryUtil.SpringVersion)SpringLibraryUtil.SpringVersion.V_6_0);
    }
}

