/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts.override.inspections;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodQuickFix;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.jam.SpringBeanPointerResolveInspection;
import com.intellij.spring.model.jam.testContexts.override.testBean.TestBeanField;
import com.intellij.spring.model.jam.testContexts.override.testBean.references.FactoryMethodReferenceConverter;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UField;

public final class SpringTestingOverridenBeanResolveInspection
extends SpringBeanPointerResolveInspection {
    public ProblemDescriptor @Nullable [] checkField(@NotNull UField field, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (field == null) {
            SpringTestingOverridenBeanResolveInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringTestingOverridenBeanResolveInspection.$$$reportNull$$$0(1);
        }
        PsiElement javaPsi = field.getJavaPsi();
        PsiElement sourcePsi = field.getSourcePsi();
        if (sourcePsi != null && javaPsi instanceof PsiField) {
            PsiField javaPsiField = (PsiField)javaPsi;
            ProblemsHolder holder = new ProblemsHolder(manager, sourcePsi.getContainingFile(), isOnTheFly);
            TestBeanField testBeanField = (TestBeanField)TestBeanField.META.getJamElement((PsiModifierListOwner)javaPsiField);
            if (testBeanField != null) {
                SpringTestingOverridenBeanResolveInspection.checkBeanAttributes(testBeanField.getBeanReferenceAttributes(), holder);
                SpringTestingOverridenBeanResolveInspection.checkTestBeanMethodName(testBeanField, holder);
            }
            return holder.getResultsArray();
        }
        return null;
    }

    private static void checkBeanAttributes(List<JamStringAttributeElement<SpringBeanPointer<?>>> attributes, ProblemsHolder holder) {
        for (JamStringAttributeElement<SpringBeanPointer<?>> beanReferenceAttribute : attributes) {
            SpringTestingOverridenBeanResolveInspection.checkBeanPointerResolve((ProblemsHolder)holder, beanReferenceAttribute, Collections.emptyList());
        }
    }

    private static void checkTestBeanMethodName(TestBeanField testBeanField, ProblemsHolder holder) {
        PsiAnnotation annotation;
        JamStringAttributeElement<PsiMethod> attribute = testBeanField.getMethodNameAttribute();
        PsiAnnotationMemberValue psiElement = attribute.getPsiElement();
        if (psiElement != null) {
            PsiReference[] references;
            for (PsiReference reference : references = psiElement.getReferences()) {
                if (!(reference instanceof FactoryMethodReferenceConverter.FactoryMethodReference) && !(reference instanceof FactoryMethodReferenceConverter.DefaultFactoryMethodReference) && !(reference instanceof JavaClassReference) || reference.resolve() != null) continue;
                holder.registerProblem(reference);
            }
        } else if (testBeanField.getDefaultFactoryMethod() == null && (annotation = testBeanField.getAnnotation()) != null) {
            holder.registerProblem((PsiElement)annotation, SpringBundle.message("spring.test.override.bean.resolve.inspection.cannot.find.factory.method", new Object[0]), SpringTestingOverridenBeanResolveInspection.createFactoryMethodFixes(testBeanField));
        }
    }

    private static LocalQuickFix[] createFactoryMethodFixes(TestBeanField testBeanField) {
        LocalQuickFix[] localQuickFixArray;
        PsiField psiField = testBeanField.getPsiElement();
        String returnType = psiField.getType().getCanonicalText();
        String methodName = psiField.getName();
        @NonNls String signature = "static " + returnType + " " + methodName + "()";
        @NonNls String body = "return null;";
        PsiClass containingClass = psiField.getContainingClass();
        if (containingClass != null) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = CreateMethodQuickFix.createFix((PsiClass)containingClass, (String)signature, (String)"return null;");
        } else {
            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
        }
        return localQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "field";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/model/jam/testContexts/override/inspections/SpringTestingOverridenBeanResolveInspection";
        objectArray[2] = "checkField";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

