/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.ui.mass;

import com.intellij.grazie.ide.ui.mass.Change;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u0006\u0010\r\u001a\u00020\u000bJ\u0006\u0010\u000e\u001a\u00020\u000bJ\u0006\u0010\u000f\u001a\u00020\u000bJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/grazie/ide/ui/mass/DocumentUndoManager;", "", "<init>", "()V", "undoStack", "Ljava/util/LinkedList;", "Lcom/intellij/grazie/ide/ui/mass/Change;", "redoStack", "isDoInProgress", "Ljava/util/concurrent/atomic/AtomicBoolean;", "trackChange", "", "changes", "clear", "undo", "redo", "isUndoAvailable", "", "isRedoAvailable", "intellij.grazie.core"})
final class DocumentUndoManager {
    @NotNull
    private final LinkedList<Change> undoStack = new LinkedList();
    @NotNull
    private final LinkedList<Change> redoStack = new LinkedList();
    @NotNull
    private AtomicBoolean isDoInProgress = new AtomicBoolean(false);

    public final void trackChange(@NotNull Change changes) {
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        if (this.isDoInProgress.get()) {
            return;
        }
        this.undoStack.add(changes);
        this.redoStack.clear();
    }

    public final void clear() {
        if (this.isDoInProgress.get()) {
            return;
        }
        this.undoStack.clear();
        this.redoStack.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void undo() {
        if (!this.isUndoAvailable()) {
            return;
        }
        if (!this.isDoInProgress.compareAndSet(false, true)) {
            return;
        }
        try {
            Change change = this.undoStack.removeLast();
            Intrinsics.checkNotNullExpressionValue((Object)change, (String)"removeLast(...)");
            Change change2 = change;
            change2.revert();
            this.redoStack.add(change2);
        }
        finally {
            this.isDoInProgress.compareAndSet(true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void redo() {
        if (!this.isRedoAvailable()) {
            return;
        }
        if (!this.isDoInProgress.compareAndSet(false, true)) {
            return;
        }
        try {
            Change change = this.redoStack.removeLast();
            Intrinsics.checkNotNullExpressionValue((Object)change, (String)"removeLast(...)");
            Change change2 = change;
            change2.apply();
            this.undoStack.add(change2);
        }
        finally {
            this.isDoInProgress.compareAndSet(true, false);
        }
    }

    public final boolean isUndoAvailable() {
        return !((Collection)this.undoStack).isEmpty();
    }

    public final boolean isRedoAvailable() {
        return !((Collection)this.redoStack).isEmpty();
    }
}

