/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules;

import com.intellij.internal.statistic.eventLog.validator.IEventContext;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRule;
import org.jetbrains.annotations.NotNull;

public abstract class PerformanceCareRule
implements FUSRule {
    private static final int EXPECTED_TIME_MSEC = 239;
    private static final int MAX_ATTEMPTS = 10;
    private int failed = 0;

    @Override
    @NotNull
    public final ValidationResultType validate(@NotNull String data, @NotNull IEventContext context) {
        if (this.failed > 10) {
            return ValidationResultType.PERFORMANCE_ISSUE;
        }
        long startedAt = System.currentTimeMillis();
        ValidationResultType resultType = this.doValidate(data, context);
        if (System.currentTimeMillis() - startedAt > 239L) {
            ++this.failed;
        }
        return resultType;
    }

    @NotNull
    protected abstract ValidationResultType doValidate(@NotNull String var1, @NotNull IEventContext var2);
}

