/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.kubernetes.frontend.editor.floatingToolbar;

import com.intellij.openapi.util.NlsSafe;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a%\u0010\u0005\u001a\u00020\u00062\u000b\u0010\u0007\u001a\u00070\u0006\u00a2\u0006\u0002\b\b2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001H\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"CONTEXT_NAME_MAX_NAME_LENGTH", "", "CONTEXT_NAME_SUFFIX_PREFIX_LENGTH", "NAMESPACE_NAME_MAX_NAME_LENGTH", "NAMESPACE_NAME_SUFFIX_PREFIX_LENGTH", "shortenIfNeed", "", "name", "Lorg/jetbrains/annotations/Nls;", "maxFullLength", "suffixPrefixLength", "intellij.clouds.kubernetes.frontend"})
public final class KubernetesFloatingToolbarUtilsKt {
    public static final int CONTEXT_NAME_MAX_NAME_LENGTH = 25;
    public static final int CONTEXT_NAME_SUFFIX_PREFIX_LENGTH = 10;
    public static final int NAMESPACE_NAME_MAX_NAME_LENGTH = 15;
    public static final int NAMESPACE_NAME_SUFFIX_PREFIX_LENGTH = 6;

    @NlsSafe
    @NotNull
    public static final String shortenIfNeed(@NotNull String name, int maxFullLength, int suffixPrefixLength) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (name.length() <= maxFullLength) {
            return name;
        }
        if (maxFullLength <= suffixPrefixLength * 2) {
            throw new IllegalArgumentException("maxFullLength must be greater than suffixPrefixLength * 2");
        }
        String string = name.substring(0, suffixPrefixLength);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String prefix = string;
        String string2 = name.substring(name.length() - suffixPrefixLength);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String suffix = string2;
        return prefix + "\u2026" + suffix;
    }
}

