/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.events.listeners;

import com.intellij.code.provenance.DocumentChangesKind;
import com.intellij.code.provenance.core.ProvenanceRegistry;
import com.intellij.code.provenance.core.events.listeners.ProvenanceListenersKt;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManagerListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/code/provenance/core/events/listeners/ProvenanceLookupManagerListener;", "Lcom/intellij/codeInsight/lookup/LookupManagerListener;", "<init>", "()V", "activeLookupChanged", "", "oldLookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "newLookup", "intellij.code.provenance.core"})
public final class ProvenanceLookupManagerListener
implements LookupManagerListener {
    public void activeLookupChanged(@Nullable Lookup oldLookup, @Nullable Lookup newLookup) {
        if (!ProvenanceRegistry.INSTANCE.isProvenanceEnabled()) {
            return;
        }
        LookupImpl lookupImpl = newLookup instanceof LookupImpl ? (LookupImpl)newLookup : null;
        if (lookupImpl == null) {
            return;
        }
        LookupImpl lookup = lookupImpl;
        lookup.addLookupListener(new LookupListener(lookup){
            final /* synthetic */ LookupImpl $lookup;
            {
                this.$lookup = $lookup;
            }

            public boolean beforeItemSelected(LookupEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$lookup.getEditor().putUserData(ProvenanceListenersKt.getEDITOR_CHANGE_KIND_KEY(), (Object)DocumentChangesKind.COMPLETION);
                return super.beforeItemSelected(event);
            }

            public void itemSelected(LookupEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Editor editor = this.$lookup.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)editor), ProvenanceListenersKt.getEDITOR_CHANGE_KIND_KEY());
                super.itemSelected(event);
            }

            public void lookupCanceled(LookupEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.$lookup.getEditor().getUserData(ProvenanceListenersKt.getEDITOR_CHANGE_KIND_KEY()) == DocumentChangesKind.COMPLETION) {
                    Editor editor = this.$lookup.getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                    RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)editor), ProvenanceListenersKt.getEDITOR_CHANGE_KIND_KEY());
                }
                super.lookupCanceled(event);
            }
        });
    }
}

