/*
 * Decompiled with CFR 0.152.
 */
package training.dsl;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.LessonSampleKt;
import training.dsl.LessonSamplePosition;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\rJ\u000e\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0006J\u0016\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001f\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001a"}, d2={"Ltraining/dsl/LessonSample;", "", "text", "", "positions", "", "", "Ltraining/dsl/LessonSamplePosition;", "<init>", "(Ljava/lang/String;Ljava/util/Map;)V", "position", "(Ljava/lang/String;Ltraining/dsl/LessonSamplePosition;)V", "startOffset", "(Ljava/lang/String;I)V", "getText", "()Ljava/lang/String;", "getStartOffset", "()I", "selection", "Lkotlin/Pair;", "getSelection", "()Lkotlin/Pair;", "getPosition", "id", "insertAtPosition", "insert", "intellij.featuresTrainer"})
public final class LessonSample {
    @NotNull
    private final String text;
    @NotNull
    private final Map<Integer, LessonSamplePosition> positions;

    public LessonSample(@NotNull String text, @NotNull Map<Integer, LessonSamplePosition> positions) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(positions, (String)"positions");
        this.text = text;
        this.positions = positions;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public LessonSample(@NotNull String text, @NotNull LessonSamplePosition position) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this(text, MapsKt.mapOf((Pair)new Pair((Object)0, (Object)new LessonSamplePosition(0, position.getStartOffset(), position.getSelection()))));
    }

    public LessonSample(@NotNull String text, int startOffset) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this(text, new LessonSamplePosition(0, startOffset, null, 4, null));
    }

    public final int getStartOffset() {
        return this.getPosition(0).getStartOffset();
    }

    @Nullable
    public final Pair<Integer, Integer> getSelection() {
        return this.getPosition(0).getSelection();
    }

    @NotNull
    public final LessonSamplePosition getPosition(int id) {
        LessonSamplePosition lessonSamplePosition = this.positions.get(id);
        if (lessonSamplePosition == null) {
            if (id == 0) {
                lessonSamplePosition = new LessonSamplePosition(0, 0, null, 4, null);
            } else {
                throw new IllegalStateException(("No id " + id).toString());
            }
        }
        return lessonSamplePosition;
    }

    @NotNull
    public final LessonSample insertAtPosition(int id, @NotNull String insert) {
        Intrinsics.checkNotNullParameter((Object)insert, (String)"insert");
        LessonSamplePosition position = this.getPosition(id);
        StringBuilder stringBuilder = new StringBuilder(this.text);
        stringBuilder.insert(position.getStartOffset(), insert);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return LessonSampleKt.parseLessonSample(string);
    }
}

