/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.JSTagOrGenericFlowParser;
import com.intellij.lang.javascript.parsing.JSTagOrGenericParser;
import com.intellij.lang.javascript.parsing.JSTagOrGenericUtil;
import com.intellij.lexer.FlexLexer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.io.IOException;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\tH\u0007J\u0016\u0010\u000f\u001a\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011H\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/lang/javascript/JSLexerUtil;", "", "<init>", "()V", "SKIP_WORDS_SCAN_SET", "Lcom/intellij/psi/tree/TokenSet;", "canBeGenericArgumentList", "", "lexer", "Lcom/intellij/lexer/FlexLexer;", "isFlow", "lookAheadOfLt", "Lcom/intellij/lang/javascript/JSLexerUtil$LookAheadOfLtResult;", "skipCommentsAndWhitespaces", "Lcom/intellij/psi/tree/IElementType;", "advanceBlockStatement", "tokenIterator", "", "LookAheadOfLtResult", "intellij.javascript.parser"})
public final class JSLexerUtil {
    @NotNull
    public static final JSLexerUtil INSTANCE = new JSLexerUtil();
    @JvmField
    @NotNull
    public static final TokenSet SKIP_WORDS_SCAN_SET;

    private JSLexerUtil() {
    }

    @JvmStatic
    public static final boolean canBeGenericArgumentList(@NotNull FlexLexer lexer, boolean isFlow) throws IOException {
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        IElementType next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        if (next != JSTokenTypes.IDENTIFIER) {
            return false;
        }
        next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        return next == JSTokenTypes.GT || next == JSTokenTypes.COMMA || !isFlow && next == JSTokenTypes.EXTENDS_KEYWORD || isFlow && next == JSTokenTypes.COLON;
    }

    @JvmStatic
    @NotNull
    public static final LookAheadOfLtResult lookAheadOfLt(boolean isFlow, @NotNull FlexLexer lexer) {
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        JSTagOrGenericUtil.State state = new JSTagOrGenericUtil.State((Function0<? extends IElementType>)((Function0)() -> JSLexerUtil.lookAheadOfLt$lambda$0(lexer)));
        boolean bl = isFlow ? JSTagOrGenericFlowParser.parse_root_(null, state, 0) : JSTagOrGenericParser.parse_root_(null, state, 0);
        JSTagOrGenericUtil.ElementType elementType = (JSTagOrGenericUtil.ElementType)((Object)state.getLastElementType());
        return switch (elementType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[elementType.ordinal()]) {
            case 1 -> LookAheadOfLtResult.OTHER;
            case 2 -> LookAheadOfLtResult.TAG_OR_GENERIC_PARAMETER;
            case -1 -> LookAheadOfLtResult.TAG;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @JvmStatic
    @Nullable
    public static final IElementType skipCommentsAndWhitespaces(@NotNull FlexLexer lexer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        if (lexer.yystate() == -1) {
            return null;
        }
        IElementType next = lexer.advance();
        while (JSElementTypes.COMMENTS_AND_WHITESPACES.contains(next)) {
            next = lexer.advance();
        }
        return next;
    }

    @JvmStatic
    public static final boolean advanceBlockStatement(@NotNull Iterator<? extends IElementType> tokenIterator) {
        Intrinsics.checkNotNullParameter(tokenIterator, (String)"tokenIterator");
        IElementType tokenType = tokenIterator.next();
        if (tokenType != JSTokenTypes.LBRACE) {
            return false;
        }
        int pos = 0;
        int balance = 1;
        while (balance > 0) {
            if (pos++ % 1000 == 0) {
                ProgressManager.checkCanceled();
            }
            if (!tokenIterator.hasNext()) {
                return false;
            }
            tokenType = tokenIterator.next();
            if (tokenType == JSTokenTypes.LBRACE) {
                ++balance;
                continue;
            }
            if (tokenType != JSTokenTypes.RBRACE) continue;
            --balance;
        }
        return true;
    }

    private static final IElementType lookAheadOfLt$lambda$0(FlexLexer $lexer) {
        return JSLexerUtil.skipCommentsAndWhitespaces($lexer);
    }

    static {
        TokenSet[] tokenSetArray = new TokenSet[2];
        IElementType[] iElementTypeArray = new IElementType[]{JSTokenTypes.WHITE_SPACE, JSTokenTypes.DOT, JSTokenTypes.SEMICOLON, JSTokenTypes.LBRACE, JSTokenTypes.RBRACE, JSTokenTypes.LPAR, JSTokenTypes.RPAR, JSTokenTypes.COLON, JSTokenTypes.COLON_COLON, JSTokenTypes.ANY_IDENTIFIER, JSTokenTypes.LBRACKET, JSTokenTypes.RBRACKET, JSTokenTypes.DOT_DOT, JSTokenTypes.DOT_DOT_DOT};
        tokenSetArray[0] = TokenSet.create((IElementType[])iElementTypeArray);
        iElementTypeArray = new IElementType[]{JSTokenTypes.IS_KEYWORD, JSTokenTypes.AS_KEYWORD, JSTokenTypes.IN_KEYWORD};
        tokenSetArray[1] = TokenSet.andNot((TokenSet)JSTokenTypes.OPERATIONS, (TokenSet)TokenSet.create((IElementType[])iElementTypeArray));
        TokenSet tokenSet = TokenSet.orSet((TokenSet[])tokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"orSet(...)");
        SKIP_WORDS_SCAN_SET = tokenSet;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/lang/javascript/JSLexerUtil$LookAheadOfLtResult;", "", "<init>", "(Ljava/lang/String;I)V", "TAG", "TAG_OR_GENERIC_PARAMETER", "OTHER", "intellij.javascript.parser"})
    public static final class LookAheadOfLtResult
    extends Enum<LookAheadOfLtResult> {
        public static final /* enum */ LookAheadOfLtResult TAG = new LookAheadOfLtResult();
        public static final /* enum */ LookAheadOfLtResult TAG_OR_GENERIC_PARAMETER = new LookAheadOfLtResult();
        public static final /* enum */ LookAheadOfLtResult OTHER = new LookAheadOfLtResult();
        private static final /* synthetic */ LookAheadOfLtResult[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LookAheadOfLtResult[] values() {
            return (LookAheadOfLtResult[])$VALUES.clone();
        }

        public static LookAheadOfLtResult valueOf(String value) {
            return Enum.valueOf(LookAheadOfLtResult.class, value);
        }

        @NotNull
        public static EnumEntries<LookAheadOfLtResult> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = lookAheadOfLtResultArray = new LookAheadOfLtResult[]{LookAheadOfLtResult.TAG, LookAheadOfLtResult.TAG_OR_GENERIC_PARAMETER, LookAheadOfLtResult.OTHER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JSTagOrGenericUtil.ElementType.values().length];
            try {
                nArray[JSTagOrGenericUtil.ElementType.GENERICS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JSTagOrGenericUtil.ElementType.TAG_OR_GENERICS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

