/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.JSFunctionParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ThreeState;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rJ\u001a\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rJ\u001c\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0002J\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0002J\u001a\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rJ\u001a\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rJ$\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/lang/javascript/parsing/JSArrowFunctionDetector;", "", "<init>", "()V", "PARENS", "", "Lcom/intellij/psi/tree/IElementType;", "GENERIC_PARENS", "isArrowFunctionExpression", "", "builder", "Lcom/intellij/lang/PsiBuilder;", "parser", "Lcom/intellij/lang/javascript/parsing/JSFunctionParser;", "checkArrowFunctionExpression", "parseAngleBrackets", "checkCommaSeparatedListElement", "Lcom/intellij/util/ThreeState;", "isArrowFunctionType", "checkArrowFunctionType", "skipParentheses", "parens", "skipAndCheckUnionOrIntersection", "intellij.javascript.parser"})
public final class JSArrowFunctionDetector {
    @NotNull
    public static final JSArrowFunctionDetector INSTANCE = new JSArrowFunctionDetector();
    @NotNull
    private static final Map<IElementType, IElementType> PARENS;
    @NotNull
    private static final Map<IElementType, IElementType> GENERIC_PARENS;

    private JSArrowFunctionDetector() {
    }

    public final boolean isArrowFunctionExpression(@NotNull PsiBuilder builder, @NotNull JSFunctionParser<?> parser) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(parser, (String)"parser");
        PsiBuilder.Marker marker = builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker marker2 = marker;
        boolean result = this.checkArrowFunctionExpression(builder, parser);
        marker2.rollbackTo();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean checkArrowFunctionExpression(@NotNull PsiBuilder builder, @NotNull JSFunctionParser<?> parser) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(parser, (String)"parser");
        if (!this.parseAngleBrackets(builder, parser)) {
            return false;
        }
        if (builder.getTokenType() != JSTokenTypes.LPAR) {
            return false;
        }
        IElementType next = builder.lookAhead(1);
        if (!parser.isValidFirstParameterStart(next)) {
            return false;
        }
        builder.advanceLexer();
        if (next == JSTokenTypes.RPAR) {
            builder.advanceLexer();
            if (builder.getTokenType() == JSTokenTypes.COLON) {
                return true;
            }
        } else {
            while (!builder.eof()) {
                ThreeState subResult;
                IElementType tokenType = builder.getTokenType();
                if (tokenType == JSTokenTypes.RPAR) {
                    builder.advanceLexer();
                    break;
                }
                if (tokenType == JSTokenTypes.COMMA) {
                    if (builder.lookAhead(1) == JSTokenTypes.EQ) {
                        return true;
                    }
                    builder.advanceLexer();
                }
                if ((subResult = this.checkCommaSeparatedListElement(builder, parser)) == ThreeState.UNSURE) continue;
                return subResult.toBoolean();
            }
        }
        Boolean data = (Boolean)builder.getUserData(ExpressionParser.PROHIBIT_TOKEN_REMAPPING);
        try {
            builder.putUserData(ExpressionParser.PROHIBIT_TOKEN_REMAPPING, (Object)true);
            if (builder.getTokenType() == JSTokenTypes.COLON && !parser.parser.getTypeParser().tryParseArrowFunctionReturnType()) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            builder.putUserData(ExpressionParser.PROHIBIT_TOKEN_REMAPPING, (Object)data);
        }
        return JSTokenTypes.ARROWS.contains(builder.getTokenType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean parseAngleBrackets(PsiBuilder builder, JSFunctionParser<?> parser) {
        if (Intrinsics.areEqual((Object)builder.getTokenType(), (Object)JSTokenTypes.LT)) {
            Boolean data = (Boolean)builder.getUserData(ExpressionParser.PROHIBIT_TOKEN_REMAPPING);
            try {
                builder.putUserData(ExpressionParser.PROHIBIT_TOKEN_REMAPPING, (Object)true);
                if (!parser.parser.getTypeParser().tryParseTypeParameterList()) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                builder.putUserData(ExpressionParser.PROHIBIT_TOKEN_REMAPPING, (Object)data);
            }
        }
        return true;
    }

    private final ThreeState checkCommaSeparatedListElement(PsiBuilder builder, JSFunctionParser<?> parser) {
        boolean seenEquals = false;
        boolean seenTypeColon = false;
        while (!builder.eof()) {
            IElementType tokenType = builder.getTokenType();
            if (PARENS.containsKey(tokenType)) {
                if (this.skipParentheses(builder, PARENS)) continue;
                return ThreeState.NO;
            }
            if (seenTypeColon && tokenType == JSTokenTypes.LT) {
                if (this.skipParentheses(builder, GENERIC_PARENS)) continue;
                return ThreeState.NO;
            }
            if (tokenType == JSTokenTypes.COMMA || tokenType == JSTokenTypes.RPAR) break;
            if (seenEquals) {
                builder.advanceLexer();
                continue;
            }
            if (tokenType == JSTokenTypes.EQ) {
                seenEquals = true;
            } else if (tokenType == JSTokenTypes.QUEST) {
                IElementType lookahead = builder.lookAhead(1);
                if (lookahead == JSTokenTypes.COLON || lookahead == JSTokenTypes.EQ || lookahead == JSTokenTypes.COMMA || lookahead == JSTokenTypes.RPAR) {
                    return ThreeState.YES;
                }
                if (!seenTypeColon || !parser.supportsColonTypeCast()) {
                    return ThreeState.NO;
                }
            } else if (tokenType == JSTokenTypes.COLON) {
                if (!parser.supportsColonTypeCast()) {
                    return ThreeState.YES;
                }
                seenTypeColon = true;
            } else {
                if (!seenTypeColon && tokenType == JSTokenTypes.AT) {
                    return ThreeState.YES;
                }
                if (!seenTypeColon && tokenType != JSTokenTypes.DOT_DOT_DOT && !JSKeywordSets.IDENTIFIER_NAMES.contains(tokenType)) {
                    return ThreeState.NO;
                }
            }
            builder.advanceLexer();
        }
        return ThreeState.UNSURE;
    }

    public final boolean isArrowFunctionType(@NotNull PsiBuilder builder, @NotNull JSFunctionParser<?> parser) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(parser, (String)"parser");
        PsiBuilder.Marker marker = builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker marker2 = marker;
        boolean result = this.checkArrowFunctionType(builder, parser);
        marker2.rollbackTo();
        return result;
    }

    public final boolean checkArrowFunctionType(@NotNull PsiBuilder builder, @NotNull JSFunctionParser<?> parser) {
        ThreeState state;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(parser, (String)"parser");
        if (builder.getTokenType() == JSTokenTypes.LT) {
            return true;
        }
        if (builder.getTokenType() != JSTokenTypes.LPAR) {
            return false;
        }
        IElementType next = builder.lookAhead(1);
        if (!parser.isValidFirstParameterStart(next)) {
            return false;
        }
        if (next == JSTokenTypes.RPAR || next == JSTokenTypes.DOT_DOT_DOT) {
            return true;
        }
        builder.advanceLexer();
        boolean foundParameter = false;
        while (!builder.eof() && parser.parser.isIdentifierName(builder.getTokenType())) {
            builder.advanceLexer();
            foundParameter = true;
        }
        if ((builder.getTokenType() == JSTokenTypes.LBRACE || builder.getTokenType() == JSTokenTypes.LBRACKET) && (state = this.skipAndCheckUnionOrIntersection(builder)) == ThreeState.NO) {
            builder.advanceLexer();
            foundParameter = true;
        }
        if (!foundParameter) {
            return false;
        }
        next = builder.getTokenType();
        if (next == JSTokenTypes.COLON || next == JSTokenTypes.COMMA || next == JSTokenTypes.QUEST || next == JSTokenTypes.EQ) {
            return true;
        }
        if (next != JSTokenTypes.RPAR) {
            return false;
        }
        builder.advanceLexer();
        return JSTokenTypes.ARROWS.contains(builder.getTokenType());
    }

    private final boolean skipParentheses(PsiBuilder builder, Map<IElementType, ? extends IElementType> parens) {
        Deque leftParens = new ArrayDeque();
        IElementType firstToken = builder.getTokenType();
        boolean bl = parens.containsKey(firstToken);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        leftParens.push(firstToken);
        builder.advanceLexer();
        while (!builder.eof()) {
            IElementType tokenType = builder.getTokenType();
            if (tokenType == parens.get(leftParens.peek())) {
                leftParens.pop();
            } else {
                if (parens.containsValue(tokenType)) {
                    return false;
                }
                if (parens.containsKey(tokenType)) {
                    leftParens.push(tokenType);
                }
            }
            builder.advanceLexer();
            if (!leftParens.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private final ThreeState skipAndCheckUnionOrIntersection(PsiBuilder builder) {
        IElementType lpar = builder.getTokenType();
        IElementType rpar = PARENS.get(lpar);
        boolean hasUnionOrIntersection = false;
        builder.advanceLexer();
        while (!builder.eof()) {
            IElementType tokenType = builder.getTokenType();
            if (tokenType == rpar) {
                return ThreeState.Companion.fromBoolean(hasUnionOrIntersection);
            }
            if (PARENS.containsValue(tokenType)) {
                return ThreeState.UNSURE;
            }
            if (tokenType == JSTokenTypes.OR || tokenType == JSTokenTypes.AND) {
                hasUnionOrIntersection = true;
            }
            if (PARENS.containsKey(tokenType)) {
                ThreeState isUnionOrIntersectionInner = this.skipAndCheckUnionOrIntersection(builder);
                if (isUnionOrIntersectionInner == ThreeState.UNSURE) {
                    return ThreeState.UNSURE;
                }
                hasUnionOrIntersection |= isUnionOrIntersectionInner == ThreeState.YES;
            }
            builder.advanceLexer();
        }
        return ThreeState.UNSURE;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)JSTokenTypes.LPAR, (Object)JSTokenTypes.RPAR), TuplesKt.to((Object)JSTokenTypes.LBRACE, (Object)JSTokenTypes.RBRACE), TuplesKt.to((Object)JSTokenTypes.LBRACKET, (Object)JSTokenTypes.RBRACKET), TuplesKt.to((Object)JSTokenTypes.LBRACE_OR, (Object)JSTokenTypes.OR_RBRACE)};
        PARENS = MapsKt.mapOf((Pair[])pairArray);
        GENERIC_PARENS = MapsKt.plus((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)JSTokenTypes.LT, (Object)JSTokenTypes.GT)), PARENS);
    }
}

