/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.manipulators;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class JSAbstractElementManipulator<T extends PsiElement>
extends AbstractElementManipulator<T> {
    public T handleContentChange(@NotNull T element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (element == null) {
            JSAbstractElementManipulator.$$$reportNull$$$0(0);
        }
        if (range == null) {
            JSAbstractElementManipulator.$$$reportNull$$$0(1);
        }
        String newText = this.getNewText(element, range, newContent);
        return (T)element.replace(this.createTree(newText, element));
    }

    protected String getNewText(T element, TextRange range, String newContent) {
        return JSAbstractElementManipulator.getNewTextForLiteral(element, range, newContent);
    }

    @NotNull
    public static String getNewTextForLiteral(PsiElement element, TextRange range, String newContent) {
        String oldText = element.getText();
        StringBuilder sb = new StringBuilder(oldText.substring(0, range.getStartOffset()));
        StringUtil.escapeStringCharacters((int)newContent.length(), (String)newContent, (String)(oldText.startsWith("'") ? "'" : "'\""), (StringBuilder)sb);
        String string = sb.append(oldText.substring(range.getEndOffset())).toString();
        if (string == null) {
            JSAbstractElementManipulator.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected abstract T createTree(String var1, T var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/manipulators/JSAbstractElementManipulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/manipulators/JSAbstractElementManipulator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewTextForLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

