/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.tracker;

import com.intellij.codeInsight.lookup.impl.PrefixChangeListener;
import com.intellij.completion.ml.personalization.UserFactorDescriptions;
import com.intellij.completion.ml.personalization.UserFactorStorage;
import com.intellij.completion.ml.personalization.impl.TimeBetweenTypingUpdater;
import com.intellij.openapi.project.Project;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/completion/ml/tracker/TimeBetweenTypingTracker;", "Lcom/intellij/codeInsight/lookup/impl/PrefixChangeListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "lastTypingTime", "", "beforeAppend", "", "c", "", "beforeTruncate", "prefixChanged", "Companion", "intellij.completionMlRanking"})
public final class TimeBetweenTypingTracker
implements PrefixChangeListener {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private long lastTypingTime;
    private static final long MAX_ALLOWED_DELAY = TimeUnit.SECONDS.toMillis(10L);

    public TimeBetweenTypingTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.lastTypingTime = -1L;
    }

    public void beforeAppend(char c) {
        this.prefixChanged();
    }

    public void beforeTruncate() {
        this.prefixChanged();
    }

    private final void prefixChanged() {
        if (this.lastTypingTime == -1L) {
            this.lastTypingTime = System.currentTimeMillis();
            return;
        }
        long currentTime = System.currentTimeMillis();
        long delay = currentTime - this.lastTypingTime;
        if (delay > MAX_ALLOWED_DELAY) {
            return;
        }
        UserFactorStorage.Companion.applyOnBoth(this.project, UserFactorDescriptions.INSTANCE.getTIME_BETWEEN_TYPING(), arg_0 -> TimeBetweenTypingTracker.prefixChanged$lambda$0(delay, arg_0));
        this.lastTypingTime = currentTime;
    }

    private static final Unit prefixChanged$lambda$0(long $delay, TimeBetweenTypingUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        updater.fireTypingPerformed((int)$delay);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/completion/ml/tracker/TimeBetweenTypingTracker$Companion;", "", "<init>", "()V", "MAX_ALLOWED_DELAY", "", "getMAX_ALLOWED_DELAY", "()J", "intellij.completionMlRanking"})
    private static final class Companion {
        private Companion() {
        }

        public final long getMAX_ALLOWED_DELAY() {
            return MAX_ALLOWED_DELAY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

