/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.icons.converters;

import com.intellij.ide.FixedProjectAvatarPresentation;
import com.intellij.ide.FullProjectAvatarPresentation;
import com.intellij.ide.ProjectAvatarPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.AvatarIcon;
import com.intellij.util.ui.AvatarPalette;
import com.intellij.util.ui.AvatarPresentation;
import com.intellij.util.ui.ColorPalette;
import com.intellij.util.ui.PaletteAvatarPresentation;
import com.jetbrains.rd.ide.model.AvatarIconModel;
import com.jetbrains.rd.ide.model.AvatarIconPresentationModel;
import com.jetbrains.rd.ide.model.FixedProjectAvatarIconPresentationModel;
import com.jetbrains.rd.ide.model.FullProjectAvatarIconPresentationModel;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.PaletteAvatarIconPresentationModel;
import com.jetbrains.rd.ui.icons.ProtocolIconConverter;
import com.jetbrains.rd.ui.icons.ProtocolIconModelRegistry;
import com.jetbrains.rd.ui.icons.ProtocolIconRegistry;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rd/ui/icons/converters/AvatarIconConverter;", "Lcom/jetbrains/rd/ui/icons/ProtocolIconConverter;", "Lcom/intellij/util/ui/AvatarIcon;", "Lcom/jetbrains/rd/ide/model/AvatarIconModel;", "<init>", "()V", "createIcon", "Ljavax/swing/Icon;", "model", "registry", "Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistry;", "createModel", "Lcom/jetbrains/rd/ide/model/IconModel;", "icon", "Lcom/jetbrains/rd/ui/icons/ProtocolIconModelRegistry;", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nAvatarIconConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvatarIconConverter.kt\ncom/jetbrains/rd/ui/icons/converters/AvatarIconConverter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n13#2:55\n13#2:57\n1#3:56\n*S KotlinDebug\n*F\n+ 1 AvatarIconConverter.kt\ncom/jetbrains/rd/ui/icons/converters/AvatarIconConverter\n*L\n27#1:55\n42#1:57\n*E\n"})
public final class AvatarIconConverter
implements ProtocolIconConverter<AvatarIcon, AvatarIconModel> {
    @NotNull
    public Icon createIcon(@NotNull AvatarIconModel model, @NotNull ProtocolIconRegistry registry) {
        AvatarPresentation avatarPresentation;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        AvatarIconPresentationModel p = model.getPresentation();
        if (p instanceof PaletteAvatarIconPresentationModel) {
            avatarPresentation = (AvatarPresentation)new PaletteAvatarPresentation(((PaletteAvatarIconPresentationModel)p).getGradientSeed(), ((PaletteAvatarIconPresentationModel)p).getAvatarName(), (ColorPalette)AvatarPalette.INSTANCE);
        } else if (p instanceof FullProjectAvatarIconPresentationModel) {
            ProjectAvatarPresentation projectAvatarPresentation;
            try {
                String string = ((FullProjectAvatarIconPresentationModel)p).getName();
                Path path = Path.of(((FullProjectAvatarIconPresentationModel)p).getPath(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                projectAvatarPresentation = (ProjectAvatarPresentation)new FullProjectAvatarPresentation(string, path);
            }
            catch (InvalidPathException e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(AvatarIconConverter.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn((Throwable)e);
                projectAvatarPresentation = (ProjectAvatarPresentation)new FixedProjectAvatarPresentation(((FullProjectAvatarIconPresentationModel)p).getName(), 0);
            }
            avatarPresentation = (AvatarPresentation)projectAvatarPresentation;
        } else if (p instanceof FixedProjectAvatarIconPresentationModel) {
            avatarPresentation = (AvatarPresentation)new FixedProjectAvatarPresentation(((FixedProjectAvatarIconPresentationModel)p).getName(), ((FixedProjectAvatarIconPresentationModel)p).getFixedIndex());
        } else {
            throw new IllegalStateException(("unknown palette type " + p).toString());
        }
        AvatarPresentation presentation = avatarPresentation;
        AvatarIconModel $this$createIcon_u24lambda_u240 = model;
        boolean bl = false;
        return (Icon)new AvatarIcon($this$createIcon_u24lambda_u240.getTargetSize(), $this$createIcon_u24lambda_u240.getArcRatio(), presentation);
    }

    @NotNull
    public IconModel createModel(@NotNull AvatarIcon icon, @NotNull ProtocolIconModelRegistry registry) {
        AvatarIconPresentationModel avatarIconPresentationModel;
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        AvatarPresentation p = icon.getPresentation();
        if (p instanceof PaletteAvatarPresentation) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(AvatarIconConverter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.assertTrue(((PaletteAvatarPresentation)p).getPalette() instanceof AvatarPalette, (Object)("unknown palette type " + ((PaletteAvatarPresentation)p).getPalette().getClass().getCanonicalName()));
            avatarIconPresentationModel = (AvatarIconPresentationModel)new PaletteAvatarIconPresentationModel(((PaletteAvatarPresentation)p).getGradientSeed(), ((PaletteAvatarPresentation)p).getName());
        } else if (p instanceof FullProjectAvatarPresentation) {
            avatarIconPresentationModel = (AvatarIconPresentationModel)new FullProjectAvatarIconPresentationModel(((FullProjectAvatarPresentation)p).getName(), PathsKt.getInvariantSeparatorsPathString((Path)((FullProjectAvatarPresentation)p).getPath()));
        } else if (p instanceof FixedProjectAvatarPresentation) {
            avatarIconPresentationModel = (AvatarIconPresentationModel)new FixedProjectAvatarIconPresentationModel(((FixedProjectAvatarPresentation)p).getName(), ((FixedProjectAvatarPresentation)p).getFixedIndex());
        } else {
            throw new IllegalStateException(("unknown presentation type " + p.getClass().getCanonicalName()).toString());
        }
        AvatarIconPresentationModel presentation = avatarIconPresentationModel;
        AvatarIcon $this$createModel_u24lambda_u240 = icon;
        boolean bl = false;
        return (IconModel)new AvatarIconModel($this$createModel_u24lambda_u240.getTargetSize(), $this$createModel_u24lambda_u240.getArcRatio(), presentation);
    }
}

