/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer.ssi;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import io.netty.handler.codec.http.HttpRequest;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.RootProvider;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.builtInWebServer.ssi.SsiExternalResolverKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012J\u0016\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u0007J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aJ\u001a\u0010\u001b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\rj\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/builtInWebServer/ssi/SsiExternalResolver;", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lio/netty/handler/codec/http/HttpRequest;", "parentPath", "", "parentFile", "Ljava/nio/file/Path;", "<init>", "(Lcom/intellij/openapi/project/Project;Lio/netty/handler/codec/http/HttpRequest;Ljava/lang/String;Ljava/nio/file/Path;)V", "variables", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "addVariableNames", "", "variableNames", "", "setVariableValue", "name", "value", "getVariableValue", "findFileInProject", "originalPath", "virtual", "", "findFile", "getFileLastModified", "", "path", "getFileSize", "intellij.platform.builtInServer.impl"})
@SourceDebugExtension(value={"SMAP\nSsiExternalResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SsiExternalResolver.kt\norg/jetbrains/builtInWebServer/ssi/SsiExternalResolver\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,88:1\n3938#2:89\n4474#2,2:90\n1807#3,2:92\n1809#3:96\n1276#4,2:94\n*S KotlinDebug\n*F\n+ 1 SsiExternalResolver.kt\norg/jetbrains/builtInWebServer/ssi/SsiExternalResolver\n*L\n52#1:89\n52#1:90,2\n53#1:92,2\n53#1:96\n56#1:94,2\n*E\n"})
public final class SsiExternalResolver {
    @NotNull
    private final Project project;
    @NotNull
    private final HttpRequest request;
    @NotNull
    private final String parentPath;
    @NotNull
    private final Path parentFile;
    @NotNull
    private final HashMap<String, String> variables;

    public SsiExternalResolver(@NotNull Project project, @NotNull HttpRequest request, @NotNull String parentPath, @NotNull Path parentFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)parentPath, (String)"parentPath");
        Intrinsics.checkNotNullParameter((Object)parentFile, (String)"parentFile");
        this.project = project;
        this.request = request;
        this.parentPath = parentPath;
        this.parentFile = parentFile;
        this.variables = new HashMap();
    }

    public final void addVariableNames(@NotNull Collection<String> variableNames) {
        Intrinsics.checkNotNullParameter(variableNames, (String)"variableNames");
        for (String variableName : SsiExternalResolverKt.access$getVARIABLE_NAMES$p()) {
            String variableValue = this.getVariableValue(variableName);
            if (variableValue == null) continue;
            variableNames.add(variableName);
        }
    }

    public final void setVariableValue(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.variables.put(name, value);
    }

    @Nullable
    public final String getVariableValue(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String value = this.variables.get(name);
        String string = value;
        if (string == null) {
            string = this.request.headers().get(name);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Path findFileInProject(@NotNull String originalPath, boolean virtual) {
        boolean bl;
        Path path;
        block6: {
            void $this$any$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
            path = this.findFile(originalPath, virtual);
            Object[] objectArray = (Object[])ActionsKt.runReadAction(() -> SsiExternalResolver.findFileInProject$lambda$0(this));
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                Module it = (Module)element$iv$iv;
                boolean bl2 = false;
                if (!(!it.isDisposed())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl3;
                    block5: {
                        void $this$any$iv2;
                        Module module = (Module)element$iv;
                        boolean bl4 = false;
                        Sequence sequence = SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])RootProvider.values()), arg_0 -> SsiExternalResolver.findFileInProject$lambda$2$0(module, arg_0));
                        boolean $i$f$any2 = false;
                        for (Object element$iv2 : $this$any$iv2) {
                            VirtualFile root = (VirtualFile)element$iv2;
                            boolean bl5 = false;
                            if (!FileUtil.isAncestor((String)root.getPath(), (String)String.valueOf(path), (boolean)false)) continue;
                            bl3 = true;
                            break block5;
                        }
                        bl3 = false;
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        boolean underProjectRoot = bl;
        return underProjectRoot ? path : null;
    }

    private final Path findFile(String originalPath, boolean virtual) {
        String path = FileUtil.toCanonicalPath((String)originalPath, (char)'/');
        if (!virtual) {
            return this.parentFile.resolve(path);
        }
        path = path.charAt(0) == '/' ? path : this.parentPath + "/" + path;
        WebServerPathToFileManager webServerPathToFileManager = WebServerPathToFileManager.Companion.getInstance(this.project);
        String string = path;
        Intrinsics.checkNotNull((Object)string);
        PathInfo pathInfo = WebServerPathToFileManager.getPathInfo$default(webServerPathToFileManager, string, true, null, 4, null);
        if (pathInfo == null) {
            return null;
        }
        PathInfo pathInfo2 = pathInfo;
        if (pathInfo2.getIoFile() == null) {
            VirtualFile virtualFile = pathInfo2.getFile();
            Intrinsics.checkNotNull((Object)virtualFile);
            return Paths.get(virtualFile.getPath(), new String[0]);
        }
        Path path2 = pathInfo2.getIoFile();
        Intrinsics.checkNotNull((Object)path2);
        return path2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final long getFileLastModified(@NotNull String path, boolean virtual) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path file = this.findFileInProject(path, virtual);
        if (file == null) return 0L;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return 0L;
        }
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        FileTime fileTime = Files.getLastModifiedTime(file, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
        long l = fileTime.toMillis();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final long getFileSize(@NotNull String path, boolean virtual) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path file = this.findFileInProject(path, virtual);
        if (file == null) return -1L;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return -1L;
        }
        long l = Files.size(file);
        return l;
    }

    private static final Sequence findFileInProject$lambda$2$0(Module $module, RootProvider rootProvider) {
        Intrinsics.checkNotNullParameter((Object)((Object)rootProvider), (String)"rootProvider");
        return ArraysKt.asSequence((Object[])rootProvider.getRoots(ProjectUtil.getRootManager((Module)$module)));
    }

    private static final Module[] findFileInProject$lambda$0(SsiExternalResolver this$0) {
        return ModuleManager.Companion.getInstance(this$0.project).getModules();
    }
}

