/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.microservices.jvm.config.hints.HintReferenceProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.paths.GlobalPathReferenceProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ConfigReferenceProvider
implements HintReferenceProvider {
    public static final String OPTIONAL_PREFIX = "optional:";
    public static final String FILE_PREFIX = "file:";
    public static final String CLASSPATH_PREFIX = "classpath:";
    public static final String CONFIG_TREE_PREFIX = "configtree:";
    public static final String CONFIG_SERVER_PREFIX = "configserver:";

    public PsiReference[] getReferences(@NotNull PsiElement element, @NotNull List<TextRange> textRanges, @NotNull ProcessingContext context) {
        if (element == null) {
            ConfigReferenceProvider.$$$reportNull$$$0(0);
        }
        if (textRanges == null) {
            ConfigReferenceProvider.$$$reportNull$$$0(1);
        }
        if (context == null) {
            ConfigReferenceProvider.$$$reportNull$$$0(2);
        }
        String text = element.getText();
        Object[] result = PsiReference.EMPTY_ARRAY;
        for (TextRange range : textRanges) {
            String nextValue = range.substring(text);
            boolean soft = false;
            if (nextValue.startsWith(OPTIONAL_PREFIX)) {
                nextValue = nextValue.substring(OPTIONAL_PREFIX.length());
                range = new TextRange(range.getStartOffset() + OPTIONAL_PREFIX.length(), range.getEndOffset());
                soft = true;
            }
            result = (PsiReference[])ArrayUtil.mergeArrays((Object[])result, (Object[])this.getReferences(element, nextValue, range.getStartOffset(), soft));
        }
        return result;
    }

    public PsiReference[] getReferences(PsiElement psiElement, String text, int offset, boolean soft) {
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return new PsiReference[]{new PrefixReference(psiElement, text, offset, soft)};
        }
        if (text.startsWith(CLASSPATH_PREFIX)) {
            return ConfigReferenceProvider.getClasspathReferences(psiElement, text.substring(CLASSPATH_PREFIX.length()), CLASSPATH_PREFIX.length() + offset, soft);
        }
        if (text.startsWith(CONFIG_TREE_PREFIX)) {
            return ConfigReferenceProvider.getConfigTreeReferences(psiElement, text.substring(CONFIG_TREE_PREFIX.length()), CONFIG_TREE_PREFIX.length() + offset);
        }
        if (text.startsWith(FILE_PREFIX)) {
            return ConfigReferenceProvider.getFileReferences(psiElement, text.substring(FILE_PREFIX.length()), FILE_PREFIX.length() + offset);
        }
        if (text.startsWith(CONFIG_SERVER_PREFIX)) {
            return ConfigReferenceProvider.getWebReferences(psiElement, text.substring(CONFIG_SERVER_PREFIX.length()), CONFIG_SERVER_PREFIX.length() + offset);
        }
        int prefixEndIndex = text.indexOf(58);
        if (prefixEndIndex >= 0 && prefixEndIndex < text.length() - 1) {
            return ConfigReferenceProvider.getClasspathReferences(psiElement, text.substring(prefixEndIndex + 1), offset + prefixEndIndex + 1, true);
        }
        return (PsiReference[])ArrayUtil.append((Object[])ConfigReferenceProvider.getClasspathReferences(psiElement, text, offset, true), (Object)((Object)new PrefixReference(psiElement, text, offset, soft)), PsiReference.class);
    }

    private static FileReference @NotNull [] getClasspathReferences(final PsiElement psiElement, String text, int offset, final boolean soft) {
        FileReferenceSet referenceSet2 = new FileReferenceSet(text, psiElement, offset, null, true, false, ConfigReferenceProvider.getFileTypes()){

            protected boolean isSoft() {
                return soft;
            }

            @NotNull
            public Collection<PsiFileSystemItem> computeDefaultContexts() {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
                if (module == null) {
                    Collection collection = super.computeDefaultContexts();
                    if (collection == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return collection;
                }
                VirtualFile file = psiElement.getContainingFile().getOriginalFile().getVirtualFile();
                boolean includeTestScope = file != null && ProjectFileIndex.getInstance((Project)psiElement.getProject()).isInTestSourceContent(file);
                return new SmartList(ConfigReferenceProvider.getClasspathRoots(module, includeTestScope));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/ConfigReferenceProvider$1", "computeDefaultContexts"));
            }
        };
        if (text.startsWith("/")) {
            referenceSet2.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, (Object)FileReferenceSet.ABSOLUTE_TOP_LEVEL);
        }
        FileReference[] fileReferenceArray = referenceSet2.getAllReferences();
        if (fileReferenceArray == null) {
            ConfigReferenceProvider.$$$reportNull$$$0(3);
        }
        return fileReferenceArray;
    }

    public static List<PsiDirectory> getClasspathRoots(@NotNull Module module, boolean includeTestScope) {
        PsiDirectory directory;
        if (module == null) {
            ConfigReferenceProvider.$$$reportNull$$$0(4);
        }
        SmartList result = new SmartList();
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        for (VirtualFile sourceRoot : moduleRootManager.getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE)) {
            directory = psiManager.findDirectory(sourceRoot);
            if (directory == null) continue;
            result.add(directory);
        }
        if (includeTestScope) {
            for (VirtualFile sourceRoot : moduleRootManager.getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.TEST_RESOURCE)) {
                directory = psiManager.findDirectory(sourceRoot);
                if (directory == null) continue;
                result.add(directory);
            }
        }
        return result;
    }

    private static FileReference @NotNull [] getConfigTreeReferences(final PsiElement psiElement, String text, int offset) {
        FileReferenceSet referenceSet2 = new FileReferenceSet(text, psiElement, offset, null, true){

            protected boolean isSoft() {
                return true;
            }

            protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                return PsiFileSystemItem::isDirectory;
            }

            @NotNull
            public Collection<PsiFileSystemItem> computeDefaultContexts() {
                PsiDirectory contentRoot = ConfigReferenceProvider.getContentRoot(psiElement);
                if (contentRoot == null) {
                    Collection collection = super.computeDefaultContexts();
                    if (collection == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return collection;
                }
                return new SmartList((Object)contentRoot);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/ConfigReferenceProvider$2", "computeDefaultContexts"));
            }
        };
        if (text.startsWith("/")) {
            referenceSet2.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, (Object)FileReferenceSet.ABSOLUTE_TOP_LEVEL);
        }
        FileReference[] fileReferenceArray = referenceSet2.getAllReferences();
        if (fileReferenceArray == null) {
            ConfigReferenceProvider.$$$reportNull$$$0(5);
        }
        return fileReferenceArray;
    }

    private static FileReference @NotNull [] getFileReferences(final PsiElement psiElement, String text, int offset) {
        FileReferenceSet referenceSet2 = new FileReferenceSet(text, psiElement, offset, null, true, false, ConfigReferenceProvider.getFileTypes()){

            protected boolean isSoft() {
                return true;
            }

            @NotNull
            public Collection<PsiFileSystemItem> computeDefaultContexts() {
                PsiDirectory contentRoot = ConfigReferenceProvider.getContentRoot(psiElement);
                if (contentRoot == null) {
                    Collection collection = super.computeDefaultContexts();
                    if (collection == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return collection;
                }
                return new SmartList((Object)contentRoot);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/ConfigReferenceProvider$3", "computeDefaultContexts"));
            }
        };
        if (text.startsWith("/")) {
            referenceSet2.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, (Object)FileReferenceSet.ABSOLUTE_TOP_LEVEL);
        }
        FileReference[] fileReferenceArray = referenceSet2.getAllReferences();
        if (fileReferenceArray == null) {
            ConfigReferenceProvider.$$$reportNull$$$0(6);
        }
        return fileReferenceArray;
    }

    private static FileType @Nullable [] getFileTypes() {
        return (FileType[])ContainerUtil.map2Array((Collection)SpringBootModelConfigFileContributor.EP_NAME.getExtensionList(), (Object[])FileType.EMPTY_ARRAY, SpringBootModelConfigFileContributor::getFileType);
    }

    @Nullable
    private static PsiDirectory getContentRoot(PsiElement psiElement) {
        VirtualFile file = psiElement.getContainingFile().getOriginalFile().getVirtualFile();
        if (file == null) {
            return null;
        }
        VirtualFile contentRoot = ProjectRootManager.getInstance((Project)psiElement.getProject()).getFileIndex().getContentRootForFile(file);
        if (contentRoot == null) {
            return null;
        }
        return psiElement.getManager().findDirectory(contentRoot);
    }

    private static PsiReference[] getWebReferences(PsiElement psiElement, String text, int offset) {
        SmartList references = new SmartList();
        TextRange textRange = TextRange.create((int)offset, (int)(offset + text.length()));
        new GlobalPathReferenceProvider().createUrlReference(psiElement, text, textRange, (List)references);
        return references.toArray(PsiReference.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRanges";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/config/hints/ConfigReferenceProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/config/hints/ConfigReferenceProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasspathReferences";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigTreeReferences";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getClasspathRoots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6 -> new IllegalStateException(string);
        };
    }

    private static final class PrefixReference
    extends PsiReferenceBase<PsiElement> {
        private final boolean myOptional;

        private PrefixReference(PsiElement psiElement, String text, int offset, boolean optional) {
            super(psiElement, optional);
            this.myOptional = optional;
            int colonIdx = text.indexOf(58);
            if (colonIdx == -1) {
                colonIdx = text.length();
            }
            this.setRangeInElement(TextRange.create((int)offset, (int)(offset + colonIdx)));
        }

        public PsiElement resolve() {
            return this.getElement();
        }

        public Object @NotNull [] getVariants() {
            ArrayList<String> prefixes = new ArrayList<String>(Arrays.asList(ConfigReferenceProvider.CLASSPATH_PREFIX, ConfigReferenceProvider.FILE_PREFIX, ConfigReferenceProvider.CONFIG_TREE_PREFIX, ConfigReferenceProvider.CONFIG_SERVER_PREFIX));
            if (!this.myOptional) {
                prefixes.add(ConfigReferenceProvider.OPTIONAL_PREFIX);
            }
            Object[] objectArray = ContainerUtil.map2Array(prefixes, prefix -> LookupElementBuilder.create((String)prefix).bold());
            if (objectArray == null) {
                PrefixReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/ConfigReferenceProvider$PrefixReference", "getVariants"));
        }
    }
}

