/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.lang.jvm.JvmModifier;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.RelaxedNames;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.spring.boot.application.metadata.ClassContent;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0003*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a)\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0010\"\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u0011\u001a\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a8\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u00192\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001a0\u001c2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a\u0014\u0010 \u001a\u0004\u0018\u00010\u00032\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"UNDERSCORE_REGEX", "Lkotlin/text/Regex;", "toKeyName", "", "s", "getDeclaredAttributeValueAsString", "Lcom/intellij/psi/PsiAnnotation;", "attribute", "isGetter", "", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "isSetter", "isBuilderMethodReturnType", "hasPrefix", "prefixes", "", "(Lcom/intellij/psi/PsiMethod;[Ljava/lang/String;)Z", "getKeyNameByGetterOrGetter", "hasGetterOrSetterModifiers", "buildClassContent", "Lcom/intellij/spring/boot/application/metadata/ClassContent;", "configPsiClass", "Lcom/intellij/psi/PsiClass;", "getKeyHints", "Lkotlin/Pair;", "Lcom/intellij/microservices/jvm/config/MetaConfigKey$ItemHint;", "keyHints", "", "keyName", "accessType", "Lcom/intellij/microservices/jvm/config/MetaConfigKey$AccessType;", "getDeclarationTypeName", "psiModifierListOwner", "Lcom/intellij/psi/PsiModifierListOwner;", "intellij.spring.boot.core"})
@SourceDebugExtension(value={"SMAP\nSpringBootConfigKeysCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBootConfigKeysCollector.kt\ncom/intellij/spring/boot/application/metadata/SpringBootConfigKeysCollectorKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,581:1\n13225#2,2:582\n9098#2,2:584\n9359#2,4:586\n14060#2,2:590\n1#3:592\n*S KotlinDebug\n*F\n+ 1 SpringBootConfigKeysCollector.kt\ncom/intellij/spring/boot/application/metadata/SpringBootConfigKeysCollectorKt\n*L\n520#1:582,2\n541#1:584,2\n541#1:586,4\n545#1:590,2\n*E\n"})
public final class SpringBootConfigKeysCollectorKt {
    @NotNull
    private static final Regex UNDERSCORE_REGEX = new Regex("\\w+(?:_\\w+)+");

    private static final String toKeyName(String s) {
        String string;
        if (UNDERSCORE_REGEX.matches((CharSequence)s)) {
            String string2 = RelaxedNames.underscoreToHyphen((String)s);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"underscoreToHyphen(...)");
        } else {
            String string3 = RelaxedNames.camelCaseToHyphen((String)s);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"camelCaseToHyphen(...)");
        }
        return string;
    }

    private static final String getDeclaredAttributeValueAsString(PsiAnnotation $this$getDeclaredAttributeValueAsString, String attribute) {
        UExpression uExpression;
        PsiAnnotationMemberValue psiAnnotationMemberValue = $this$getDeclaredAttributeValueAsString.findDeclaredAttributeValue(attribute);
        return psiAnnotationMemberValue != null && (uExpression = (UExpression)UastContextKt.toUElement((PsiElement)((PsiElement)psiAnnotationMemberValue), UExpression.class)) != null ? UastUtils.evaluateString((UExpression)uExpression) : null;
    }

    private static final boolean isGetter(PsiMethod psiMethod) {
        String[] stringArray = new String[]{"get", "is"};
        return SpringBootConfigKeysCollectorKt.hasPrefix(psiMethod, stringArray) && SpringBootConfigKeysCollectorKt.hasGetterOrSetterModifiers(psiMethod) && !psiMethod.hasParameters() && psiMethod.getReturnType() != null;
    }

    private static final boolean isSetter(PsiMethod psiMethod) {
        String[] stringArray = new String[]{"set"};
        return SpringBootConfigKeysCollectorKt.hasPrefix(psiMethod, stringArray) && SpringBootConfigKeysCollectorKt.hasGetterOrSetterModifiers(psiMethod) && psiMethod.getParameterList().getParameters().length == 1 && (Intrinsics.areEqual((Object)psiMethod.getReturnType(), (Object)PsiTypes.voidType()) || SpringBootConfigKeysCollectorKt.isBuilderMethodReturnType(psiMethod));
    }

    private static final boolean isBuilderMethodReturnType(PsiMethod psiMethod) {
        PsiType psiType = psiMethod.getReturnType();
        if (psiType == null) {
            return false;
        }
        PsiType returnType = psiType;
        PsiClass psiClass = psiMethod.getContainingClass();
        String string = psiClass != null ? psiClass.getQualifiedName() : null;
        if (string == null) {
            string = "";
        }
        return returnType.equalsToText(string);
    }

    private static final boolean hasPrefix(PsiMethod psiMethod, String ... prefixes) {
        boolean bl;
        block1: {
            String[] $this$any$iv = prefixes;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String prefix = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                String string = psiMethod.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.startsWith$default((String)string, (String)prefix, (boolean)false, (int)2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final String getKeyNameByGetterOrGetter(PsiMethod psiMethod) {
        String string;
        String string2 = psiMethod.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String methodName = string2;
        if (StringsKt.startsWith$default((String)methodName, (String)"get", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)methodName, (String)"set", (boolean)false, (int)2, null)) {
            String string3 = methodName.substring(3);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else if (StringsKt.startsWith$default((String)methodName, (String)"is", (boolean)false, (int)2, null)) {
            String string4 = methodName.substring(2);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        } else {
            string = methodName;
        }
        String withoutPrefix = string;
        String string5 = StringUtil.decapitalize((String)withoutPrefix);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"decapitalize(...)");
        return SpringBootConfigKeysCollectorKt.toKeyName(string5);
    }

    private static final boolean hasGetterOrSetterModifiers(PsiMethod psiMethod) {
        return psiMethod.hasModifier(JvmModifier.PUBLIC) && !psiMethod.hasModifier(JvmModifier.STATIC) && !psiMethod.hasModifier(JvmModifier.ABSTRACT);
    }

    /*
     * WARNING - void declaration
     */
    private static final ClassContent buildClassContent(PsiClass configPsiClass) {
        void $this$associateByTo$iv$iv;
        PsiField[] psiFieldArray = configPsiClass.getAllFields();
        Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getAllFields(...)");
        Object[] $this$associateBy$iv = psiFieldArray;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
        Object[] objectArray = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (void element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            PsiField psiField = (PsiField)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            map.put(SpringBootConfigKeysCollectorKt.toKeyName(string), element$iv$iv);
        }
        Map fields = destination$iv$iv;
        Map getters = new LinkedHashMap();
        Map setters = new LinkedHashMap();
        PsiMethod[] psiMethodArray = configPsiClass.getAllMethods();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getAllMethods(...)");
        Object[] $this$forEach$iv = psiMethodArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiMethod psiMethod = (PsiMethod)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)psiMethod);
            if (SpringBootConfigKeysCollectorKt.isGetter(psiMethod)) {
                getters.put(SpringBootConfigKeysCollectorKt.getKeyNameByGetterOrGetter(psiMethod), psiMethod);
                continue;
            }
            if (!SpringBootConfigKeysCollectorKt.isSetter(psiMethod)) continue;
            setters.put(SpringBootConfigKeysCollectorKt.getKeyNameByGetterOrGetter(psiMethod), psiMethod);
        }
        return new ClassContent(fields, getters, setters);
    }

    private static final Pair<MetaConfigKey.ItemHint, MetaConfigKey.ItemHint> getKeyHints(Map<String, MetaConfigKey.ItemHint> keyHints, String keyName, MetaConfigKey.AccessType accessType) {
        MetaConfigKey.ItemHint valueHint = null;
        MetaConfigKey.ItemHint keyHint = null;
        if (accessType == MetaConfigKey.AccessType.MAP) {
            MetaConfigKey.ItemHint itemHint = keyHints.get(keyName + ".values");
            if (itemHint == null) {
                MetaConfigKey.ItemHint itemHint2 = MetaConfigKey.ItemHint.NONE;
                itemHint = itemHint2;
                Intrinsics.checkNotNullExpressionValue((Object)itemHint2, (String)"NONE");
            }
            valueHint = itemHint;
            MetaConfigKey.ItemHint itemHint3 = keyHints.get(keyName + ".keys");
            if (itemHint3 == null) {
                MetaConfigKey.ItemHint itemHint4 = MetaConfigKey.ItemHint.NONE;
                itemHint3 = itemHint4;
                Intrinsics.checkNotNullExpressionValue((Object)itemHint4, (String)"NONE");
            }
            keyHint = itemHint3;
        } else {
            MetaConfigKey.ItemHint itemHint = keyHints.get(keyName);
            if (itemHint == null) {
                MetaConfigKey.ItemHint itemHint5 = MetaConfigKey.ItemHint.NONE;
                itemHint = itemHint5;
                Intrinsics.checkNotNullExpressionValue((Object)itemHint5, (String)"NONE");
            }
            valueHint = itemHint;
            MetaConfigKey.ItemHint itemHint6 = MetaConfigKey.ItemHint.NONE;
            Intrinsics.checkNotNullExpressionValue((Object)itemHint6, (String)"NONE");
            keyHint = itemHint6;
        }
        return TuplesKt.to((Object)valueHint, (Object)keyHint);
    }

    private static final String getDeclarationTypeName(PsiModifierListOwner psiModifierListOwner) {
        Object object;
        PsiModifierListOwner psiModifierListOwner2 = psiModifierListOwner;
        if (psiModifierListOwner2 instanceof PsiQualifiedNamedElement) {
            object = ((PsiQualifiedNamedElement)psiModifierListOwner).getQualifiedName();
        } else if (psiModifierListOwner2 instanceof PsiMember) {
            String string;
            PsiClass psiClass = ((PsiMember)psiModifierListOwner).getContainingClass();
            if (psiClass != null) {
                PsiClass it = psiClass;
                boolean bl = false;
                string = it.getQualifiedName() + ".";
            } else {
                string = null;
            }
            object = string + ((PsiMember)psiModifierListOwner).getName();
        } else {
            object = psiModifierListOwner2 instanceof PsiNamedElement ? ((PsiNamedElement)psiModifierListOwner).getName() : null;
        }
        return object;
    }

    public static final /* synthetic */ String access$getDeclarationTypeName(PsiModifierListOwner psiModifierListOwner) {
        return SpringBootConfigKeysCollectorKt.getDeclarationTypeName(psiModifierListOwner);
    }

    public static final /* synthetic */ String access$toKeyName(String s) {
        return SpringBootConfigKeysCollectorKt.toKeyName(s);
    }

    public static final /* synthetic */ Pair access$getKeyHints(Map keyHints, String keyName, MetaConfigKey.AccessType accessType) {
        return SpringBootConfigKeysCollectorKt.getKeyHints(keyHints, keyName, accessType);
    }

    public static final /* synthetic */ ClassContent access$buildClassContent(PsiClass configPsiClass) {
        return SpringBootConfigKeysCollectorKt.buildClassContent(configPsiClass);
    }

    public static final /* synthetic */ String access$getDeclaredAttributeValueAsString(PsiAnnotation $receiver, String attribute) {
        return SpringBootConfigKeysCollectorKt.getDeclaredAttributeValueAsString($receiver, attribute);
    }

    public static final /* synthetic */ boolean access$isSetter(PsiMethod psiMethod) {
        return SpringBootConfigKeysCollectorKt.isSetter(psiMethod);
    }

    public static final /* synthetic */ String access$getKeyNameByGetterOrGetter(PsiMethod psiMethod) {
        return SpringBootConfigKeysCollectorKt.getKeyNameByGetterOrGetter(psiMethod);
    }
}

