/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.intellij.microservices.jvm.config.ConfigKeyDocumentationProviderBase;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.RelaxedNames;
import com.intellij.microservices.jvm.config.utils.MetaConfigFileUtilsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyImpl;
import com.intellij.spring.boot.application.metadata.SpringBootConfigKetPathBeanPropertyResolver;
import com.intellij.spring.boot.application.metadata.SpringBootConfigKeyDeclarationPsiElement;
import com.intellij.spring.boot.application.metadata.SpringBootConfigKeyGroupImpl;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.FactoryMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SpringBootConfigurationMetadataParser {
    private static final Logger LOG = Logger.getInstance(SpringBootConfigurationMetadataParser.class);
    private static final String UNKNOWN_LIBRARY_NAME = "<unknown>";
    private final PsiFile myJsonPsiFile;
    @Nullable
    private final File myLocalJsonFile;
    private final String myLibraryName;
    private final Caching myCaching;
    private final NotNullLazyValue<Map<String, PsiElement>> myAdditionalConfigTargets;
    private static final Pair<PsiType, MetaConfigKey.AccessType> DUMMY_TYPE = Pair.create((Object)PsiTypes.nullType(), (Object)MetaConfigKey.AccessType.NORMAL);

    public SpringBootConfigurationMetadataParser(@NotNull PsiFile jsonPsiFile) {
        if (jsonPsiFile == null) {
            SpringBootConfigurationMetadataParser.$$$reportNull$$$0(0);
        }
        this.myJsonPsiFile = jsonPsiFile;
        this.myLocalJsonFile = null;
        String libraryName = MetaConfigFileUtilsKt.getLibraryOrContainingJarName((Project)jsonPsiFile.getProject(), (VirtualFile)jsonPsiFile.getVirtualFile());
        this.myLibraryName = libraryName != null ? libraryName : UNKNOWN_LIBRARY_NAME;
        this.myCaching = new Caching(jsonPsiFile.getResolveScope());
        this.myAdditionalConfigTargets = NotNullLazyValue.lazy(() -> Collections.emptyMap());
    }

    public List<SpringBootConfigKeyGroupImpl> getGroups() {
        ArrayList<SpringBootConfigKeyGroupImpl> result = new ArrayList<SpringBootConfigKeyGroupImpl>();
        JsonObject rootObject = this.getRootObject();
        if (rootObject == null) {
            return result;
        }
        JsonElement groupsElement = rootObject.get("groups");
        if (groupsElement == null) {
            return result;
        }
        for (JsonElement groupElement : groupsElement.getAsJsonArray()) {
            JsonObject groupObject = groupElement.getAsJsonObject();
            String groupName = SpringBootConfigurationMetadataParser.getStringLiteral(groupObject, "name");
            String classFqn = SpringBootConfigurationMetadataParser.getStringLiteral(groupObject, "type");
            result.add(new SpringBootConfigKeyGroupImpl(groupName, classFqn, (PsiModifierListOwner)this.myCaching.myCachedClass.get(classFqn)));
        }
        return result;
    }

    public boolean processKeys(@NotNull Module module, @NotNull Processor<MetaConfigKey> processor) {
        JsonObject rootObject;
        if (module == null) {
            SpringBootConfigurationMetadataParser.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            SpringBootConfigurationMetadataParser.$$$reportNull$$$0(2);
        }
        if ((rootObject = this.getRootObject()) == null) {
            return true;
        }
        JsonElement propertiesElement = rootObject.get("properties");
        if (propertiesElement == null) {
            return true;
        }
        JsonArray properties = propertiesElement.getAsJsonArray();
        Map<String, MetaConfigKey.ItemHint> hints = SpringBootConfigurationMetadataParser.getItemHints(rootObject);
        SpringBootConfigKetPathBeanPropertyResolver resolver = new SpringBootConfigKetPathBeanPropertyResolver(module);
        for (JsonElement element : properties) {
            Pair<MetaConfigKey.DeclarationResolveResult, PsiElement> declarationPair;
            MetaConfigKey.ItemHint keyHint;
            MetaConfigKey.ItemHint valueHint;
            JsonObject property = element.getAsJsonObject();
            String configKeyName = SpringBootConfigurationMetadataParser.getStringLiteral(property, "name");
            if (StringUtil.isEmptyOrSpaces((String)configKeyName)) continue;
            String typeLiteral = SpringBootConfigurationMetadataParser.getStringLiteral(property, "type");
            String finalType = Comparing.strEqual((String)typeLiteral, (String)"java.util.Properties") ? "java.util.Map<java.lang.String,java.lang.String>" : typeLiteral;
            Pair<PsiType, MetaConfigKey.AccessType> typeWithAccess = SpringBootConfigurationMetadataParser.getPsiTypeToAccessType(module.getProject(), finalType);
            PsiType type = ((PsiType)typeWithAccess.getFirst()).equals(DUMMY_TYPE.getFirst()) ? null : (PsiType)typeWithAccess.getFirst();
            MetaConfigKey.AccessType accessType = (MetaConfigKey.AccessType)typeWithAccess.getSecond();
            if (accessType == MetaConfigKey.AccessType.MAP) {
                valueHint = hints.get(configKeyName + ".values");
                keyHint = hints.get(configKeyName + ".keys");
            } else {
                valueHint = hints.get(configKeyName);
                keyHint = MetaConfigKey.ItemHint.NONE;
            }
            if ((declarationPair = this.getDeclaration(property, configKeyName, type, module)) == null || declarationPair.second == null) continue;
            ((PsiElement)declarationPair.second).putUserData(ConfigKeyDocumentationProviderBase.CONFIG_KEY_DECLARATION_MODULE, (Object)module);
            SpringBootApplicationMetaConfigKeyImpl key = new SpringBootApplicationMetaConfigKeyImpl((PsiElement)declarationPair.second, (MetaConfigKey.DeclarationResolveResult)declarationPair.first, configKeyName, SpringBootConfigurationMetadataParser.getDescription(property), (Lazy<String>)LazyKt.lazyOf((Object)SpringBootConfigurationMetadataParser.getValueAsString(property)), (Lazy<MetaConfigKey.Deprecation>)LazyKt.lazyOf((Object)SpringBootConfigurationMetadataParser.getDeprecation(property)), type, accessType, (MetaConfigKey.ItemHint)ObjectUtils.notNull((Object)valueHint, (Object)MetaConfigKey.ItemHint.NONE), (MetaConfigKey.ItemHint)ObjectUtils.notNull((Object)keyHint, (Object)MetaConfigKey.ItemHint.NONE), resolver, SpringBootConfigurationMetadataParser.getStringLiteral(property, "sourceType"));
            if (processor.process((Object)key)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject getRootObject() {
        Ref path = Ref.create();
        try (JsonReader reader = this.openReader((Ref<String>)path);){
            reader.setLenient(true);
            JsonElement parse = JsonParser.parseReader((JsonReader)reader);
            if (!parse.isJsonObject()) {
                JsonObject jsonObject2 = null;
                return jsonObject2;
            }
            JsonObject jsonObject = parse.getAsJsonObject();
            return jsonObject;
        }
        catch (ProcessCanceledException | IndexNotReadyException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.info("Error parsing Spring Boot metadata JSON from " + (String)path.get(), e);
            return null;
        }
    }

    private JsonReader openReader(Ref<String> pathRef) throws IOException {
        if (this.myJsonPsiFile != null) {
            VirtualFile file = this.myJsonPsiFile.getVirtualFile();
            pathRef.set((Object)file.getPath());
            return new JsonReader((Reader)new InputStreamReader((InputStream)new BufferedInputStream(file.getInputStream()), StandardCharsets.UTF_8));
        }
        assert (this.myLocalJsonFile != null);
        pathRef.set((Object)this.myLocalJsonFile.getPath());
        return new JsonReader((Reader)new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(this.myLocalJsonFile)), StandardCharsets.UTF_8));
    }

    @Nullable
    private static String getValueAsString(JsonObject object) {
        JsonElement propertyElement = object.get("defaultValue");
        if (propertyElement == null) {
            return null;
        }
        if (propertyElement.isJsonPrimitive()) {
            return propertyElement.getAsJsonPrimitive().getAsString();
        }
        if (!propertyElement.isJsonArray()) {
            return null;
        }
        JsonArray array = propertyElement.getAsJsonArray();
        SmartList valueList = new SmartList();
        for (JsonElement jsonValue : array) {
            if (!jsonValue.isJsonPrimitive()) continue;
            valueList.add(jsonValue.getAsJsonPrimitive().getAsString());
        }
        return StringUtil.join((Collection)valueList, (String)", ");
    }

    @Nullable
    private Pair<MetaConfigKey.DeclarationResolveResult, PsiElement> getDeclaration(JsonObject entry, @NotNull String configKeyName, PsiType type, Module module) {
        String sourceTypeText;
        if (configKeyName == null) {
            SpringBootConfigurationMetadataParser.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)(sourceTypeText = SpringBootConfigurationMetadataParser.getStringLiteral(entry, "sourceType")))) {
            return this.getFallbackDeclaration(configKeyName, type, false);
        }
        PsiClass sourceTypeClass = this.myCaching.myCachedClass.get(sourceTypeText);
        if (sourceTypeClass == null) {
            return this.getFallbackDeclaration(configKeyName, type, true);
        }
        return Pair.pair((Object)MetaConfigKey.DeclarationResolveResult.PROPERTY, (Object)((Object)new SpringBootConfigKeyDeclarationPsiElement(this.myLibraryName, (PsiElement)sourceTypeClass, SpringBootConfigurationMetadataParser.findPropertyNavigationTarget(sourceTypeClass, configKeyName, module), configKeyName, sourceTypeText, type)));
    }

    @Nullable
    private Pair<MetaConfigKey.DeclarationResolveResult, PsiElement> getFallbackDeclaration(@NotNull String configKeyName, PsiType type, boolean unresolvedSourceTypeClass) {
        if (configKeyName == null) {
            SpringBootConfigurationMetadataParser.$$$reportNull$$$0(4);
        }
        PsiElement additionalTarget = (PsiElement)((Map)this.myAdditionalConfigTargets.getValue()).get(configKeyName);
        if (this.myJsonPsiFile != null) {
            return Pair.pair((Object)(unresolvedSourceTypeClass ? MetaConfigKey.DeclarationResolveResult.JSON_UNRESOLVED_SOURCE_TYPE : MetaConfigKey.DeclarationResolveResult.JSON), (Object)((Object)new SpringBootConfigKeyDeclarationPsiElement(this.myLibraryName, (PsiElement)this.myJsonPsiFile, (PsiElement)ObjectUtils.chooseNotNull((Object)additionalTarget, (Object)this.myJsonPsiFile), configKeyName, configKeyName, type)));
        }
        if (additionalTarget == null) {
            return null;
        }
        return Pair.pair((Object)MetaConfigKey.DeclarationResolveResult.ADDITIONAL_JSON, (Object)((Object)new SpringBootConfigKeyDeclarationPsiElement(this.myLibraryName, additionalTarget, additionalTarget, configKeyName, configKeyName, type)));
    }

    @NotNull
    public static PsiElement findPropertyNavigationTarget(@NotNull PsiClass sourceTypeClass, String configKeyName, Module module) {
        if (sourceTypeClass == null) {
            SpringBootConfigurationMetadataParser.$$$reportNull$$$0(5);
        }
        String propertyName = RelaxedNames.dashedPropertyNameToCamelCase((String)configKeyName);
        PsiMethod constructor = SpringBootConfigKetPathBeanPropertyResolver.getBindingConstructor(sourceTypeClass, module, null);
        if (constructor != null) {
            for (PsiParameter parameter : constructor.getParameterList().getParameters()) {
                if (!propertyName.equals(parameter.getName())) continue;
                PsiParameter psiParameter = parameter;
                if (psiParameter == null) {
                    SpringBootConfigurationMetadataParser.$$$reportNull$$$0(6);
                }
                return psiParameter;
            }
            PsiClass psiClass = sourceTypeClass;
            if (psiClass == null) {
                SpringBootConfigurationMetadataParser.$$$reportNull$$$0(7);
            }
            return psiClass;
        }
        PsiMethod setter = PropertyUtilBase.findPropertySetter((PsiClass)sourceTypeClass, (String)propertyName, (boolean)false, (boolean)true);
        if (setter != null) {
            PsiMethod psiMethod = setter;
            if (psiMethod == null) {
                SpringBootConfigurationMetadataParser.$$$reportNull$$$0(8);
            }
            return psiMethod;
        }
        PsiMethod getter = PropertyUtilBase.findPropertyGetter((PsiClass)sourceTypeClass, (String)propertyName, (boolean)false, (boolean)true, (boolean)true);
        Object object = getter != null ? getter : sourceTypeClass;
        if (object == null) {
            SpringBootConfigurationMetadataParser.$$$reportNull$$$0(9);
        }
        return object;
    }

    private static MetaConfigKey.DescriptionText getDescription(JsonObject property) {
        String descriptionText = SpringBootConfigurationMetadataParser.getStringLiteral(property, "description");
        if (descriptionText == null) {
            return MetaConfigKey.DescriptionText.NONE;
        }
        return new MetaConfigKey.DescriptionText(descriptionText);
    }

    private static MetaConfigKey.Deprecation getDeprecation(JsonObject property) {
        JsonObject deprecationObject = property.getAsJsonObject("deprecation");
        if (deprecationObject != null) {
            String reasonText = SpringBootConfigurationMetadataParser.getStringLiteral(deprecationObject, "reason");
            MetaConfigKey.DescriptionText reason = reasonText == null ? MetaConfigKey.DescriptionText.NONE : new MetaConfigKey.DescriptionText(reasonText);
            MetaConfigKey.Deprecation.DeprecationLevel level = MetaConfigKey.Deprecation.DeprecationLevel.WARNING;
            String levelLiteral = SpringBootConfigurationMetadataParser.getStringLiteral(deprecationObject, "level");
            MetaConfigKey.Deprecation.DeprecationLevel parsedLevel = MetaConfigKey.Deprecation.DeprecationLevel.parse((String)levelLiteral);
            if (parsedLevel != null) {
                level = parsedLevel;
            }
            String replacement = SpringBootConfigurationMetadataParser.getStringLiteral(deprecationObject, "replacement");
            return new MetaConfigKey.Deprecation(reason, level, replacement);
        }
        JsonPrimitive deprecatedProperty = property.getAsJsonPrimitive("deprecated");
        if (deprecatedProperty != null && deprecatedProperty.getAsBoolean()) {
            return MetaConfigKey.Deprecation.DEPRECATED_WITHOUT_REASON;
        }
        return MetaConfigKey.Deprecation.NOT_DEPRECATED;
    }

    public static Map<String, MetaConfigKey.ItemHint> getItemHints(JsonObject rootObject) {
        JsonElement hintsElement = rootObject.get("hints");
        if (hintsElement == null) {
            return Collections.emptyMap();
        }
        HashMap<String, MetaConfigKey.ItemHint> itemHintsMap = new HashMap<String, MetaConfigKey.ItemHint>();
        for (JsonElement value : hintsElement.getAsJsonArray()) {
            JsonObject entry = value.getAsJsonObject();
            String nameValue = SpringBootConfigurationMetadataParser.getStringLiteral(entry, "name");
            if (nameValue == null) continue;
            itemHintsMap.put(nameValue, SpringBootConfigurationMetadataParser.createItemHint(entry));
        }
        return itemHintsMap;
    }

    private static MetaConfigKey.ItemHint createItemHint(JsonObject entry) {
        List<MetaConfigKey.ValueProvider> providers = SpringBootConfigurationMetadataParser.getItemHintProviders(entry);
        List<MetaConfigKey.ValueHint> values = SpringBootConfigurationMetadataParser.getItemHintValues(entry);
        return new MetaConfigKey.ItemHint(providers, values);
    }

    private static List<MetaConfigKey.ValueProvider> getItemHintProviders(JsonObject entry) {
        JsonElement providersObject = entry.get("providers");
        if (providersObject == null) {
            return Collections.emptyList();
        }
        SmartList providers = new SmartList();
        for (JsonElement arrayValue : providersObject.getAsJsonArray()) {
            JsonObject providerObject;
            String name;
            if (!arrayValue.isJsonObject() || (name = SpringBootConfigurationMetadataParser.getStringLiteral(providerObject = arrayValue.getAsJsonObject(), "name")) == null) continue;
            Map<String, String> parameters = SpringBootConfigurationMetadataParser.getItemHintProviderParameters(providerObject);
            providers.add(new MetaConfigKey.ValueProvider(name, parameters));
        }
        return providers;
    }

    private static Map<String, String> getItemHintProviderParameters(JsonObject entry) {
        JsonElement parametersProperty = entry.get("parameters");
        if (parametersProperty == null || !parametersProperty.isJsonObject()) {
            return Collections.emptyMap();
        }
        JsonObject parametersObject = parametersProperty.getAsJsonObject();
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        for (Map.Entry parameterProperty : parametersObject.entrySet()) {
            JsonElement value = (JsonElement)parameterProperty.getValue();
            if (value == null || !value.isJsonPrimitive()) continue;
            JsonPrimitive primitive = value.getAsJsonPrimitive();
            parameters.put((String)parameterProperty.getKey(), primitive.getAsString());
        }
        return parameters;
    }

    private static List<MetaConfigKey.ValueHint> getItemHintValues(JsonObject entry) {
        JsonElement valuesObject = entry.get("values");
        if (valuesObject == null || !valuesObject.isJsonArray()) {
            return Collections.emptyList();
        }
        SmartList values = new SmartList();
        for (JsonElement arrayValue : valuesObject.getAsJsonArray()) {
            JsonObject valueObject;
            String value;
            if (!arrayValue.isJsonObject() || (value = SpringBootConfigurationMetadataParser.getStringLiteral(valueObject = arrayValue.getAsJsonObject(), "value")) == null) continue;
            values.add(new MetaConfigKey.ValueHint(value, SpringBootConfigurationMetadataParser.getDescription(valueObject)));
        }
        return values;
    }

    @Nullable
    private static String getStringLiteral(JsonObject object, String propertyName) {
        JsonElement property = object.get(propertyName);
        return property != null ? property.getAsString() : null;
    }

    private static Pair<PsiType, MetaConfigKey.AccessType> getPsiTypeToAccessType(Project project, String type) {
        Map myCachedTypes = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            PsiElementFactory myElementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            ConcurrentMap myFactoryMap = ConcurrentFactoryMap.createMap(arg_0 -> SpringBootConfigurationMetadataParser.lambda$getPsiTypeToAccessType$1((PsiJavaParserFacade)myElementFactory, arg_0));
            return CachedValueProvider.Result.create((Object)myFactoryMap, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        return (Pair)myCachedTypes.get(type);
    }

    private static /* synthetic */ Pair lambda$getPsiTypeToAccessType$1(PsiJavaParserFacade myElementFactory, String key) {
        if (key == null) {
            return DUMMY_TYPE;
        }
        try {
            PsiType psiType = myElementFactory.createTypeFromText(key.replace('$', '.'), null);
            return Pair.create((Object)psiType, (Object)MetaConfigKey.AccessType.forPsiType((PsiType)psiType));
        }
        catch (IncorrectOperationException e) {
            return DUMMY_TYPE;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonPsiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKeyName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceTypeClass";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findPropertyNavigationTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processKeys";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaration";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFallbackDeclaration";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findPropertyNavigationTarget";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    private static final class Caching {
        private final Map<String, PsiClass> myCachedClass;

        private Caching(GlobalSearchScope scope) {
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)Objects.requireNonNull(scope.getProject()));
            this.myCachedClass = FactoryMap.create(key -> javaPsiFacade.findClass(key.replace('$', '.'), scope));
        }
    }
}

