/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.exasol.generator;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelper;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.AlterProducerBase;
import com.intellij.database.dialects.base.generator.producers.BaseProducersKt;
import com.intellij.database.dialects.base.generator.producers.CreateProducer;
import com.intellij.database.dialects.base.generator.producers.DropProducer;
import com.intellij.database.dialects.base.generator.producers.DropUnknown;
import com.intellij.database.dialects.exasol.generator.producers.ExaAlterConnection;
import com.intellij.database.dialects.exasol.generator.producers.ExaAlterDatabase;
import com.intellij.database.dialects.exasol.generator.producers.ExaAlterForeignKey;
import com.intellij.database.dialects.exasol.generator.producers.ExaAlterForeignTable;
import com.intellij.database.dialects.exasol.generator.producers.ExaAlterForeignTableColumn;
import com.intellij.database.dialects.exasol.generator.producers.ExaAlterIndex;
import com.intellij.database.dialects.exasol.generator.producers.ExaAlterKey;
import com.intellij.database.dialects.exasol.generator.producers.ExaAlterRole;
import com.intellij.database.dialects.exasol.generator.producers.ExaAlterRoutine;
import com.intellij.database.dialects.exasol.generator.producers.ExaAlterSchema;
import com.intellij.database.dialects.exasol.generator.producers.ExaAlterScript;
import com.intellij.database.dialects.exasol.generator.producers.ExaAlterTable;
import com.intellij.database.dialects.exasol.generator.producers.ExaAlterTableColumn;
import com.intellij.database.dialects.exasol.generator.producers.ExaAlterUser;
import com.intellij.database.dialects.exasol.generator.producers.ExaAlterView;
import com.intellij.database.dialects.exasol.generator.producers.ExaAlterViewColumn;
import com.intellij.database.dialects.exasol.generator.producers.ExaAlterVirtualSchema;
import com.intellij.database.dialects.exasol.generator.producers.ExaCreateConnection;
import com.intellij.database.dialects.exasol.generator.producers.ExaCreateForeignKey;
import com.intellij.database.dialects.exasol.generator.producers.ExaCreateForeignTable;
import com.intellij.database.dialects.exasol.generator.producers.ExaCreateForeignTableColumn;
import com.intellij.database.dialects.exasol.generator.producers.ExaCreateIndex;
import com.intellij.database.dialects.exasol.generator.producers.ExaCreateKey;
import com.intellij.database.dialects.exasol.generator.producers.ExaCreateRole;
import com.intellij.database.dialects.exasol.generator.producers.ExaCreateRoutine;
import com.intellij.database.dialects.exasol.generator.producers.ExaCreateSchema;
import com.intellij.database.dialects.exasol.generator.producers.ExaCreateScript;
import com.intellij.database.dialects.exasol.generator.producers.ExaCreateTable;
import com.intellij.database.dialects.exasol.generator.producers.ExaCreateTableColumn;
import com.intellij.database.dialects.exasol.generator.producers.ExaCreateUser;
import com.intellij.database.dialects.exasol.generator.producers.ExaCreateView;
import com.intellij.database.dialects.exasol.generator.producers.ExaCreateViewColumn;
import com.intellij.database.dialects.exasol.generator.producers.ExaCreateVirtualSchema;
import com.intellij.database.dialects.exasol.generator.producers.ExaDropConnection;
import com.intellij.database.dialects.exasol.generator.producers.ExaDropForeignKey;
import com.intellij.database.dialects.exasol.generator.producers.ExaDropForeignTableColumn;
import com.intellij.database.dialects.exasol.generator.producers.ExaDropIndex;
import com.intellij.database.dialects.exasol.generator.producers.ExaDropKey;
import com.intellij.database.dialects.exasol.generator.producers.ExaDropRole;
import com.intellij.database.dialects.exasol.generator.producers.ExaDropRoutine;
import com.intellij.database.dialects.exasol.generator.producers.ExaDropSchema;
import com.intellij.database.dialects.exasol.generator.producers.ExaDropScript;
import com.intellij.database.dialects.exasol.generator.producers.ExaDropTable;
import com.intellij.database.dialects.exasol.generator.producers.ExaDropTableColumn;
import com.intellij.database.dialects.exasol.generator.producers.ExaDropUser;
import com.intellij.database.dialects.exasol.generator.producers.ExaDropView;
import com.intellij.database.dialects.exasol.generator.producers.ExaDropVirtualSchema;
import com.intellij.database.dialects.exasol.model.ExaConnection;
import com.intellij.database.dialects.exasol.model.ExaDatabase;
import com.intellij.database.dialects.exasol.model.ExaForeignKey;
import com.intellij.database.dialects.exasol.model.ExaForeignTable;
import com.intellij.database.dialects.exasol.model.ExaForeignTableColumn;
import com.intellij.database.dialects.exasol.model.ExaIndex;
import com.intellij.database.dialects.exasol.model.ExaKey;
import com.intellij.database.dialects.exasol.model.ExaRole;
import com.intellij.database.dialects.exasol.model.ExaRoutine;
import com.intellij.database.dialects.exasol.model.ExaSchema;
import com.intellij.database.dialects.exasol.model.ExaScript;
import com.intellij.database.dialects.exasol.model.ExaTable;
import com.intellij.database.dialects.exasol.model.ExaTableColumn;
import com.intellij.database.dialects.exasol.model.ExaUser;
import com.intellij.database.dialects.exasol.model.ExaView;
import com.intellij.database.dialects.exasol.model.ExaViewColumn;
import com.intellij.database.dialects.exasol.model.ExaVirtualSchema;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.script.generator.ScriptingOption;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0014\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\rH\u0016J\u001c\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001c\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!H\u0016J\u0014\u0010\"\u001a\u00020\u00112\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$H\u0016R\"\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\"\u0010\n\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lcom/intellij/database/dialects/exasol/generator/ExaScriptGeneratorHelper;", "Lcom/intellij/database/dialects/base/generator/ScriptGeneratorHelper;", "<init>", "()V", "supportsCreateOrReplace", "", "Lcom/intellij/database/model/ObjectKind;", "kotlin.jvm.PlatformType", "getSupportsCreateOrReplace", "()Ljava/util/Set;", "supportsCreateIfNotExists", "getSupportsCreateIfNotExists", "statementDelimiterStr", "", "getStatementDelimiterStr", "()Ljava/lang/String;", "statementDelimiterOwnsLine", "", "getStatementDelimiterOwnsLine", "()Z", "commentStr", "comment", "createProducerImpl", "Lcom/intellij/database/dialects/base/generator/producers/CreateProducer;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "createDropProducerImpl", "Lcom/intellij/database/dialects/base/generator/producers/DropProducer;", "createAlterProducerImpl", "Lcom/intellij/database/dialects/base/generator/producers/AlterProducerBase;", "elements", "Lcom/intellij/database/model/ElementAlteration;", "isOptionSupported", "option", "Lcom/intellij/database/script/generator/ScriptingOption;", "intellij.database.dialects.exasol"})
public final class ExaScriptGeneratorHelper
extends ScriptGeneratorHelper {
    @NotNull
    public static final ExaScriptGeneratorHelper INSTANCE = new ExaScriptGeneratorHelper();
    @NotNull
    private static final Set<ObjectKind> supportsCreateOrReplace;
    @NotNull
    private static final Set<ObjectKind> supportsCreateIfNotExists;
    @NotNull
    private static final String statementDelimiterStr;
    private static final boolean statementDelimiterOwnsLine;

    private ExaScriptGeneratorHelper() {
        Dbms dbms = Dbms.EXASOL;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"EXASOL");
        super(dbms);
    }

    @NotNull
    protected Set<ObjectKind> getSupportsCreateOrReplace() {
        return supportsCreateOrReplace;
    }

    @NotNull
    protected Set<ObjectKind> getSupportsCreateIfNotExists() {
        return supportsCreateIfNotExists;
    }

    @NotNull
    public String getStatementDelimiterStr() {
        return statementDelimiterStr;
    }

    public boolean getStatementDelimiterOwnsLine() {
        return statementDelimiterOwnsLine;
    }

    @NotNull
    public String commentStr(@Nullable String comment) {
        String string = comment;
        if (string == null || (string = ScriptGeneratorHelperKt.getSqlString((String)string)) == null) {
            string = "null";
        }
        return string;
    }

    @NotNull
    public CreateProducer<?> createProducerImpl(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BasicElement basicElement = element;
        return basicElement instanceof ExaScript ? (CreateProducer)new ExaCreateScript(context, (ExaScript)element) : (basicElement instanceof ExaIndex ? (CreateProducer)new ExaCreateIndex(context, (ExaIndex)element) : (basicElement instanceof ExaRoutine ? (CreateProducer)new ExaCreateRoutine(context, (ExaRoutine)element) : (basicElement instanceof ExaUser ? (CreateProducer)new ExaCreateUser(context, (ExaUser)element) : (basicElement instanceof ExaRole ? (CreateProducer)new ExaCreateRole(context, (ExaRole)element) : (basicElement instanceof ExaConnection ? (CreateProducer)new ExaCreateConnection(context, (ExaConnection)element) : (basicElement instanceof ExaVirtualSchema ? (CreateProducer)new ExaCreateVirtualSchema(context, (ExaVirtualSchema)element) : (basicElement instanceof ExaSchema ? (CreateProducer)new ExaCreateSchema(context, (ExaSchema)element) : (basicElement instanceof ExaTable ? (CreateProducer)new ExaCreateTable(context, (ExaTable)element) : (basicElement instanceof ExaTableColumn ? (CreateProducer)new ExaCreateTableColumn(context, (ExaTableColumn)element) : (basicElement instanceof ExaKey ? (CreateProducer)new ExaCreateKey(context, (ExaKey)element) : (basicElement instanceof ExaForeignKey ? (CreateProducer)new ExaCreateForeignKey(context, (ExaForeignKey)element) : (basicElement instanceof ExaView ? (CreateProducer)new ExaCreateView(context, (ExaView)element) : (basicElement instanceof ExaViewColumn ? (CreateProducer)new ExaCreateViewColumn(context, (ExaViewColumn)element) : (basicElement instanceof ExaForeignTable ? (CreateProducer)new ExaCreateForeignTable(context, (ExaForeignTable)element) : (basicElement instanceof ExaForeignTableColumn ? (CreateProducer)new ExaCreateForeignTableColumn(context, (ExaForeignTableColumn)element) : super.createProducerImpl(context, element))))))))))))))));
    }

    @NotNull
    public DropProducer<?> createDropProducerImpl(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BasicElement basicElement = element;
        return basicElement instanceof ExaForeignTable ? (DropProducer)new DropUnknown(context, element) : (basicElement instanceof ExaVirtualSchema ? (DropProducer)new ExaDropVirtualSchema(context, (ExaVirtualSchema)element) : (basicElement instanceof ExaScript ? (DropProducer)new ExaDropScript(context, (ExaScript)element) : (basicElement instanceof ExaIndex ? (DropProducer)new ExaDropIndex(context, (ExaIndex)element) : (basicElement instanceof ExaUser ? (DropProducer)new ExaDropUser(context, (ExaUser)element) : (basicElement instanceof ExaRole ? (DropProducer)new ExaDropRole(context, (ExaRole)element) : (basicElement instanceof ExaConnection ? (DropProducer)new ExaDropConnection(context, (ExaConnection)element) : (basicElement instanceof ExaForeignKey ? (DropProducer)new ExaDropForeignKey(context, (ExaForeignKey)element) : (basicElement instanceof ExaKey ? (DropProducer)new ExaDropKey(context, (ExaKey)element) : (basicElement instanceof ExaTableColumn ? (DropProducer)new ExaDropTableColumn(context, (ExaTableColumn)element) : (basicElement instanceof ExaForeignTableColumn ? (DropProducer)new ExaDropForeignTableColumn(context, (ExaForeignTableColumn)element) : (basicElement instanceof ExaRoutine ? (DropProducer)new ExaDropRoutine(context, (ExaRoutine)element) : (basicElement instanceof ExaView ? (DropProducer)new ExaDropView(context, (ExaView)element) : (basicElement instanceof ExaSchema ? (DropProducer)new ExaDropSchema(context, (ExaSchema)element) : (basicElement instanceof ExaTable ? (DropProducer)new ExaDropTable(context, (ExaTable)element) : super.createDropProducerImpl(context, element)))))))))))))));
    }

    @NotNull
    public AlterProducerBase<?> createAlterProducerImpl(@NotNull ScriptingContext context, @NotNull ElementAlteration<?> elements) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        BasicElement it = elements.getSourceElement();
        boolean bl = false;
        BasicElement basicElement = it;
        return basicElement instanceof ExaDatabase ? (AlterProducerBase)new ExaAlterDatabase(context, (ElementAlteration<? extends ExaDatabase>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof ExaSchema ? (AlterProducerBase)new ExaAlterSchema(context, (ElementAlteration<? extends ExaSchema>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof ExaVirtualSchema ? (AlterProducerBase)new ExaAlterVirtualSchema(context, (ElementAlteration<? extends ExaVirtualSchema>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof ExaForeignTable ? (AlterProducerBase)new ExaAlterForeignTable(context, (ElementAlteration<? extends ExaForeignTable>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof ExaForeignTableColumn ? (AlterProducerBase)new ExaAlterForeignTableColumn(context, (ElementAlteration<? extends ExaForeignTableColumn>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof ExaTable ? (AlterProducerBase)new ExaAlterTable(context, (ElementAlteration<? extends ExaTable>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof ExaTableColumn ? (AlterProducerBase)new ExaAlterTableColumn(context, (ElementAlteration<? extends ExaTableColumn>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof ExaForeignKey ? (AlterProducerBase)new ExaAlterForeignKey(context, (ElementAlteration<? extends ExaForeignKey>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof ExaKey ? (AlterProducerBase)new ExaAlterKey(context, (ElementAlteration<? extends ExaKey>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof ExaView ? (AlterProducerBase)new ExaAlterView(context, (ElementAlteration<? extends ExaView>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof ExaViewColumn ? (AlterProducerBase)new ExaAlterViewColumn(context, (ElementAlteration<? extends ExaViewColumn>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof ExaRoutine ? (AlterProducerBase)new ExaAlterRoutine(context, (ElementAlteration<? extends ExaRoutine>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof ExaScript ? (AlterProducerBase)new ExaAlterScript(context, (ElementAlteration<? extends ExaScript>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof ExaIndex ? (AlterProducerBase)new ExaAlterIndex(context, (ElementAlteration<? extends ExaIndex>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof ExaRole ? (AlterProducerBase)new ExaAlterRole(context, (ElementAlteration<? extends ExaRole>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof ExaUser ? (AlterProducerBase)new ExaAlterUser(context, (ElementAlteration<? extends ExaUser>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof ExaConnection ? (AlterProducerBase)new ExaAlterConnection(context, (ElementAlteration<? extends ExaConnection>)BaseProducersKt.cast(elements, (BasicElement)it)) : super.createAlterProducerImpl(context, elements)))))))))))))))));
    }

    public boolean isOptionSupported(@NotNull ScriptingOption<?> option) {
        Intrinsics.checkNotNullParameter(option, (String)"option");
        ScriptingOption<?> scriptingOption = option;
        return Intrinsics.areEqual(scriptingOption, (Object)ScriptingOptionStatic.CREATE_OR_REPLACE) || Intrinsics.areEqual(scriptingOption, (Object)ScriptingOptionStatic.IF_EXISTS) ? true : super.isOptionSupported(option);
    }

    static {
        Object[] objectArray = new ObjectKind[]{ObjectKind.TABLE, ObjectKind.VIEW, ObjectKind.ROUTINE, ObjectKind.SCRIPT, ObjectKind.CONNECTION};
        supportsCreateOrReplace = SetsKt.setOf((Object[])objectArray);
        supportsCreateIfNotExists = SetsKt.setOf((Object)ObjectKind.SCHEMA);
        statementDelimiterStr = "/";
        statementDelimiterOwnsLine = true;
    }
}

