/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.debug.frame;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebuggerEvaluator;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.icons.AllIcons;
import com.intellij.kotlin.jupyter.core.logging.KotlinNotebookLoggerFactory;
import com.intellij.kotlin.jupyter.core.util.LoggingKt;
import com.intellij.kotlin.jupyter.debug.i18n.KotlinNotebookDebugBundle;
import com.intellij.kotlin.jupyter.debug.session.KotlinNotebookFileDebugSession;
import com.intellij.kotlin.jupyter.debug.util.CommonKt;
import com.intellij.kotlin.jupyter.debug.util.DebugSupportUtilsKt;
import com.intellij.kotlin.jupyter.debug.util.connection.ConnectionCheckUtilsKt;
import com.intellij.kotlin.jupyter.debug.variables.KotlinNotebookSessionVariablesService;
import com.intellij.kotlin.jupyter.debug.variables.NotebookVariablesPerFileStateService;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.sun.jdi.StackFrame;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\f\u001a\u00020\r*\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u000bH\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J\u0014\u0010\u0018\u001a\u00020\u0016*\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/kotlin/jupyter/debug/frame/KotlinNotebookVariablesFrame;", "Lcom/intellij/xdebugger/frame/XStackFrame;", "project", "Lcom/intellij/openapi/project/Project;", "sourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "debugSession", "Lcom/intellij/kotlin/jupyter/debug/session/KotlinNotebookFileDebugSession;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/XSourcePosition;Lcom/intellij/kotlin/jupyter/debug/session/KotlinNotebookFileDebugSession;)V", "evaluator", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "isReadyForComputations", "", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "getEqualityObject", "", "getEvaluator", "getSourcePosition", "computeChildren", "", "node", "showInfoMessage", "message", "", "Companion", "intellij.kotlin.jupyter.debug"})
@SourceDebugExtension(value={"SMAP\nKotlinNotebookVariablesFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookVariablesFrame.kt\ncom/intellij/kotlin/jupyter/debug/frame/KotlinNotebookVariablesFrame\n+ 2 KotlinNotebookLoggerFactory.kt\ncom/intellij/kotlin/jupyter/core/logging/KotlinNotebookLoggerFactoryKt\n*L\n1#1,154:1\n13#2:155\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookVariablesFrame.kt\ncom/intellij/kotlin/jupyter/debug/frame/KotlinNotebookVariablesFrame\n*L\n38#1:155\n*E\n"})
public final class KotlinNotebookVariablesFrame
extends XStackFrame {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Project project;
    @Nullable
    private final XSourcePosition sourcePosition;
    @NotNull
    private final KotlinNotebookFileDebugSession debugSession;
    @Nullable
    private XDebuggerEvaluator evaluator;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Object STACK_FRAME_EQUALITY_OBJECT;

    public KotlinNotebookVariablesFrame(@NotNull Project project, @Nullable XSourcePosition sourcePosition, @NotNull KotlinNotebookFileDebugSession debugSession) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)debugSession), (String)"debugSession");
        this.project = project;
        this.sourcePosition = sourcePosition;
        this.debugSession = debugSession;
    }

    private final boolean isReadyForComputations(XCompositeNode $this$isReadyForComputations, DebugProcessImpl debugProcess) {
        boolean bl;
        if ($this$isReadyForComputations.isObsolete() || debugProcess == null || this.project.isDisposed()) {
            $this$isReadyForComputations.setErrorMessage(KotlinNotebookDebugBundle.message("kotlin.jupyter.debug.node.empty.no.connection.message", new Object[0]));
            bl = false;
        } else if (debugProcess.isInInitialState()) {
            $this$isReadyForComputations.setErrorMessage(KotlinNotebookDebugBundle.message("kotlin.jupyter.debug.node.rebuild.message", new Object[0]));
            bl = false;
        } else if (!ConnectionCheckUtilsKt.isConnectionAlive((DebugProcess)debugProcess)) {
            $this$isReadyForComputations.setErrorMessage(KotlinNotebookDebugBundle.message("kotlin.jupyter.debug.node.empty.not.attached.message", new Object[0]));
            LoggingKt.warnUnderDebug((Logger)LOG, (String)"Process is not attached");
            bl = false;
        } else if (!debugProcess.isEvaluationPossible()) {
            this.showInfoMessage($this$isReadyForComputations, KotlinNotebookDebugBundle.message("kotlin.jupyter.debug.node.rebuild.message", new Object[0]));
            LOG.warn("Paused context is not yet built");
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    @Nullable
    public Object getEqualityObject() {
        return STACK_FRAME_EQUALITY_OBJECT;
    }

    @Nullable
    public XDebuggerEvaluator getEvaluator() {
        if (this.evaluator == null) {
            DebuggerSession debuggerSession = this.debugSession.getDebuggerSession();
            if (debuggerSession == null || (debuggerSession = debuggerSession.getProcess()) == null) {
                return null;
            }
            DebuggerSession debugProcess = debuggerSession;
            StackFrameProxyImpl stackFrameProxyImpl = this.debugSession.getCurrentStackFrameProxy();
            StackFrame stackFrame = stackFrameProxyImpl != null ? stackFrameProxyImpl.getStackFrame() : null;
            JavaStackFrame frameProxy = stackFrame instanceof JavaStackFrame ? (JavaStackFrame)stackFrame : null;
            this.evaluator = (XDebuggerEvaluator)new JavaDebuggerEvaluator((DebugProcessImpl)debugProcess, frameProxy);
        }
        return this.evaluator;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.sourcePosition;
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        DebugProcessImpl debugProcess;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!DebugSupportUtilsKt.getShouldShowNotebookVariables(this.project)) {
            super.computeChildren(node);
            return;
        }
        DebuggerSession debuggerSession = this.debugSession.getDebuggerSession();
        Object object = debugProcess = debuggerSession != null ? debuggerSession.getProcess() : null;
        if (!this.isReadyForComputations(node, debugProcess)) {
            return;
        }
        NotebookVariablesPerFileStateService variablesService = KotlinNotebookSessionVariablesService.Companion.getForFile(this.project, this.debugSession.getVirtualFile());
        EvaluationContextImpl context = this.debugSession.getEvaluationContext();
        if (context == null) {
            node.setErrorMessage(KotlinNotebookDebugBundle.message("kotlin.jupyter.debug.node.no.context.message", new Object[0]));
            Attachment[] attachmentArray = new Attachment[]{CommonKt.createScreeningAttachment(this.debugSession)};
            LoggingKt.errorUnderDebug((Logger)LOG, (String)"Suspended context is null", (Attachment[])attachmentArray);
            return;
        }
        context.getSuspendContext().getManagerThread().invoke(PrioritizedTask.Priority.HIGH, () -> KotlinNotebookVariablesFrame.computeChildren$lambda$0(this, context, variablesService, node));
        super.computeChildren(node);
    }

    private final void showInfoMessage(XCompositeNode $this$showInfoMessage, String message) {
        $this$showInfoMessage.setMessage(message, AllIcons.General.Information, SimpleTextAttributes.REGULAR_ATTRIBUTES, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void computeChildren$lambda$0(KotlinNotebookVariablesFrame this$0, EvaluationContextImpl $context, NotebookVariablesPerFileStateService $variablesService, XCompositeNode $node) {
        DebuggerSession debuggerSession;
        XValueChildrenList variablesState;
        block8: {
            block7: {
                if (!this$0.project.isDisposed()) break block7;
                DebuggerSession debuggerSession2 = this$0.debugSession.getDebuggerSession();
                LoggingKt.warnUnderDebug((Logger)LOG, (String)("Is paused: " + (debuggerSession2 != null ? debuggerSession2.isPaused() : false)));
                return;
            }
            VirtualMachineProxyImpl virtualMachine = $context.getSuspendContext().getVirtualMachineProxy();
            variablesState = $variablesService.buildXValueListForVariablesState((VirtualMachineProxy)virtualMachine, $context);
            if (variablesState.size() != 0) break block8;
            this$0.showInfoMessage($node, KotlinNotebookDebugBundle.message("kotlin.jupyter.debug.node.empty.session.variables.message", new Object[0]));
            DebuggerSession debuggerSession3 = this$0.debugSession.getDebuggerSession();
            LoggingKt.warnUnderDebug((Logger)LOG, (String)("Is paused: " + (debuggerSession3 != null ? debuggerSession3.isPaused() : false)));
            return;
        }
        try {
            $node.addChildren(variablesState, true);
            debuggerSession = this$0.debugSession.getDebuggerSession();
        }
        catch (Exception ex) {
            block9: {
                DebuggerSession debuggerSession4;
                try {
                    if (!ConnectionCheckUtilsKt.isVMDisconnectedException(ex)) break block9;
                    $node.setErrorMessage(KotlinNotebookDebugBundle.message("kotlin.jupyter.debug.node.empty.not.attached.message", new Object[0]));
                    debuggerSession4 = this$0.debugSession.getDebuggerSession();
                }
                catch (Throwable throwable) {
                    DebuggerSession debuggerSession5 = this$0.debugSession.getDebuggerSession();
                    LoggingKt.warnUnderDebug((Logger)LOG, (String)("Is paused: " + (debuggerSession5 != null ? debuggerSession5.isPaused() : false)));
                    throw throwable;
                }
                LoggingKt.warnUnderDebug((Logger)LOG, (String)("Is paused: " + (debuggerSession4 != null ? debuggerSession4.isPaused() : false)));
                return;
            }
            LOG.error("Error during variables state computation: ", (Throwable)ex);
            DebuggerSession debuggerSession6 = this$0.debugSession.getDebuggerSession();
            LoggingKt.warnUnderDebug((Logger)LOG, (String)("Is paused: " + (debuggerSession6 != null ? debuggerSession6.isPaused() : false)));
        }
        LoggingKt.warnUnderDebug((Logger)LOG, (String)("Is paused: " + (debuggerSession != null ? debuggerSession.isPaused() : false)));
    }

    static {
        Companion $this$notebookLogger$iv = Companion = new Companion(null);
        boolean $i$f$notebookLogger = false;
        LOG = KotlinNotebookLoggerFactory.INSTANCE.getInstance(Reflection.getOrCreateKotlinClass(Companion.class));
        STACK_FRAME_EQUALITY_OBJECT = new Object();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/kotlin/jupyter/debug/frame/KotlinNotebookVariablesFrame$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "STACK_FRAME_EQUALITY_OBJECT", "intellij.kotlin.jupyter.debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

