/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.debug.proxy.handlers;

import com.intellij.kotlin.jupyter.debug.proxy.JdiDescriptorValueOrigin;
import com.intellij.kotlin.jupyter.debug.proxy.JdiFieldAccessPath;
import com.intellij.kotlin.jupyter.debug.proxy.context.DebugValueContext;
import com.intellij.kotlin.jupyter.debug.proxy.conversion.JdiConversionUtilsKt;
import com.intellij.kotlin.jupyter.debug.proxy.handlers.AbstractJdiInvocationHandler;
import com.intellij.kotlin.jupyter.debug.util.JdiUtilsKt;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.lang.reflect.Method;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilderKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J4\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\t\u0018\u00010\u000fH\u0096\u0002\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u000bH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/kotlin/jupyter/debug/proxy/handlers/JdiFieldAccessInvocationHandler;", "Lcom/intellij/kotlin/jupyter/debug/proxy/handlers/AbstractJdiInvocationHandler;", "valueContext", "Lcom/intellij/kotlin/jupyter/debug/proxy/context/DebugValueContext;", "<init>", "(Lcom/intellij/kotlin/jupyter/debug/proxy/context/DebugValueContext;)V", "isApplicable", "", "obj", "", "method", "Ljava/lang/reflect/Method;", "invoke", "proxy", "args", "", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", "getFieldNameViaPathAnnotation", "", "getViaFieldAccessPath", "Lcom/sun/jdi/Value;", "invokeAsFieldAccess", "intellij.kotlin.jupyter.debug"})
public final class JdiFieldAccessInvocationHandler
extends AbstractJdiInvocationHandler {
    public JdiFieldAccessInvocationHandler(@NotNull DebugValueContext valueContext) {
        Intrinsics.checkNotNullParameter((Object)valueContext, (String)"valueContext");
        super(valueContext);
    }

    @Override
    public boolean isApplicable(@NotNull Object obj, @NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        boolean isFromAnnotation = method.isAnnotationPresent(JdiFieldAccessPath.class);
        if (isFromAnnotation) {
            return true;
        }
        String string = JdiConversionUtilsKt.findFieldNameByGetterOrNull(method);
        if (string == null) {
            return false;
        }
        String fieldName = string;
        return JdiUtilsKt.findFieldByName(this.getObjectReference(), fieldName) != null;
    }

    @Override
    @Nullable
    public Object invoke(@NotNull Object proxy, @NotNull Method method, @Nullable Object[] args) {
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Value value = this.invokeAsFieldAccess(method);
        if (value == null) {
            return null;
        }
        Value jdiValue = value;
        String string = this.getFieldNameViaPathAnnotation(method);
        if (string == null) {
            string = JdiConversionUtilsKt.findFieldNameByGetterOrNull(method);
        }
        String fieldName = string;
        return this.convertValueAndBindToDescriptor(jdiValue, method, fieldName, this.getObjectReference(), JdiDescriptorValueOrigin.FieldValue);
    }

    private final String getFieldNameViaPathAnnotation(Method $this$getFieldNameViaPathAnnotation) {
        Object object = $this$getFieldNameViaPathAnnotation.getAnnotation(JdiFieldAccessPath.class);
        if (object == null || (object = object.path()) == null) {
            return null;
        }
        Object pathAnnotation = object;
        String[] stringArray = new String[]{"."};
        List path = StringsKt.split$default((CharSequence)((CharSequence)pathAnnotation), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        return (String)CollectionsKt.last((List)path);
    }

    private final Value getViaFieldAccessPath(Method method) {
        Object object = method.getAnnotation(JdiFieldAccessPath.class);
        if (object == null || (object = object.path()) == null) {
            return null;
        }
        Object pathAnnotation = object;
        String[] stringArray = new String[]{"."};
        List path = StringsKt.split$default((CharSequence)((CharSequence)pathAnnotation), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (path.isEmpty()) {
            return null;
        }
        Value current = this.getObjectReference();
        for (String fieldName : path) {
            if (!(current instanceof ObjectReference)) {
                return null;
            }
            current = JdiUtilsKt.getFieldValueByName((ObjectReference)current, fieldName);
        }
        return current;
    }

    private final Value invokeAsFieldAccess(Method method) {
        Value byFieldAccessPath = this.getViaFieldAccessPath(method);
        if (byFieldAccessPath != null) {
            return byFieldAccessPath;
        }
        String fieldName = JdiConversionUtilsKt.findFieldNameByGetterOrNull(method);
        if (fieldName == null) {
            KotlinEvaluatorBuilderKt.evaluationException((String)("Cannot find a field with name corresponding to the getter " + method.getName()));
            throw new KotlinNothingValueException();
        }
        return JdiUtilsKt.getFieldValueByName(this.getObjectReference(), fieldName);
    }
}

