/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.debug.util;

import com.intellij.kotlin.jupyter.debug.proxy.context.ReturnTypeInfo;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0004H\u0000\u001a\u001a\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0002*\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0000\u001a\u000e\u0010\b\u001a\u0004\u0018\u00010\u0004*\u00020\u0006H\u0000\u001a\u0012\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002*\u00020\u0004H\u0002\u001a\u000e\u0010\n\u001a\u0004\u0018\u00010\u0004*\u00020\u0004H\u0002\u001a\u0016\u0010\u000b\u001a\u00020\f*\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0000\u00a8\u0006\r"}, d2={"isTopType", "", "Ljava/lang/Class;", "isEffectivelyTopType", "Ljava/lang/reflect/Type;", "getSpecificReturnTypeIfPossible", "Ljava/lang/reflect/Method;", "contextGenericType", "extractFirstGenericTypeArgument", "toRawClassOrNull", "preferableBound", "resolveReturnType", "Lcom/intellij/kotlin/jupyter/debug/proxy/context/ReturnTypeInfo;", "intellij.kotlin.jupyter.debug"})
@SourceDebugExtension(value={"SMAP\nTypeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeUtils.kt\ncom/intellij/kotlin/jupyter/debug/util/TypeUtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n13022#2,2:119\n13022#2,2:121\n1#3:123\n*S KotlinDebug\n*F\n+ 1 TypeUtils.kt\ncom/intellij/kotlin/jupyter/debug/util/TypeUtilsKt\n*L\n27#1:119,2\n31#1:121,2\n*E\n"})
public final class TypeUtilsKt {
    public static final boolean isTopType(@NotNull Class<?> $this$isTopType) {
        Intrinsics.checkNotNullParameter($this$isTopType, (String)"<this>");
        return Intrinsics.areEqual($this$isTopType, Object.class) || Intrinsics.areEqual($this$isTopType, Object.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEffectivelyTopType(@NotNull Type $this$isEffectivelyTopType) {
        Intrinsics.checkNotNullParameter((Object)$this$isEffectivelyTopType, (String)"<this>");
        Type type = $this$isEffectivelyTopType;
        if (!(type instanceof Class)) {
            if (type instanceof WildcardType) {
                Type[] typeArray = ((WildcardType)$this$isEffectivelyTopType).getLowerBounds();
                Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"getLowerBounds(...)");
                boolean hasLower = !(((Object[])typeArray).length == 0);
                Type[] uppers = ((WildcardType)$this$isEffectivelyTopType).getUpperBounds();
                if (hasLower) return false;
                Intrinsics.checkNotNull((Object)uppers);
                if (uppers.length == 0) {
                    return true;
                }
                boolean bl = false;
                if (bl) return true;
                Type[] $this$all$iv = uppers;
                boolean $i$f$all = false;
                int n = 0;
                int n2 = $this$all$iv.length;
                while (n < n2) {
                    Type element$iv;
                    Type it = element$iv = $this$all$iv[n];
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!TypeUtilsKt.isEffectivelyTopType(it)) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
            if (type instanceof TypeVariable) {
                Type[] b = ((TypeVariable)$this$isEffectivelyTopType).getBounds();
                Intrinsics.checkNotNull((Object)b);
                if (b.length == 0) {
                    return true;
                }
                boolean bl = false;
                if (bl) return true;
                Type[] $this$all$iv = b;
                boolean $i$f$all = false;
                int n = 0;
                int n3 = $this$all$iv.length;
                while (n < n3) {
                    Type element$iv;
                    Type it = element$iv = $this$all$iv[n];
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!TypeUtilsKt.isEffectivelyTopType(it)) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
            if (type instanceof GenericArrayType) {
                return false;
            }
            if (!(type instanceof ParameterizedType)) return false;
            return false;
        }
        boolean bl = TypeUtilsKt.isTopType((Class)$this$isEffectivelyTopType);
        return bl;
    }

    @NotNull
    public static final Class<?> getSpecificReturnTypeIfPossible(@NotNull Method $this$getSpecificReturnTypeIfPossible, @Nullable Type contextGenericType) {
        Class<?> clazz;
        Intrinsics.checkNotNullParameter((Object)$this$getSpecificReturnTypeIfPossible, (String)"<this>");
        Class<?> declaredType = $this$getSpecificReturnTypeIfPossible.getReturnType();
        if (contextGenericType == null || TypeUtilsKt.isEffectivelyTopType(contextGenericType)) {
            Intrinsics.checkNotNull(declaredType);
            return declaredType;
        }
        Intrinsics.checkNotNull(declaredType);
        if (TypeUtilsKt.isTopType(declaredType)) {
            clazz = TypeUtilsKt.toRawClassOrNull(contextGenericType);
            if (clazz == null) {
                clazz = declaredType;
            }
        } else {
            clazz = declaredType;
        }
        return clazz;
    }

    @Nullable
    public static final Type extractFirstGenericTypeArgument(@NotNull Method $this$extractFirstGenericTypeArgument) {
        Intrinsics.checkNotNullParameter((Object)$this$extractFirstGenericTypeArgument, (String)"<this>");
        Type genericReturnType = $this$extractFirstGenericTypeArgument.getGenericReturnType();
        if (!(genericReturnType instanceof ParameterizedType)) {
            return null;
        }
        Type[] typeArguments = ((ParameterizedType)genericReturnType).getActualTypeArguments();
        Intrinsics.checkNotNull((Object)typeArguments);
        if (typeArguments.length == 0) {
            return null;
        }
        Type firstTypeArgument = typeArguments[0];
        Intrinsics.checkNotNull((Object)firstTypeArgument);
        return TypeUtilsKt.preferableBound(firstTypeArgument);
    }

    private static final Class<?> toRawClassOrNull(Type $this$toRawClassOrNull) {
        Class<Object> clazz;
        Type type = $this$toRawClassOrNull;
        if (type instanceof Class) {
            clazz = (Class<?>)$this$toRawClassOrNull;
        } else if (type instanceof ParameterizedType) {
            Type type2 = ((ParameterizedType)$this$toRawClassOrNull).getRawType();
            clazz = type2 instanceof Class ? (Class)type2 : null;
        } else if (type instanceof WildcardType) {
            Type wildCardBound;
            Type[] typeArray = ((WildcardType)$this$toRawClassOrNull).getLowerBounds();
            Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"getLowerBounds(...)");
            Type type3 = (Type)ArraysKt.firstOrNull((Object[])typeArray);
            if (type3 == null) {
                Type[] typeArray2 = ((WildcardType)$this$toRawClassOrNull).getUpperBounds();
                Intrinsics.checkNotNullExpressionValue((Object)typeArray2, (String)"getUpperBounds(...)");
                type3 = (Type)ArraysKt.firstOrNull((Object[])typeArray2);
            }
            Type type4 = wildCardBound = type3;
            clazz = type4 != null ? TypeUtilsKt.toRawClassOrNull(type4) : null;
        } else if (type instanceof TypeVariable) {
            Type[] typeArray = ((TypeVariable)$this$toRawClassOrNull).getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"getBounds(...)");
            Type type5 = (Type)ArraysKt.firstOrNull((Object[])typeArray);
            clazz = type5 != null ? TypeUtilsKt.toRawClassOrNull(type5) : null;
        } else {
            clazz = null;
        }
        return clazz;
    }

    private static final Type preferableBound(Type $this$preferableBound) {
        Type type;
        Type type2 = $this$preferableBound;
        if (type2 instanceof WildcardType) {
            Type[] typeArray = ((WildcardType)$this$preferableBound).getLowerBounds();
            Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"getLowerBounds(...)");
            type = (Type)ArraysKt.firstOrNull((Object[])typeArray);
            if (type == null) {
                Type[] typeArray2 = ((WildcardType)$this$preferableBound).getUpperBounds();
                Intrinsics.checkNotNullExpressionValue((Object)typeArray2, (String)"getUpperBounds(...)");
                type = (Type)ArraysKt.firstOrNull((Object[])typeArray2);
            }
        } else if (type2 instanceof TypeVariable) {
            Type[] typeArray = ((TypeVariable)$this$preferableBound).getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"getBounds(...)");
            type = (Type)ArraysKt.firstOrNull((Object[])typeArray);
        } else {
            type = $this$preferableBound;
        }
        return type;
    }

    @NotNull
    public static final ReturnTypeInfo resolveReturnType(@NotNull Method $this$resolveReturnType, @Nullable Type contextGenericType) {
        Type type;
        Type rawElementType;
        Intrinsics.checkNotNullParameter((Object)$this$resolveReturnType, (String)"<this>");
        Class<?> declared = $this$resolveReturnType.getReturnType();
        Type type2 = TypeUtilsKt.extractFirstGenericTypeArgument($this$resolveReturnType);
        if (type2 == null) {
            type2 = contextGenericType;
        }
        Type type3 = rawElementType = type2;
        if (type3 != null) {
            Type type4;
            Type it = type4 = type3;
            boolean bl = false;
            type = !TypeUtilsKt.isEffectivelyTopType(it) ? type4 : null;
        } else {
            type = null;
        }
        Type genericType = type;
        Class<?> runtimeType = TypeUtilsKt.getSpecificReturnTypeIfPossible($this$resolveReturnType, genericType);
        Intrinsics.checkNotNull(declared);
        return new ReturnTypeInfo(declared, runtimeType, genericType);
    }
}

