/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.react;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXResolveUtil;
import com.intellij.lang.javascript.frameworks.react.ReactUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNotARecordType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSDestructuringContext;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.react.ReactFilterProvider;
import com.intellij.react.free.ReactPropTypesUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactFrameworkIndexingHandler
extends FrameworkIndexingHandler {
    public static final String REACT_COMPOSITE_COMPONENT = "ReactCompositeComponent";
    public static final String REACT_COMPONENT = "ReactComponent";
    private static final String[] PROP_TYPES_SHAPE = new String[]{"PropTypes", "shape"};

    public void processCallExpression(@NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        if (callExpression == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(0);
        }
        if (outData == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(1);
        }
        if (callExpression.getContext() instanceof JSExportAssignment) {
            this.processExportAssignmentCall(callExpression, outData);
        }
        if (!ReactUtil.isReactComponentCall((JSExpression)callExpression)) {
            return;
        }
        ReactFrameworkIndexingHandler.addClassFromVariable(callExpression, outData);
    }

    private void processExportAssignmentCall(@NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        JSExpression[] arguments;
        if (callExpression == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(2);
        }
        if (outData == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(3);
        }
        for (JSExpression argument : arguments = callExpression.getArguments()) {
            String name;
            JSReferenceExpression ref;
            JSExpression qualifier;
            JSCallExpression call;
            JSExpression[] subArguments;
            if (argument instanceof JSCallExpression && (subArguments = (call = (JSCallExpression)argument).getArguments()).length > 0) {
                argument = subArguments[0];
            }
            if (!(argument instanceof JSReferenceExpression) || (qualifier = (ref = (JSReferenceExpression)argument).getQualifier()) != null || !JSXResolveUtil.isComponentName((String)(name = ref.getReferenceName()))) continue;
            this.putUserString(outData, name);
        }
    }

    @Nullable
    public JSElementIndexingData processClass(@NotNull JSClass jsClass, @Nullable JSElementIndexingData data) {
        JSReferenceList list;
        String name;
        if (jsClass == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(4);
        }
        if (jsClass instanceof ES6Class && (name = jsClass.getQualifiedName()) != null && (list = jsClass.getExtendsList()) != null) {
            for (JSReferenceListMember member : list.getMembers()) {
                String text = member.getReferenceText();
                JSTypeDeclaration[] arguments = member.getTypeArguments();
                if (text == null || !ReactPropTypesUtil.isPossibleReactClassName((String)text) || arguments.length <= 0) continue;
                JSImplicitElementImpl.Builder clazz = ReactFrameworkIndexingHandler.buildClassProperty(jsClass, name, "props");
                if (data == null) {
                    data = new JSElementIndexingDataImpl();
                }
                data.addImplicitElement((JSImplicitElement)clazz.toImplicitElement());
                if (arguments.length > 1) {
                    data.addImplicitElement((JSImplicitElement)ReactFrameworkIndexingHandler.buildClassProperty(jsClass, name, "state").toImplicitElement());
                }
                return data;
            }
        }
        return super.processClass(jsClass, data);
    }

    @NotNull
    private static JSImplicitElementImpl.Builder buildClassProperty(@NotNull JSClass jsClass, @NotNull String parentQualifier, @NotNull String name) {
        if (jsClass == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(5);
        }
        if (parentQualifier == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(6);
        }
        if (name == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(7);
        }
        JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(name, (PsiElement)jsClass).setNamespace((JSQualifiedName)JSQualifiedNameImpl.fromQualifiedName((String)parentQualifier)).setAccessType(JSAttributeList.AccessType.PUBLIC).setType(JSImplicitElement.Type.Property);
        if (builder == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(8);
        }
        return builder;
    }

    private static void addClassFromVariable(JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        JSQualifiedNamedElement variable;
        if (outData == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(9);
        }
        if ((variable = (JSQualifiedNamedElement)PsiTreeUtil.getParentOfType((PsiElement)callExpression, JSVariable.class)) == null) {
            JSAssignmentExpression assignment = (JSAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)callExpression, JSAssignmentExpression.class);
            JSDefinitionExpression jSDefinitionExpression = variable = assignment != null ? assignment.getDefinitionExpression() : null;
        }
        if (variable != null) {
            String name = variable.getName();
            if (name == null) {
                return;
            }
            if (JSDocumentationUtils.isClassOrInterface((JSQualifiedNamedElement)variable) == JSElementBase.ClassOrInterface.NONE) {
                JSImplicitElementImpl.Builder clazz = new JSImplicitElementImpl.Builder(name, (PsiElement)callExpression).setNamespace(variable.getNamespace()).setType(JSImplicitElement.Type.Class).setJSType(JSNamedTypeFactory.createType((String)REACT_COMPOSITE_COMPONENT, (JSTypeSource)JSTypeSource.EMPTY, (JSContext)JSContext.INSTANCE));
                outData.addImplicitElement((JSImplicitElement)clazz.toImplicitElement());
            }
        }
    }

    public void addContextNames(PsiElement context, List<String> names) {
        if (context == null) {
            return;
        }
        JSCallExpression call = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)context, JSCallExpression.class);
        if (call != null && ReactUtil.isReactComponentCall((JSExpression)call)) {
            names.add(REACT_COMPONENT);
        }
        if (this.hasPropTypes(context)) {
            names.add(REACT_COMPONENT);
        }
    }

    @Nullable
    public JSElementIndexingData processAnyProperty(@NotNull JSProperty property, @Nullable JSElementIndexingData outData) {
        boolean isPropTypesNamespace;
        JSQualifiedName namespace;
        String name;
        if (property == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(10);
        }
        if ((name = property.getName()) == null) {
            return outData;
        }
        JSQualifiedName propsPrefix = namespace = property.getJSNamespace().getQualifiedName();
        JSQualifiedNameImpl propsSuffix = null;
        int suffixLength = 0;
        while (propsPrefix != null && !"propTypes".equals(propsPrefix.getName())) {
            propsPrefix = propsPrefix.getParent();
            ++suffixLength;
        }
        if (propsPrefix != null && suffixLength > 0) {
            List components = namespace.toComponents();
            propsSuffix = JSQualifiedNameImpl.fromComponents(components.subList(components.size() - suffixLength, components.size()));
        }
        boolean bl = isPropTypesNamespace = propsPrefix != null;
        if (isPropTypesNamespace || ReactFrameworkIndexingHandler.shouldCreateImplicitElement(property)) {
            JSQualifiedName parent;
            JSQualifiedName jSQualifiedName = parent = isPropTypesNamespace ? propsPrefix.getParent() : null;
            if (outData == null) {
                outData = new JSElementIndexingDataImpl();
            }
            JSQualifiedNameImpl props = JSQualifiedNameImpl.create((String)"props", (JSQualifiedName)parent);
            JSQualifiedNameImpl prop = JSQualifiedNameImpl.create((String)name, (JSQualifiedName)JSQualifiedNameImpl.concat((JSQualifiedName)props, (JSQualifiedName)propsSuffix));
            JSImplicitElementImpl element = ReactPropTypesUtil.createImplicitReactPropsElement((JSProperty)property, (JSQualifiedName)prop);
            outData.addImplicitElement((JSImplicitElement)element);
            PsiElement object = property.getParent();
            if (isPropTypesNamespace && object instanceof JSObjectLiteralExpression && ((JSObjectLiteralExpression)object).getFirstProperty() == property) {
                JSImplicitElementImpl.Builder propsBuilder = new JSImplicitElementImpl.Builder((JSQualifiedName)props, (PsiElement)property).setJSType(JSNamedTypeFactory.createType((String)props.getQualifiedName(), (JSTypeSource)JSTypeSource.EMPTY, (JSContext)JSContext.INSTANCE)).setType(JSImplicitElement.Type.Property);
                outData.addImplicitElement((JSImplicitElement)propsBuilder.toImplicitElement());
            }
            outData.setAddUnderlyingElementToSymbolIndex(true);
        }
        return outData;
    }

    private static boolean shouldCreateImplicitElement(@NotNull JSProperty property) {
        JSExpression value;
        if (property == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(11);
        }
        if ((value = property.getValue()) instanceof JSReferenceExpression) {
            JSExpression qualifier = ((JSReferenceExpression)value).getQualifier();
            while (qualifier instanceof JSReferenceExpression) {
                if ("PropTypes".equals(((JSReferenceExpression)qualifier).getReferenceName())) {
                    return true;
                }
                qualifier = ((JSReferenceExpression)qualifier).getQualifier();
            }
        }
        return false;
    }

    public boolean addTypeFromResolveResult(@NotNull JSTypeEvaluator evaluator, @NotNull JSEvaluateContext context, @NotNull PsiElement result) {
        if (evaluator == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(12);
        }
        if (context == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(13);
        }
        if (result == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(14);
        }
        if (!(result instanceof JSElement) || !ReactFrameworkIndexingHandler.jsJSXWithoutTypeScript(context, result)) {
            return false;
        }
        if (result instanceof JSParameterListElement) {
            ReactFrameworkIndexingHandler.addParameterTypeFromResolveResult(evaluator, (JSParameterListElement)result);
            return false;
        }
        if (result instanceof JSField && "props".equals(((JSField)result).getName())) {
            JSClass jsClass = JSResolveUtil.getClassOfContext((PsiElement)context.getProcessedExpression());
            if (jsClass != null && ReactFilterProvider.isAcceptableClassComponent(jsClass) == ThreeState.YES) {
                JSNamespace propsType = ReactFrameworkIndexingHandler.getPropsTypeFromQualifiedName(result, (JSQualifiedNamedElement)jsClass);
                if (propsType != null) {
                    evaluator.addAdditionalType((JSType)propsType);
                }
                return false;
            }
        } else if (result instanceof JSImplicitElement) {
            JSType resultType;
            String name = ((JSImplicitElement)result).getName();
            PsiElement parent = result.getParent();
            boolean isState = "state".equals(name);
            if (parent instanceof JSClass && (isState || "props".equals(name)) && (resultType = ReactPropTypesUtil.getClassComponentGenericType((JSClass)((JSClass)parent), (boolean)isState)) != null) {
                JSRecordType recordType = resultType.asRecordType();
                evaluator.addType((JSType)(recordType instanceof JSNotARecordType ? resultType : recordType));
                return true;
            }
        }
        return false;
    }

    private static void addParameterTypeFromResolveResult(@NotNull JSTypeEvaluator evaluator, @NotNull JSParameterListElement result) {
        JSNamespace propsType;
        JSFunction function;
        if (evaluator == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(15);
        }
        if (result == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(16);
        }
        if ((function = result.getDeclaringFunction()) == null || !JSXResolveUtil.isComponentName((String)function.getName())) {
            return;
        }
        JSParameterListElement first = (JSParameterListElement)ArrayUtil.getFirstElement((Object[])function.getParameters());
        if (result == first) {
            JSNamespace propsType2 = ReactFrameworkIndexingHandler.getPropsTypeFromQualifiedName((PsiElement)result, (JSQualifiedNamedElement)function);
            if (propsType2 != null) {
                evaluator.addAdditionalType((JSType)propsType2);
            }
            return;
        }
        PsiElement resultParent = result.getContext();
        if (!JSDestructuringUtil.isDestructuring((PsiElement)resultParent)) {
            return;
        }
        JSDestructuringContext destructuringContext = JSDestructuringContext.findDestructuringParents((PsiElement)result, JSDestructuringParameter.class::isInstance);
        if (destructuringContext.getOuterElement() == first && (propsType = ReactFrameworkIndexingHandler.getPropsTypeFromQualifiedName((PsiElement)result, (JSQualifiedNamedElement)function)) != null) {
            propsType = destructuringContext.applyToOuterType((JSType)propsType);
            evaluator.addAdditionalType((JSType)propsType);
        }
    }

    private static boolean jsJSXWithoutTypeScript(@NotNull JSEvaluateContext context, @NotNull PsiElement result) {
        PsiElement element;
        if (context == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(17);
        }
        if (result == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(18);
        }
        return DialectDetector.isJSX((PsiElement)(element = (PsiElement)ObjectUtils.coalesce((Object)context.targetFile, (Object)result))) && !DialectDetector.isTypeScript((PsiElement)element);
    }

    @Nullable
    private static JSNamespace getPropsTypeFromQualifiedName(@NotNull PsiElement result, @NotNull JSQualifiedNamedElement element) {
        JSQualifiedNameImpl qName;
        if (result == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(19);
        }
        if (element == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(20);
        }
        if ((qName = JSQualifiedNameImpl.fromQualifiedNamedElement((JSElementBase)element)) != null) {
            JSQualifiedNameImpl props = JSQualifiedNameImpl.create((String)"props", (JSQualifiedName)qName);
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)result, (boolean)true);
            return JSNamedTypeFactory.createNamespace((JSQualifiedName)props, (JSTypeSource)source, (JSTypeContext)JSTypeContext.STATIC, (boolean)false);
        }
        return null;
    }

    public boolean shouldCreateStubForCallExpression(@NotNull ASTNode node) {
        ASTNode parent;
        if (node == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(21);
        }
        if ((parent = node.getTreeParent()).getElementType() == JSElementTypes.EXPORT_DEFAULT_ASSIGNMENT) {
            return true;
        }
        ASTNode methodExpression = node.getFirstChildNode();
        if (methodExpression.getElementType() != JSElementTypes.REFERENCE_EXPRESSION) {
            return false;
        }
        ASTNode referencedNameElement = methodExpression.getLastChildNode();
        return referencedNameElement != null && StringUtil.equals((CharSequence)referencedNameElement.getChars(), (CharSequence)"forwardRef");
    }

    protected boolean hasPropTypes(PsiElement context) {
        JSClass clazz = DialectDetector.isES6((PsiElement)context) ? (JSClass)PsiTreeUtil.getParentOfType((PsiElement)context, JSClass.class) : null;
        GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)context);
        String name = clazz != null ? clazz.getQualifiedName() + ".propTypes" : null;
        List propTypes = name != null ? JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(name, scope) : Collections.emptyList();
        return !propTypes.isEmpty();
    }

    @Nullable
    public JSType getExportsInnerAliasType(@NotNull JSQualifiedName referenceName, @NotNull JSTypeSource typeSource) {
        if (referenceName == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(22);
        }
        if (typeSource == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(23);
        }
        if (((JSQualifiedNameImpl)referenceName).matches(new String[]{"react"})) {
            return JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.create((String)"React", null), (JSTypeSource)typeSource, (JSTypeContext)JSTypeContext.STATIC, (boolean)true);
        }
        if (((JSQualifiedNameImpl)referenceName).matches(new String[]{"reactDom"})) {
            return JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.create((String)"ReactDOM", null), (JSTypeSource)typeSource, (JSTypeContext)JSTypeContext.STATIC, (boolean)true);
        }
        return null;
    }

    @Nullable
    public JSNamespace findNamespace(@NotNull JSExpression expression, @Nullable Set<PsiElement> visited) {
        PsiElement argumentList;
        if (expression == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(24);
        }
        if (!((argumentList = expression.getParent()) instanceof JSArgumentList)) {
            return null;
        }
        PsiElement callExpression = argumentList.getParent();
        if (!(callExpression instanceof JSCallExpression)) {
            return null;
        }
        JSExpression methodExpression = ((JSCallExpression)callExpression).getMethodExpression();
        if (!JSSymbolUtil.isAccurateReferenceExpressionName((JSExpression)methodExpression, (String[])PROP_TYPES_SHAPE)) {
            return null;
        }
        return JSSymbolUtil.findNamespace((JSExpression)((JSCallExpression)callExpression), visited);
    }

    @Nullable
    protected String getJSElementIndexingDataUserStringKey() {
        return "alt.default.name";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outData";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentQualifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/react/ReactFrameworkIndexingHandler";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/react/ReactFrameworkIndexingHandler";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildClassProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processCallExpression";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processExportAssignmentCall";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processClass";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildClassProperty";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addClassFromVariable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processAnyProperty";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shouldCreateImplicitElement";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromResolveResult";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addParameterTypeFromResolveResult";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "jsJSXWithoutTypeScript";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPropsTypeFromQualifiedName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "shouldCreateStubForCallExpression";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getExportsInnerAliasType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findNamespace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

