/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.jpa.linemarker;

import com.intellij.database.intentions.RunQueryInConsoleIntentionAction;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.repository.ExtractJpqlQueryException;
import com.intellij.jpa.jpb.model.repository.PropertyReferenceException;
import com.intellij.jpa.jpb.model.repository.RepositoryMethod;
import com.intellij.jpa.jpb.model.repository.RepositoryMethodConverter;
import com.intellij.jpa.jpb.model.repository.RepositoryMethodPsi;
import com.intellij.jpa.jpb.model.repository.RepositoryMethodQueryProvider;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.data.utils.SpringDataBundle;
import com.intellij.util.ui.EDT;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\"\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\nJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/spring/data/jpa/linemarker/SpringDataRunJpqlUtils;", "", "<init>", "()V", "QUERY_ANNOTATIONS", "", "", "getQUERY_ANNOTATIONS", "()Ljava/util/List;", "getQlStatementFromMethod", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "uMethod", "Lorg/jetbrains/uast/UMethod;", "getOrCreateQLStatement", "entityClass", "Lcom/intellij/psi/PsiClass;", "createQueryFromMethod", "openDBConsole", "", "qlStatement", "isQlMethodRunnable", "", "showKnownErrorNotification", "intellij.spring.data.jpa"})
@SourceDebugExtension(value={"SMAP\nSpringDataRunJpqlUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringDataRunJpqlUtils.kt\ncom/intellij/spring/data/jpa/linemarker/SpringDataRunJpqlUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1807#2,3:101\n*S KotlinDebug\n*F\n+ 1 SpringDataRunJpqlUtils.kt\ncom/intellij/spring/data/jpa/linemarker/SpringDataRunJpqlUtils\n*L\n77#1:101,3\n*E\n"})
public final class SpringDataRunJpqlUtils {
    @NotNull
    public static final SpringDataRunJpqlUtils INSTANCE = new SpringDataRunJpqlUtils();
    @NotNull
    private static final List<String> QUERY_ANNOTATIONS;

    private SpringDataRunJpqlUtils() {
    }

    @NotNull
    public final List<String> getQUERY_ANNOTATIONS() {
        return QUERY_ANNOTATIONS;
    }

    @Nullable
    public final PsiElement getQlStatementFromMethod(@NotNull Project project, @NotNull UMethod uMethod) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        try {
            return SpringDataRunJpqlUtils.getOrCreateQLStatement$default(this, uMethod, null, 2, null);
        }
        catch (ExtractJpqlQueryException e) {
            Object[] objectArray = new Object[]{SpringDataBundle.message((String)"run.jpql.query", (Object[])new Object[0])};
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)SpringDataBundle.message((String)"ExtractJpqlQueryIntention.error", (Object[])objectArray));
        }
        catch (PropertyReferenceException propertyReferenceException) {
            this.showKnownErrorNotification(uMethod, project);
        }
        catch (IllegalStateException illegalStateException) {
            this.showKnownErrorNotification(uMethod, project);
        }
        return null;
    }

    @Nullable
    public final PsiElement getOrCreateQLStatement(@NotNull UMethod uMethod, @Nullable PsiClass entityClass) {
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        return RepositoryMethodQueryProvider.Companion.getOrCreateQLStatement(uMethod, entityClass);
    }

    public static /* synthetic */ PsiElement getOrCreateQLStatement$default(SpringDataRunJpqlUtils springDataRunJpqlUtils, UMethod uMethod, PsiClass psiClass, int n, Object object) {
        if ((n & 2) != 0) {
            psiClass = null;
        }
        return springDataRunJpqlUtils.getOrCreateQLStatement(uMethod, psiClass);
    }

    @NotNull
    public final String createQueryFromMethod(@NotNull Project project, @NotNull UMethod uMethod, @Nullable PsiClass entityClass) throws ExtractJpqlQueryException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        RepositoryMethodConverter methodConverter = RepositoryMethodConverter.Companion.getInstance(project);
        RepositoryMethodPsi repoMethod = RepositoryMethodPsi.Companion.getInstance(uMethod.getJavaPsi());
        return entityClass != null ? methodConverter.extractJPQL((RepositoryMethod)repoMethod, entityClass, true) : methodConverter.extractJPQL(repoMethod, true);
    }

    public static /* synthetic */ String createQueryFromMethod$default(SpringDataRunJpqlUtils springDataRunJpqlUtils, Project project, UMethod uMethod, PsiClass psiClass, int n, Object object) throws ExtractJpqlQueryException {
        if ((n & 4) != 0) {
            psiClass = null;
        }
        return springDataRunJpqlUtils.createQueryFromMethod(project, uMethod, psiClass);
    }

    public final void openDBConsole(@NotNull Project project, @NotNull PsiElement qlStatement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)qlStatement, (String)"qlStatement");
        EDT.assertIsEdt();
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        new RunQueryInConsoleIntentionAction().invoke(project, editor2, qlStatement);
    }

    public final boolean isQlMethodRunnable(@NotNull UMethod uMethod) {
        boolean bl;
        block10: {
            Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
            UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)uMethod));
            if (uClass == null || (uClass = uClass.getJavaPsi()) == null) {
                return false;
            }
            UClass psiClass = uClass;
            if (!SpringDataUtil.isRepository((PsiClass)psiClass)) {
                return false;
            }
            if (InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.data.mongodb.repository.MongoRepository")) {
                return false;
            }
            Iterable $this$any$iv = uMethod.getUAnnotations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    UAnnotation it = (UAnnotation)element$iv;
                    boolean bl2 = false;
                    if (!CollectionsKt.contains((Iterable)QUERY_ANNOTATIONS, (Object)it.getQualifiedName())) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        try {
            return RepositoryMethodPsi.Companion.getInstance(uMethod.getJavaPsi()).getPartTree().getMethodPrefix() != null;
        }
        catch (PropertyReferenceException propertyReferenceException) {
            return false;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    private final void showKnownErrorNotification(UMethod uMethod, Project project) {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Spring Data JPA");
        Object[] objectArray = new Object[]{uMethod.getName()};
        String string = JpaModelBundle.message((String)"could.not.parse.repository.method.name", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        notificationGroup.createNotification(string, NotificationType.WARNING).setIcon(SpringApiIcons.SpringData).notify(project);
    }

    static {
        Object[] objectArray = new String[]{"org.springframework.data.jpa.repository.Query", "org.springframework.data.jpa.repository.query.Procedure", "org.springframework.data.repository.RepositoryDefinition", "org.springframework.data.jdbc.repository.query.Query", "org.springframework.data.jpa.repository.NativeQuery"};
        QUERY_ANNOTATIONS = CollectionsKt.listOf((Object[])objectArray);
    }
}

