/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.inspections.quickfixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.VueBundle;
import org.jetbrains.vuejs.editor.VueComponentSourceEdit;
import org.jetbrains.vuejs.model.VueModelManager;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\u0005H\u0017J\b\u0010\f\u001a\u00020\u0005H\u0017J)\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0096\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/vuejs/inspections/quickfixes/VueImportComponentQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "element", "Lcom/intellij/psi/PsiElement;", "importName", "", "elementToImport", "<init>", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "elementToImportPtr", "Lcom/intellij/psi/SmartPsiElementPointer;", "getText", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "startElement", "endElement", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.vuejs.backend"})
@SourceDebugExtension(value={"SMAP\nVueImportComponentQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueImportComponentQuickFix.kt\norg/jetbrains/vuejs/inspections/quickfixes/VueImportComponentQuickFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n1807#2,3:56\n*S KotlinDebug\n*F\n+ 1 VueImportComponentQuickFix.kt\norg/jetbrains/vuejs/inspections/quickfixes/VueImportComponentQuickFix\n*L\n45#1:56,3\n*E\n"})
public final class VueImportComponentQuickFix
extends LocalQuickFixOnPsiElement {
    @NotNull
    private final String importName;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final SmartPsiElementPointer<PsiElement> elementToImportPtr;

    public VueImportComponentQuickFix(@NotNull PsiElement element, @NotNull String importName, @NotNull PsiElement elementToImport) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)importName, (String)"importName");
        Intrinsics.checkNotNullParameter((Object)elementToImport, (String)"elementToImport");
        super(element);
        this.importName = importName;
        this.elementToImportPtr = SmartPointersKt.createSmartPointer((PsiElement)elementToImport);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.importName};
        return VueBundle.message((String)"vue.quickfix.import.component.name", (Object[])objectArray);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return VueBundle.message((String)"vue.quickfix.import.component.family", (Object[])new Object[0]);
    }

    /*
     * Unable to fully structure code
     */
    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        block8: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            v0 = VueComponentSourceEdit.Companion.create(VueModelManager.Companion.findEnclosingContainer(startElement));
            if (v0 == null) {
                return;
            }
            componentSourceEdit = v0;
            v1 = this.elementToImportPtr.dereference();
            if (v1 == null) {
                return;
            }
            elementToImport = v1;
            v2 = this.elementToImportPtr.getContainingFile();
            if (v2 == null) {
                return;
            }
            importFile = v2;
            if (importFile instanceof XmlFile) ** GOTO lbl-1000
            v3 = ES6PsiUtil.findDefaultExports((PsiElement)((PsiElement)importFile));
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"findDefaultExports(...)");
            var9_8 = v3;
            $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                v4 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it = (JSElement)element$iv;
                    $i$a$-any-VueImportComponentQuickFix$invoke$adjustedElementToImport$1 = false;
                    if (!PsiTreeUtil.isContextAncestor((PsiElement)((PsiElement)it), (PsiElement)elementToImport, (boolean)false)) continue;
                    v4 = true;
                    break block8;
                }
                v4 = false;
            }
        }
        if (v4) lbl-1000:
        // 2 sources

        {
            v5 = (PsiElement)importFile;
        } else {
            v5 = elementToImport;
        }
        adjustedElementToImport = v5;
        componentSourceEdit.insertComponentImport(this.importName, adjustedElementToImport);
        componentSourceEdit.reformatChanges();
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }
}

