/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.ds;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.jpa.jpb.model.backend.ds.DbDriversManagerExtension;
import com.intellij.jpa.jpb.model.backend.props.SpringPropertiesConfiguration;
import com.intellij.jpa.jpb.model.config.DataSourceInfo;
import com.intellij.jpa.jpb.model.core.model.AbstractRdbmsStore;
import com.intellij.jpa.jpb.model.core.model.DataStore;
import com.intellij.jpa.jpb.model.core.model.dbprop.DbProperties;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.model.CustomDataStore;
import com.intellij.jpa.jpb.model.orm.jpa.JpaOrmFramework;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.jpa.jpb.model.properties.PropertySource;
import com.intellij.jpa.jpb.model.properties.SpringProperty;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 12\u00020\u0001:\u000212B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bJ\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bH\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J$\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00150\u000b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u000b2\u0006\u0010 \u001a\u00020\u001fH\u0002J9\u0010!\u001a\u0004\u0018\u00010\u00132\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u000b2\u0006\u0010\"\u001a\u00020\u00132\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130$\"\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010%J\u0015\u0010&\u001a\t\u0018\u00010'\u00a2\u0006\u0002\b(2\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\fJ\u000e\u0010-\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\fJ\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/jpa/jpb/model/backend/ds/DataSourceLoader;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "propertiesConfiguration", "Lcom/intellij/jpa/jpb/model/backend/props/SpringPropertiesConfiguration;", "getReverseEngineeringDataStores", "", "Lcom/intellij/jpa/jpb/model/core/model/DataStore;", "ormFramework", "Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;", "getCustomDataStores", "findDataStoreById", "Lcom/intellij/jpa/jpb/model/core/model/AbstractRdbmsStore;", "dataStoreId", "", "getDetectedDataStores", "Lcom/intellij/jpa/jpb/model/model/CustomDataStore;", "initUniqueDataStoreName", "", "dataStores", "findDataStores", "", "propertySource", "Lcom/intellij/jpa/jpb/model/properties/PropertySource;", "createDataStores", "allProperties", "Lcom/intellij/jpa/jpb/model/properties/SpringProperty;", "urlProperty", "findPropertyValue", "dataSourceKeyPrefix", "keyPostfixes", "", "(Ljava/util/List;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getCredentials", "Lcom/intellij/credentialStore/Credentials;", "Lorg/jetbrains/annotations/Nullable;", "info", "Lcom/intellij/jpa/jpb/model/config/DataSourceInfo;", "saveCredentials", "dataStore", "removeCredentials", "createCredentialAttributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "key", "Companion", "SpringDataSourceInfo", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nDataSourceLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceLoader.kt\ncom/intellij/jpa/jpb/model/backend/ds/DataSourceLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n812#2,12:196\n1391#2:209\n1480#2,5:210\n1696#2,8:215\n777#2:223\n873#2,2:224\n1642#2,10:226\n1915#2:236\n1916#2:238\n1652#2:239\n777#2:240\n873#2,2:241\n1391#2:243\n1480#2,5:244\n1696#2,8:249\n1642#2,10:257\n1915#2:267\n1916#2:269\n1652#2:270\n1#3:208\n1#3:237\n1#3:268\n*S KotlinDebug\n*F\n+ 1 DataSourceLoader.kt\ncom/intellij/jpa/jpb/model/backend/ds/DataSourceLoader\n*L\n40#1:196,12\n46#1:209\n46#1:210,5\n48#1:215,8\n58#1:223\n58#1:224,2\n59#1:226,10\n59#1:236\n59#1:238\n59#1:239\n65#1:240\n65#1:241,2\n69#1:243\n69#1:244,5\n85#1:249,8\n86#1:257,10\n86#1:267\n86#1:269\n86#1:270\n59#1:237\n86#1:268\n*E\n"})
public final class DataSourceLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final SpringPropertiesConfiguration propertiesConfiguration;
    @NotNull
    private static final Pattern SPEL_PATTERN;
    @NotNull
    public static final String JDBC_START_PREFIX = "jdbc:";

    public DataSourceLoader(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.propertiesConfiguration = SpringPropertiesConfiguration.Companion.getInstance(this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final List<DataStore> getReverseEngineeringDataStores(@NotNull OrmFramework ormFramework) {
        Intrinsics.checkNotNullParameter((Object)ormFramework, (String)"ormFramework");
        return DbDriversManagerExtension.Companion.getInstance().getReverseEngineeringDataStores(this.project, ormFramework);
    }

    public static /* synthetic */ List getReverseEngineeringDataStores$default(DataSourceLoader dataSourceLoader, OrmFramework ormFramework, int n, Object object) {
        if ((n & 1) != 0) {
            ormFramework = JpaOrmFramework.INSTANCE;
        }
        return dataSourceLoader.getReverseEngineeringDataStores(ormFramework);
    }

    @NotNull
    public final List<DataStore> getCustomDataStores() {
        return DbDriversManagerExtension.Companion.getInstance().getCustomDataStores(this.project);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final AbstractRdbmsStore findDataStoreById(@Nullable String dataStoreId) {
        Object v0;
        block3: {
            void $this$filterIsInstanceTo$iv$iv;
            if (dataStoreId == null) {
                return null;
            }
            Iterable $this$filterIsInstance$iv = this.getCustomDataStores();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof AbstractRdbmsStore)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            for (Object e : iterable2) {
                AbstractRdbmsStore it = (AbstractRdbmsStore)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)dataStoreId)) continue;
                v0 = e;
                break block3;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CustomDataStore> getDetectedDataStores() {
        Object it;
        void $this$flatMapTo$iv$iv;
        List<PropertySource> allPropertySources = this.propertiesConfiguration.loadAllPropertySources();
        Iterable $this$flatMap$iv = allPropertySources;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (PropertySource)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.findDataStores((PropertySource)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List detectedDataStores = (List)destination$iv$iv;
        Iterable $this$distinctBy$iv = detectedDataStores;
        boolean $i$f$distinctBy = false;
        HashSet<DbProperties> set$iv = new HashSet<DbProperties>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            it = (CustomDataStore)e$iv;
            boolean bl = false;
            DbProperties key$iv = ((AbstractRdbmsStore)it).getDbProperties();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List distinctByPropertiesDataStores = list$iv;
        this.initUniqueDataStoreName(distinctByPropertiesDataStores);
        return distinctByPropertiesDataStores;
    }

    /*
     * WARNING - void declaration
     */
    private final void initUniqueDataStoreName(List<? extends CustomDataStore> dataStores) {
        List<DataStore> customDataStores = this.getCustomDataStores();
        for (CustomDataStore customDataStore : dataStores) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            String databaseName;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullExpressionValue((Object)customDataStore.getDbProperties().getDatabaseName(), (String)"getDatabaseName(...)");
            Iterable iterable = dataStores;
            Object object = customDataStores;
            boolean $i$f$filter = false;
            void var9_9 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CustomDataStore it = (CustomDataStore)element$iv$iv;
                boolean bl = false;
                if (!(it != customDataStore)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Set allDsWithoutCurr = CollectionsKt.union((Iterable)object, (Iterable)((List)destination$iv$iv));
            $this$filter$iv = allDsWithoutCurr;
            String string = databaseName;
            object = customDataStore;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                DataStore it = (DataStore)element$iv$iv;
                boolean bl2 = false;
                if (it.getName() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            ((AbstractRdbmsStore)object).setName(UniqueNameGenerator.generateUniqueName((String)string, (Collection)list));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<CustomDataStore> findDataStores(PropertySource propertySource) {
        void $this$flatMapTo$iv$iv;
        SpringProperty it;
        Iterable $this$filterTo$iv$iv;
        List<SpringProperty> allProperties = propertySource.getProperties();
        Iterable $this$filter$iv = allProperties;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SpringProperty)element$iv$iv;
            boolean bl = false;
            String propertyKey = it.getKey();
            if (!(StringsKt.endsWith((String)propertyKey, (String)".url", (boolean)true) || StringsKt.endsWith((String)propertyKey, (String)".jdbcUrl", (boolean)true) || StringsKt.endsWith((String)propertyKey, (String)".jdbc-url", (boolean)true))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List urlProperties = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = urlProperties;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (SpringProperty)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.createDataStores(allProperties, it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<CustomDataStore> createDataStores(List<? extends SpringProperty> allProperties, SpringProperty urlProperty) {
        void $this$mapNotNullTo$iv$iv;
        void $this$distinctBy$iv;
        String jdbcUrl = urlProperty.getValue();
        String dataSourceKeyPrefix = StringsKt.substringBeforeLast$default((String)urlProperty.getKey(), (String)".", null, (int)2, null);
        String[] stringArray = new String[]{"username"};
        String username = this.findPropertyValue(allProperties, dataSourceKeyPrefix, stringArray);
        String[] stringArray2 = new String[]{"password"};
        String password = this.findPropertyValue(allProperties, dataSourceKeyPrefix, stringArray2);
        String[] stringArray3 = new String[]{"driverClassName", "driver-class-name"};
        String driverClassName = this.findPropertyValue(allProperties, dataSourceKeyPrefix, stringArray3);
        Object object = new SpringDataSourceInfo[]{SpringDataSourceInfo.Companion.create(jdbcUrl, username, password, driverClassName, false), SpringDataSourceInfo.Companion.create(jdbcUrl, username, password, driverClassName, true)};
        object = CollectionsKt.listOfNotNull((Object[])object);
        boolean $i$f$distinctBy = false;
        Iterable<String> set$iv = new HashSet();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            SpringDataSourceInfo it = (SpringDataSourceInfo)e$iv;
            boolean bl = false;
            String key$iv = it.getUrl();
            if (!((HashSet)set$iv).add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List springDataSources = list$iv;
        Iterable $this$mapNotNull$iv = springDataSources;
        boolean $i$f$mapNotNull = false;
        set$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            CustomDataStore it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SpringDataSourceInfo it = (SpringDataSourceInfo)element$iv$iv;
            boolean bl2 = false;
            CustomDataStore dataStore = new CustomDataStore(this.project, UUID.randomUUID().toString(), dataSourceKeyPrefix);
            dataStore.setDbProperties(DbProperties.create(it.getUrl(), it.getDriverClassName()).setPassword(it.getPass()).setUser(it.getUsername()));
            if ((Intrinsics.areEqual((Object)dataStore.getDbProperties().getType(), (Object)DbType.UNKNOWN) ? null : dataStore) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String findPropertyValue(List<? extends SpringProperty> allProperties, String dataSourceKeyPrefix, String ... keyPostfixes) {
        for (String keyPostfix : keyPostfixes) {
            String value;
            Object v0;
            block2: {
                Iterable iterable = allProperties;
                for (Object t : iterable) {
                    SpringProperty it = (SpringProperty)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getKey(), (Object)(dataSourceKeyPrefix + "." + keyPostfix))) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            SpringProperty springProperty = v0;
            String string = value = springProperty != null ? springProperty.getValue() : null;
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Nullable
    public final Credentials getCredentials(@NotNull DataSourceInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        PasswordSafe passwordSafe = PasswordSafe.Companion.getInstance();
        String string = info.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        Credentials credentials = passwordSafe.get(this.createCredentialAttributes(string));
        if (credentials != null) {
            return credentials;
        }
        PasswordSafe passwordSafe2 = PasswordSafe.Companion.getInstance();
        String string2 = info.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUrl(...)");
        return passwordSafe2.get(this.createCredentialAttributes(string2));
    }

    public final void saveCredentials(@NotNull DataStore dataStore) {
        Intrinsics.checkNotNullParameter((Object)dataStore, (String)"dataStore");
        AbstractRdbmsStore abstractRdbmsStore = dataStore instanceof AbstractRdbmsStore ? (AbstractRdbmsStore)dataStore : null;
        if (abstractRdbmsStore == null) {
            return;
        }
        AbstractRdbmsStore rdbmsStore = abstractRdbmsStore;
        DbProperties dbProperties = rdbmsStore.getDbProperties();
        if (dbProperties == null) {
            return;
        }
        DbProperties dbProperties2 = dbProperties;
        String string = ((AbstractRdbmsStore)dataStore).getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        CredentialAttributes credentialAttributes = this.createCredentialAttributes(string);
        Credentials credentials = new Credentials(dbProperties2.getUser(), dbProperties2.getPassword());
        PasswordSafe.Companion.getInstance().set(credentialAttributes, credentials);
    }

    public final void removeCredentials(@NotNull DataStore dataStore) {
        Intrinsics.checkNotNullParameter((Object)dataStore, (String)"dataStore");
        AbstractRdbmsStore abstractRdbmsStore = dataStore instanceof AbstractRdbmsStore ? (AbstractRdbmsStore)dataStore : null;
        if (abstractRdbmsStore == null) {
            return;
        }
        AbstractRdbmsStore rdbmsStore = abstractRdbmsStore;
        String string = rdbmsStore.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        CredentialAttributes credentialAttributes = this.createCredentialAttributes(string);
        PasswordSafe.Companion.getInstance().set(credentialAttributes, null);
    }

    private final CredentialAttributes createCredentialAttributes(String key) {
        return new CredentialAttributes(CredentialAttributesKt.generateServiceName((String)"DataSource", (String)key), null);
    }

    @JvmStatic
    @NotNull
    public static final DataSourceLoader getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    static {
        Pattern pattern = Pattern.compile("\\$\\{(\\w+?)(?:\\:(\\S+?))?\\}");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        SPEL_PATTERN = pattern;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jpa/jpb/model/backend/ds/DataSourceLoader$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jpa/jpb/model/backend/ds/DataSourceLoader;", "project", "Lcom/intellij/openapi/project/Project;", "SPEL_PATTERN", "Ljava/util/regex/Pattern;", "getSPEL_PATTERN", "()Ljava/util/regex/Pattern;", "JDBC_START_PREFIX", "", "intellij.javaee.jpa.jpb.model"})
    @SourceDebugExtension(value={"SMAP\nDataSourceLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceLoader.kt\ncom/intellij/jpa/jpb/model/backend/ds/DataSourceLoader$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,195:1\n30#2,2:196\n*S KotlinDebug\n*F\n+ 1 DataSourceLoader.kt\ncom/intellij/jpa/jpb/model/backend/ds/DataSourceLoader$Companion\n*L\n139#1:196,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DataSourceLoader getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<DataSourceLoader> serviceClass$iv = DataSourceLoader.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DataSourceLoader)object;
        }

        @NotNull
        public final Pattern getSPEL_PATTERN() {
            return SPEL_PATTERN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J7\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0014\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0016\u001a\u00020\u0017H\u00d6\u0081\u0004J\n\u0010\u0018\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/intellij/jpa/jpb/model/backend/ds/DataSourceLoader$SpringDataSourceInfo;", "", "url", "", "username", "pass", "driverClassName", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getUrl", "()Ljava/lang/String;", "getUsername", "getPass", "getDriverClassName", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.javaee.jpa.jpb.model"})
    public static final class SpringDataSourceInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String url;
        @Nullable
        private final String username;
        @Nullable
        private final String pass;
        @Nullable
        private final String driverClassName;

        public SpringDataSourceInfo(@NotNull String url, @Nullable String username, @Nullable String pass, @Nullable String driverClassName) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.url = url;
            this.username = username;
            this.pass = pass;
            this.driverClassName = driverClassName;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @Nullable
        public final String getUsername() {
            return this.username;
        }

        @Nullable
        public final String getPass() {
            return this.pass;
        }

        @Nullable
        public final String getDriverClassName() {
            return this.driverClassName;
        }

        @NotNull
        public final String component1() {
            return this.url;
        }

        @Nullable
        public final String component2() {
            return this.username;
        }

        @Nullable
        public final String component3() {
            return this.pass;
        }

        @Nullable
        public final String component4() {
            return this.driverClassName;
        }

        @NotNull
        public final SpringDataSourceInfo copy(@NotNull String url, @Nullable String username, @Nullable String pass, @Nullable String driverClassName) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new SpringDataSourceInfo(url, username, pass, driverClassName);
        }

        public static /* synthetic */ SpringDataSourceInfo copy$default(SpringDataSourceInfo springDataSourceInfo, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = springDataSourceInfo.url;
            }
            if ((n & 2) != 0) {
                string2 = springDataSourceInfo.username;
            }
            if ((n & 4) != 0) {
                string3 = springDataSourceInfo.pass;
            }
            if ((n & 8) != 0) {
                string4 = springDataSourceInfo.driverClassName;
            }
            return springDataSourceInfo.copy(string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "SpringDataSourceInfo(url=" + this.url + ", username=" + this.username + ", pass=" + this.pass + ", driverClassName=" + this.driverClassName + ")";
        }

        public int hashCode() {
            int result = this.url.hashCode();
            result = result * 31 + (this.username == null ? 0 : this.username.hashCode());
            result = result * 31 + (this.pass == null ? 0 : this.pass.hashCode());
            result = result * 31 + (this.driverClassName == null ? 0 : this.driverClassName.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SpringDataSourceInfo)) {
                return false;
            }
            SpringDataSourceInfo springDataSourceInfo = (SpringDataSourceInfo)other;
            if (!Intrinsics.areEqual((Object)this.url, (Object)springDataSourceInfo.url)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.username, (Object)springDataSourceInfo.username)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pass, (Object)springDataSourceInfo.pass)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.driverClassName, (Object)springDataSourceInfo.driverClassName);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/jpa/jpb/model/backend/ds/DataSourceLoader$SpringDataSourceInfo$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/jpa/jpb/model/backend/ds/DataSourceLoader$SpringDataSourceInfo;", "url", "", "username", "pass", "driverClassName", "restoreByVar", "", "processSpelExpression", "value", "intellij.javaee.jpa.jpb.model"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final SpringDataSourceInfo create(@NotNull String url, @Nullable String username, @Nullable String pass, @Nullable String driverClassName, boolean restoreByVar) {
                String processedUrl;
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                String string = processedUrl = this.processSpelExpression(url, restoreByVar);
                boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)DataSourceLoader.JDBC_START_PREFIX, (boolean)false, (int)2, null) : false;
                if (bl) {
                    return new SpringDataSourceInfo(processedUrl, this.processSpelExpression(username, restoreByVar), this.processSpelExpression(pass, restoreByVar), this.processSpelExpression(driverClassName, restoreByVar));
                }
                return null;
            }

            private final String processSpelExpression(String value, boolean restoreByVar) {
                String string;
                if (value == null) {
                    return null;
                }
                Matcher matcher = DataSourceLoader.Companion.getSPEL_PATTERN().matcher(value);
                if (matcher.find()) {
                    CharSequence charSequence;
                    int n;
                    String replacementValue;
                    String string2;
                    if (restoreByVar) {
                        String envVariable = matcher.group(1);
                        string2 = System.getProperty(envVariable);
                        if (string2 == null) {
                            string2 = System.getenv(envVariable);
                        }
                    } else {
                        string2 = matcher.group(2);
                        if (string2 == null) {
                            string2 = null;
                        }
                    }
                    if ((replacementValue = string2) == null) {
                        return null;
                    }
                    String string3 = value;
                    int n2 = matcher.start(0);
                    String replacedValue = ((Object)StringsKt.replaceRange((CharSequence)string3, (int)n2, (int)(n = matcher.end(0)), (CharSequence)(charSequence = (CharSequence)replacementValue))).toString();
                    string = this.processSpelExpression(replacedValue, restoreByVar);
                    if (string == null) {
                        return null;
                    }
                } else {
                    string = value;
                }
                return string;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

