/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.orm.toolwindow.structure;

import com.intellij.icons.AllIcons;
import com.intellij.jpa.jpb.model.config.JpaPluginProjectConfig;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.jpa.jpb.model.orm.toolwindow.structure.OrmProjectViewPane;
import com.intellij.jpa.jpb.model.ui.structure.HProjectViewPane;
import com.intellij.jpa.jpb.model.ui.structure.StructureViewUpdateTrigger;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.psi.PsiElement;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0018\u0019\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0006\u0010\u000e\u001a\u00020\u000fJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/jpa/jpb/model/orm/toolwindow/structure/OrmStructurePanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectViewPane", "Lcom/intellij/jpa/jpb/model/orm/toolwindow/structure/OrmProjectViewPane;", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "getProjectViewPane", "Lcom/intellij/jpa/jpb/model/ui/structure/HProjectViewPane;", "getTitleActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "selectInStructure", "ormFramework", "Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;", "psiElement", "Lcom/intellij/psi/PsiElement;", "ExpandAllAction", "CollapseAllAction", "SearchInLibrariesAction", "intellij.javaee.jpa.jpb.model"})
public final class OrmStructurePanel
extends SimpleToolWindowPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final OrmProjectViewPane projectViewPane;

    public OrmStructurePanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(true, true);
        this.project = project;
        this.projectViewPane = new OrmProjectViewPane(this.project);
        this.setContent(this.projectViewPane.createComponent());
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        super.uiDataSnapshot(sink);
        DataSink.Companion.uiDataSnapshot(sink, (DataProvider)this.projectViewPane);
    }

    @NotNull
    public final HProjectViewPane getProjectViewPane() {
        return this.projectViewPane;
    }

    @NotNull
    public final List<AnAction> getTitleActions() {
        AnAction[] anActionArray;
        AnAction customGroup = ActionManager.getInstance().getAction("com.intellij.orm.structure.toolbar");
        if (customGroup instanceof DefaultActionGroup) {
            AnAction[] anActionArray2 = ((DefaultActionGroup)customGroup).getChildren(ActionManager.getInstance());
            anActionArray = anActionArray2;
            Intrinsics.checkNotNullExpressionValue((Object)anActionArray2, (String)"getChildren(...)");
        } else if (customGroup instanceof ActionGroup) {
            AnAction[] anActionArray3 = ((ActionGroup)customGroup).getChildren(null);
            anActionArray = anActionArray3;
            Intrinsics.checkNotNullExpressionValue((Object)anActionArray3, (String)"getChildren(...)");
        } else {
            anActionArray = new AnAction[]{};
        }
        AnAction[] customActions = anActionArray;
        SpreadBuilder spreadBuilder = new SpreadBuilder(4);
        spreadBuilder.addSpread((Object)customActions);
        spreadBuilder.add((Object)new SearchInLibrariesAction());
        spreadBuilder.add((Object)new ExpandAllAction());
        spreadBuilder.add((Object)new CollapseAllAction());
        return CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new AnAction[spreadBuilder.size()]));
    }

    public final void selectInStructure(@NotNull OrmFramework ormFramework) {
        Intrinsics.checkNotNullParameter((Object)ormFramework, (String)"ormFramework");
        this.projectViewPane.select(ormFramework);
    }

    public final void selectInStructure(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        this.projectViewPane.select(psiElement);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/jpa/jpb/model/orm/toolwindow/structure/OrmStructurePanel$CollapseAllAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "(Lcom/intellij/jpa/jpb/model/orm/toolwindow/structure/OrmStructurePanel;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.javaee.jpa.jpb.model"})
    private final class CollapseAllAction
    extends AnAction {
        public CollapseAllAction() {
            super(JpaModelBundle.message("ViewPropertiesPanel.collapseAll", new Object[0]), null, AllIcons.Actions.Collapseall);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            TreeUtil.collapseAll((JTree)OrmStructurePanel.this.projectViewPane.getTree(), (int)0);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/jpa/jpb/model/orm/toolwindow/structure/OrmStructurePanel$ExpandAllAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "(Lcom/intellij/jpa/jpb/model/orm/toolwindow/structure/OrmStructurePanel;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.javaee.jpa.jpb.model"})
    private final class ExpandAllAction
    extends AnAction {
        public ExpandAllAction() {
            super(JpaModelBundle.message("ViewPropertiesPanel.expandAll", new Object[0]), null, AllIcons.Actions.Expandall);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            TreeUtil.expandAll((JTree)OrmStructurePanel.this.projectViewPane.getTree());
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/jpa/jpb/model/orm/toolwindow/structure/OrmStructurePanel$SearchInLibrariesAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "<init>", "(Lcom/intellij/jpa/jpb/model/orm/toolwindow/structure/OrmStructurePanel;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.javaee.jpa.jpb.model"})
    private final class SearchInLibrariesAction
    extends ToggleAction {
        public SearchInLibrariesAction() {
            super(SearchInLibrariesAction::_init_$lambda$0, AllIcons.Nodes.PpLib);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Boolean bl = JpaPluginProjectConfig.Companion.getState((Project)OrmStructurePanel.this.getProject()).isShowLibraryClassesInOrmView;
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"isShowLibraryClassesInOrmView");
            return bl;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            JpaPluginProjectConfig.Companion.getState((Project)OrmStructurePanel.this.getProject()).isShowLibraryClassesInOrmView = state;
            ArrayList defaultList = new ArrayList();
            ((StructureViewUpdateTrigger)OrmStructurePanel.this.getProject().getMessageBus().syncPublisher(StructureViewUpdateTrigger.TOPIC)).update(defaultList);
        }

        private static final String _init_$lambda$0() {
            return JpaModelBundle.message("ViewPropertiesPanel.showLibrariesClasses", new Object[0]);
        }
    }
}

