/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.util;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.jpa.jpb.model.backend.ed.EntityDesignHelper;
import com.intellij.jpa.jpb.model.backend.ed.annotation.Annotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.AnnotationHelper;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaAttributeAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaEntityAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.indexing.CustomTypeModel;
import com.intellij.jpa.jpb.model.backend.ed.indexing.EntitySearch;
import com.intellij.jpa.jpb.model.backend.ed.indexing.HibernateCustomTypeModel;
import com.intellij.jpa.jpb.model.backend.ed.indexing.HibernateCustomTypeService;
import com.intellij.jpa.jpb.model.backend.props.SpringPropertiesConfiguration;
import com.intellij.jpa.jpb.model.config.JpaBuddyIdeaProjectConfig;
import com.intellij.jpa.jpb.model.config.SequenceNamingStrategyEnum;
import com.intellij.jpa.jpb.model.core.CacheKeyStore;
import com.intellij.jpa.jpb.model.core.multilanguage.SupportedLanguagesManager;
import com.intellij.jpa.jpb.model.ed.AttrColumnInfo;
import com.intellij.jpa.jpb.model.ed.JpaAnnotationHelper;
import com.intellij.jpa.jpb.model.model.AttributeOverride;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityAttributeCacheProvider;
import com.intellij.jpa.jpb.model.model.EntityAttributeModel;
import com.intellij.jpa.jpb.model.model.EntityAttributePsi;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.model.GenericGenerator;
import com.intellij.jpa.jpb.model.model.Index;
import com.intellij.jpa.jpb.model.model.LockModeType;
import com.intellij.jpa.jpb.model.model.NamedQuery;
import com.intellij.jpa.jpb.model.model.SequenceGenerator;
import com.intellij.jpa.jpb.model.properties.PropertySource;
import com.intellij.jpa.jpb.model.properties.SpringProperty;
import com.intellij.jpa.jpb.model.reference.TemplateHelper;
import com.intellij.jpa.jpb.model.util.AttributeUtil;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.jpa.jpb.model.util.MetadataDatatype;
import com.intellij.jpa.jpb.model.util.SearchHelper;
import com.intellij.jpa.jpb.model.util.StudioAnnotationUtil;
import com.intellij.jpa.jpb.model.util.annotation.JoinColumn;
import com.intellij.jpa.jpb.model.util.annotation.JoinTable;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class EntityUtil {
    public static final String MAP_FQN = "java.util.Map";
    private static final String PERSISTENCE_ROOT_TAG = "persistence";
    private static final String PERSISTENCE_UNIT = "persistence-unit";
    private static final String METADATA_MODEL = "metadata-model";
    private static final String GET_PREFIX = PropertyKind.GETTER.prefix;
    private static final String IS_PREFIX = PropertyKind.BOOLEAN_GETTER.prefix;
    private static Logger log = Logger.getInstance(EntityUtil.class);
    private static final ConcurrentMap<String, Key<CachedValue>> globalKeyForProvider = new ConcurrentHashMap<String, Key<CachedValue>>();

    public static EntityUtil getInstance(@NotNull Project project) {
        if (project == null) {
            EntityUtil.$$$reportNull$$$0(0);
        }
        return (EntityUtil)project.getService(EntityUtil.class);
    }

    public static String getCollectionTypeFqn(PsiMember member) {
        return (String)EntityUtil.raPsiCached((PsiElement)member, () -> {
            String typeFqn;
            String[] splitted;
            PsiType type = AttributeUtil.getMemberType(member);
            if (type != null && (splitted = (typeFqn = type.getCanonicalText()).split("[<>]")).length == 2) {
                return splitted[0];
            }
            return null;
        });
    }

    @Nullable
    public static Datatypes.CollectionDatatype getCollectionType(@NotNull PsiMember member) {
        if (member == null) {
            EntityUtil.$$$reportNull$$$0(1);
        }
        return (Datatypes.CollectionDatatype)((Object)EntityUtil.raPsiCached((PsiElement)member, "getCollectionType", () -> {
            String typeFqn = EntityUtil.getCollectionTypeFqn(member);
            if (typeFqn != null) {
                return Datatypes.CollectionDatatype.getByClassname(ClassUtil.extractClassName((String)typeFqn));
            }
            return null;
        }));
    }

    @Nullable
    public static String generateDefaultColumnName(@NotNull Project project, @NotNull EntityAttribute attr) {
        if (project == null) {
            EntityUtil.$$$reportNull$$$0(2);
        }
        if (attr == null) {
            EntityUtil.$$$reportNull$$$0(3);
        }
        return EntityDesignHelper.getInstance(project).generateAttributeColumnName(new AttrColumnInfo(attr.getName(), attr.getMappingType(), attr.getCardinality(), attr.getType(), attr.isOwner()).withConverter(s -> s).withGenericType(attr.isGenericType()));
    }

    public static boolean isCollectionType(PsiType field) {
        if (!(field instanceof PsiClassType)) {
            return false;
        }
        PsiClass aClass = ((PsiClassType)field).resolve();
        if (aClass == null) {
            return false;
        }
        PsiClass collectionClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("java.util.Collection", GlobalSearchScope.allScope((Project)aClass.getProject()));
        return collectionClass != null && (aClass.isInheritor(collectionClass, true) || aClass.isEquivalentTo((PsiElement)collectionClass));
    }

    @Nullable
    public static String getPropertyName(PsiMember member) {
        if (member instanceof PsiMethod) {
            return EntityUtil.getPropertyName((PsiMethod)member);
        }
        if (member instanceof PsiField) {
            return member.getName();
        }
        return null;
    }

    @Nullable
    public static String getPropertyName(@NotNull PsiMethod method) {
        if (method == null) {
            EntityUtil.$$$reportNull$$$0(4);
        }
        if (PropertyUtilBase.isSimplePropertyGetter((PsiMethod)method)) {
            return EntityUtil.getPropertyNameByGetter(method);
        }
        return null;
    }

    @NotNull
    public static String getPropertyNameByGetter(PsiMethod getterMethod) {
        @NonNls String methodName = getterMethod.getName();
        if (methodName.startsWith(GET_PREFIX)) {
            String string = EntityUtil.decapitalize(methodName.substring(3));
            if (string == null) {
                EntityUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (methodName.startsWith(IS_PREFIX)) {
            String string = EntityUtil.decapitalize(methodName.substring(2));
            if (string == null) {
                EntityUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = methodName;
        if (string == null) {
            EntityUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static String decapitalize(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static String getGetterPropertyName(PsiMember member) {
        if (member instanceof PsiMethod) {
            return EntityUtil.getPropertyName((PsiMethod)member);
        }
        if (member instanceof PsiField) {
            return EntityUtil.getGetterPropertyByField((PsiField)member);
        }
        return null;
    }

    private static String getGetterPropertyByField(PsiField member) {
        PsiClass containingClass = member.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        if (!containingClass.getLanguage().equals(JavaLanguage.INSTANCE)) {
            return member.getName();
        }
        String suggestedGetterName = PropertyUtil.suggestGetterName((PsiField)member);
        List getterCandidates = (List)((StreamEx)StreamEx.of((Object[])containingClass.getAllMethods()).filter(method -> Objects.equals(method.getReturnType(), member.getType()) && PropertyUtil.isSimplePropertyGetter((PsiMethod)method))).collect(Collectors.toList());
        PsiMethod getterByName = StreamEx.of((Collection)getterCandidates).findFirst(method -> Objects.equals(method.getName(), suggestedGetterName)).orElse(null);
        if (getterByName != null) {
            return member.getName();
        }
        PsiMethod getterByField = StreamEx.of((Collection)getterCandidates).findFirst(method -> member.isEquivalentTo((PsiElement)PropertyUtilBase.findPropertyFieldByMember((PsiMember)method))).orElse(null);
        if (getterByField != null) {
            return EntityUtil.getPropertyName(getterByField);
        }
        return null;
    }

    public static List<PsiField> getAnnotatedSingleFields(PsiClass _class) {
        ArrayList<PsiField> result = new ArrayList<PsiField>();
        EntityUtil.ra(() -> {
            PsiField[] psiFields;
            for (PsiField psiField : psiFields = _class.getFields()) {
                if (!EntityUtil.hasSingleAnnotation(psiField)) continue;
                result.add(psiField);
            }
        });
        return result;
    }

    public static boolean hasSingleAnnotation(PsiField psiField) {
        Project project = psiField.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)psiField);
        boolean hasPhysicalAnn = EntityUtil.hasOneOfAnnotations((PsiModifierListOwner)psiField, JpaAttributeAnnotation.Column.getFqn(project, module), JpaAttributeAnnotation.ManyToOne.getFqn(project, module), JpaAttributeAnnotation.OneToOne.getFqn(project, module), JpaAttributeAnnotation.Embedded.getFqn(project, module), JpaAttributeAnnotation.EmbeddedId.getFqn(project, module));
        return hasPhysicalAnn || EntityAttributeCacheProvider.isPotentiallyHaveColumn((PsiMember)psiField);
    }

    public static List<PsiField> getAnnotatedMultiFields(PsiClass _class) {
        ArrayList<PsiField> result = new ArrayList<PsiField>();
        EntityUtil.ra(() -> {
            PsiField[] psiFields;
            for (PsiField psiField : psiFields = _class.getFields()) {
                if (!EntityUtil.hasMultiAnnotation(psiField)) continue;
                result.add(psiField);
            }
        });
        return result;
    }

    public static boolean hasMultiAnnotation(PsiField psiField) {
        Project project = psiField.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)psiField);
        return EntityUtil.hasOneOfAnnotations((PsiModifierListOwner)psiField, JpaAttributeAnnotation.OneToMany.getFqn(project, module), JpaAttributeAnnotation.ManyToMany.getFqn(project, module));
    }

    public static List<PsiField> collectAllReferenceFields(PsiClass _class) {
        ArrayList<PsiField> result = new ArrayList<PsiField>();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)_class);
        EntityUtil.ra(() -> {
            PsiClass parentClass = _class.getSuperClass();
            if (parentClass != null) {
                result.addAll(EntityUtil.collectAllReferenceFields(parentClass));
            }
            PsiField[] ownFields = _class.getFields();
            Project project = _class.getProject();
            for (PsiField field : ownFields) {
                PsiClass referencedClass;
                if (!EntityUtil.hasOneOfAnnotations((PsiModifierListOwner)field, JpaAttributeAnnotation.OneToOne.getFqn(project, module), JpaAttributeAnnotation.ManyToOne.getFqn(project, module), JpaAttributeAnnotation.OneToMany.getFqn(project, module), JpaAttributeAnnotation.ManyToMany.getFqn(project, module), JpaAttributeAnnotation.Embedded.getFqn(project, module)) || !EntityUtil.isEntity(referencedClass = AttributeUtil.getReferencedClass((PsiMember)field))) continue;
                result.add(field);
            }
        });
        return result;
    }

    @NotNull
    public String getEntityName(PsiClass entityClass) {
        String string = (String)EntityUtil.ra(() -> {
            String entityName = this.getEntityNameFromAnnotation(entityClass);
            if (StringUtils.isEmpty((CharSequence)entityName)) {
                entityName = entityClass.getName();
            }
            return entityName == null ? "" : entityName;
        });
        if (string == null) {
            EntityUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public String getEntityNameFromAnnotation(PsiClass _class) {
        return (String)EntityUtil.raPsiCached((PsiElement)_class, () -> {
            PsiAnnotation nameOwnerAnnotation = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)_class, JpaEntityAnnotation.Entity);
            String name = nameOwnerAnnotation != null ? AnnotationUtil.getStringAttributeValue((PsiAnnotation)nameOwnerAnnotation, (String)"name") : null;
            return StringUtils.isEmpty((CharSequence)name) ? null : name;
        });
    }

    public static Map<String, Set<String>> getAllSchemas(Project project) {
        Map result = FactoryMap.create(key -> new HashSet());
        Collection<PsiClass> entities = EntitySearch.getInstance(project).getEntities(GlobalSearchScope.allScope((Project)project));
        entities.forEach(entity -> {
            String schema = EntityUtil.getEntitySchema(entity);
            if (!StringUtils.isBlank((CharSequence)schema)) {
                ((Set)result.get(schema)).add(entity.getName());
            }
        });
        return result;
    }

    public static Map<String, Set<String>> getAllCatalogs(Project project) {
        Map result = FactoryMap.create(key -> new HashSet());
        Collection<PsiClass> entities = EntitySearch.getInstance(project).getEntities(GlobalSearchScope.allScope((Project)project));
        entities.forEach(entity -> {
            String catalog = EntityUtil.getEntityCatalog(entity);
            if (!StringUtils.isBlank((CharSequence)catalog)) {
                ((Set)result.get(catalog)).add(entity.getName());
            }
        });
        return result;
    }

    public static String getEntitySchema(PsiClass psiClass) {
        return (String)EntityUtil.raPsiCached((PsiElement)psiClass, () -> {
            String schema;
            PsiAnnotation annotation = psiClass.getAnnotation(JpaEntityAnnotation.Table.getFqn(psiClass.getProject(), ModuleUtil.findModuleForPsiElement((PsiElement)psiClass)));
            if (annotation != null && (schema = AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, (String)"schema")) != null) {
                return schema;
            }
            return null;
        });
    }

    public static String getEntityCatalog(PsiClass psiClass) {
        return (String)EntityUtil.raPsiCached((PsiElement)psiClass, () -> {
            String catalog;
            PsiAnnotation annotation = psiClass.getAnnotation(JpaEntityAnnotation.Table.getFqn(psiClass.getProject(), ModuleUtil.findModuleForPsiElement((PsiElement)psiClass)));
            if (annotation != null && (catalog = AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, (String)"catalog")) != null) {
                return catalog;
            }
            return null;
        });
    }

    public static List<SequenceGenerator> getAllGenerators(Project project) {
        return (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            ArrayList<SequenceGenerator> result = new ArrayList<SequenceGenerator>();
            Collection<PsiClass> entities = EntitySearch.getInstance(project).getProjectEntities();
            for (PsiClass entity : entities) {
                SequenceGenerator sequenceGenerator = EntityPsi.getInstance(entity).getSequenceGenerator();
                if (sequenceGenerator == null) continue;
                result.add(sequenceGenerator);
            }
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    public static EntityPsi getEntityWithGenerator(Project project, String generatorName) {
        Collection<PsiClass> entities = EntitySearch.getInstance(project).getProjectEntities();
        for (PsiClass entity : entities) {
            EntityPsi entityPsi = EntityPsi.getInstance(entity);
            SequenceGenerator sequenceGenerator = entityPsi.getSequenceGenerator();
            if (sequenceGenerator == null || !generatorName.equals(sequenceGenerator.getName())) continue;
            return entityPsi;
        }
        return null;
    }

    @Nullable
    public static String getAttributeValue(PsiAnnotation annotation, String attributeName) {
        return EntityUtil.getAttributeValue(annotation, attributeName, null);
    }

    public static String getAttributeValue(@NotNull PsiAnnotation annotation, String attributeName, String defaultValue) {
        if (annotation == null) {
            EntityUtil.$$$reportNull$$$0(9);
        }
        return (String)EntityUtil.ra(() -> {
            String value = AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, (String)attributeName);
            return value == null ? defaultValue : value;
        });
    }

    public static boolean hasAnnotation(PsiModifierListOwner owner, String annotationQualifiedName) {
        return (Boolean)EntityUtil.ra(() -> {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{annotationQualifiedName});
            return annotation != null;
        });
    }

    public static boolean hasAnnotationLight(PsiModifierListOwner owner, String annotationQualifiedName) {
        return (Boolean)EntityUtil.ra(() -> owner.hasAnnotation(annotationQualifiedName));
    }

    @Contract(value="null, _ -> false")
    public static boolean hasOneOfAnnotationsLight(@Nullable PsiModifierListOwner owner, String ... annotationClasses) {
        if (annotationClasses == null) {
            EntityUtil.$$$reportNull$$$0(10);
        }
        return owner != null && (Boolean)EntityUtil.ra(() -> Stream.of(annotationClasses).anyMatch(arg_0 -> ((PsiModifierListOwner)owner).hasAnnotation(arg_0))) != false;
    }

    @Contract(value="null, _ -> false")
    public static boolean hasOneOfAnnotations(@Nullable PsiModifierListOwner owner, String ... annotationClasses) {
        if (annotationClasses == null) {
            EntityUtil.$$$reportNull$$$0(11);
        }
        return owner != null && (Boolean)EntityUtil.ra(() -> {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])annotationClasses);
            return annotation != null;
        }) != false;
    }

    @Nullable
    public static String getAnnotationAttribute(PsiModifierListOwner _class, String annotationClass, String attributeName) {
        return (String)EntityUtil.ra(() -> {
            PsiAnnotation entityAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)_class, (String[])new String[]{annotationClass});
            if (entityAnnotation != null) {
                PsiAnnotationMemberValue memberValue = entityAnnotation.findAttributeValue(attributeName);
                return EntityUtil.getValue(memberValue);
            }
            return null;
        });
    }

    @Nullable
    public static String getValue(PsiAnnotationMemberValue memberValue) {
        return (String)EntityUtil.ra(() -> {
            PsiReferenceExpression expr;
            PsiElement refElement;
            if (memberValue == null) {
                return null;
            }
            if (memberValue instanceof PsiLiteral) {
                Object value = ((PsiLiteral)memberValue).getValue();
                return String.valueOf(value);
            }
            if (memberValue instanceof PsiReferenceExpression && (refElement = (expr = (PsiReferenceExpression)memberValue).resolve()) instanceof PsiVariable) {
                return refElement.getText();
            }
            return memberValue.getText();
        });
    }

    public static boolean isEnum(@NotNull PsiClass enumClass) {
        if (enumClass == null) {
            EntityUtil.$$$reportNull$$$0(12);
        }
        return EntityUtil.getInstance(enumClass.getProject()).isEnum_(enumClass);
    }

    @Nullable
    public static HibernateCustomTypeModel getHibernateType(PsiAnnotation typeDefAnn) {
        return EntityUtil.collectTypes(typeDefAnn);
    }

    public static List<HibernateCustomTypeModel> getHibernateTypes(PsiAnnotation typeDefsAnn) {
        Collection<PsiAnnotation> typeDefAnnotations = StudioAnnotationUtil.getArrayValueAnnotations(typeDefsAnn, "value");
        return (List)StreamEx.of(typeDefAnnotations).map(EntityUtil::collectTypes).nonNull().collect(Collectors.toList());
    }

    public boolean isEnum_(@NotNull PsiClass enumClass) {
        if (enumClass == null) {
            EntityUtil.$$$reportNull$$$0(13);
        }
        return enumClass.isEnum();
    }

    @Contract(value="null -> false")
    public static boolean isEntity(@Nullable PsiClass _class) {
        return _class != null && SupportedLanguagesManager.isElementSupported((PsiElement)_class) && EntityUtil.getInstance(_class.getProject()).isEntity_(_class);
    }

    public boolean isEntity_(@NotNull PsiClass _class) {
        if (_class == null) {
            EntityUtil.$$$reportNull$$$0(14);
        }
        return (Boolean)EntityUtil.raPsiCached((PsiElement)_class, () -> {
            Project project = _class.getProject();
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)_class);
            return EntityUtil.hasOneOfAnnotationsLight((PsiModifierListOwner)_class, JpaEntityAnnotation.Entity.getFqn(project, module), JpaEntityAnnotation.MappedSuperclass.getFqn(project, module), JpaEntityAnnotation.Embeddable.getFqn(project, module));
        });
    }

    @Nullable
    public static String getPropertyTypeName(PsiClass psiClass, String name) {
        return (String)EntityUtil.ra(() -> {
            PsiMember member = EntityUtil.getProperty(psiClass, name);
            return member != null ? EntityUtil.getPropertyTypeName(member) : null;
        });
    }

    @Nullable
    public static PsiType getPropertyType(@Nullable PsiMember member) {
        return (PsiType)EntityUtil.ra(() -> {
            PsiClassType refType;
            PsiType type;
            if (member instanceof PsiField) {
                type = ((PsiField)member).getType();
            } else if (member instanceof PsiMethod) {
                type = ((PsiMethod)member).getReturnType();
            } else {
                return null;
            }
            if (type == null) {
                return null;
            }
            if (type instanceof PsiClassType && (refType = (PsiClassType)type).getParameters().length == 1) {
                return refType.getParameters()[0];
            }
            return type;
        });
    }

    @Nullable
    public static String getPropertyTypeName(PsiMember member) {
        return (String)EntityUtil.ra(() -> {
            PsiType type = EntityUtil.getPropertyType(member);
            if (type != null) {
                return type.getCanonicalText();
            }
            return null;
        });
    }

    public static PsiMember getActualPropertyByPath(PsiClass psiClass, String path) {
        return (PsiMember)EntityUtil.ra(() -> {
            String[] pathParts = path.split("\\.");
            PsiMember member = null;
            for (String pathPart : pathParts) {
                PsiClass aClass;
                if (member != null) {
                    PsiType type = EntityUtil.getPropertyType(member);
                    aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
                } else {
                    aClass = psiClass;
                }
                if (aClass == null) {
                    return null;
                }
                member = EntityUtil.getActualProperty(aClass, pathPart);
                if (member != null) continue;
                return null;
            }
            return member;
        });
    }

    @Nullable
    public static PsiMember getActualProperty(@NotNull PsiClass psiClass, String name) {
        if (psiClass == null) {
            EntityUtil.$$$reportNull$$$0(15);
        }
        return (PsiMember)EntityUtil.ra(() -> EntityUtil.getInstance(psiClass.getProject()).getActualProperty_(psiClass, name));
    }

    public PsiMember getActualProperty_(@NotNull PsiClass psiClass, String name) {
        if (psiClass == null) {
            EntityUtil.$$$reportNull$$$0(16);
        }
        return psiClass.findFieldByName(name, true);
    }

    @Nullable
    public static PsiMember getProperty(PsiClass psiClass, String name) {
        return (PsiMember)EntityUtil.ra(() -> {
            if (StringUtils.isBlank((CharSequence)name)) {
                return null;
            }
            PsiField field = psiClass.findFieldByName(name, true);
            if (field == null) {
                PsiMethod[] methods;
                for (PsiMethod method : methods = psiClass.findMethodsByName(EntityUtil.suggestGetterName(name), true)) {
                    if (!EntityUtil.isActualEntityMethod(method)) continue;
                    return method;
                }
                return null;
            }
            return field;
        });
    }

    public static boolean isActualEntityField(@NotNull PsiField field) {
        if (field == null) {
            EntityUtil.$$$reportNull$$$0(17);
        }
        return EntityUtil.getInstance(field.getProject()).isActualEntityField_(field);
    }

    private boolean isActualEntityField_(@NotNull PsiField field) {
        if (field == null) {
            EntityUtil.$$$reportNull$$$0(18);
        }
        if (field.hasModifierProperty("static") || field.hasModifierProperty("final") || field.hasModifierProperty("transient")) {
            return false;
        }
        return AttributeUtil.isPersistent(field) || AttributeUtil.isTransient(field);
    }

    public static boolean isActualEntityMethod(@NotNull PsiMethod method) {
        if (method == null) {
            EntityUtil.$$$reportNull$$$0(19);
        }
        return EntityUtil.getInstance(method.getProject()).isActualEntityMethod_(method);
    }

    private boolean isActualEntityMethod_(PsiMethod method) {
        return !method.getModifierList().hasModifierProperty("static") && method.getModifierList().hasModifierProperty("public") && StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)method, JpaAttributeAnnotation.Transient);
    }

    public static String suggestGetterName(@NotNull String propertyName) {
        if (propertyName == null) {
            EntityUtil.$$$reportNull$$$0(20);
        }
        StringBuilder name = new StringBuilder(StringUtil.capitalizeWithJavaBeanConvention((String)propertyName));
        name.insert(0, "get");
        return name.toString();
    }

    public static boolean isPersistentEntity(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            EntityUtil.$$$reportNull$$$0(21);
        }
        return EntityUtil.getInstance(psiClass.getProject()).isPersistentEntity_(psiClass);
    }

    private boolean isPersistentEntity_(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            EntityUtil.$$$reportNull$$$0(22);
        }
        return EntityUtil.hasAnnotationLight((PsiModifierListOwner)psiClass, JpaEntityAnnotation.Entity.getFqn(psiClass.getProject(), ModuleUtil.findModuleForPsiElement((PsiElement)psiClass)));
    }

    public static boolean isEmbeddable(PsiClass psiClass) {
        return EntityUtil.hasAnnotationLight((PsiModifierListOwner)psiClass, JpaEntityAnnotation.Embeddable.getFqn(psiClass.getProject(), ModuleUtil.findModuleForPsiElement((PsiElement)psiClass)));
    }

    @Deprecated
    public static boolean isDeepInheritor(PsiClass psiClass, String ancestorClassName, boolean strict) {
        return EntityUtil.isDeepInheritor(psiClass, ancestorClassName, strict, true);
    }

    public static boolean isDeepInheritor(PsiClass psiClass, String ancestorClassName, boolean strict, boolean checkDeep) {
        return (Boolean)EntityUtil.ra(() -> {
            if (ancestorClassName.equals(psiClass.getQualifiedName())) {
                return true;
            }
            Project project = psiClass.getProject();
            PsiClass ancestorClass = EntityUtil.getPsiClass(ancestorClassName, project);
            if (ancestorClass == null) {
                return !strict;
            }
            return psiClass.isInheritor(ancestorClass, checkDeep);
        });
    }

    @Nullable
    public static MetadataDatatype getDatatype(PsiClass psiClass, String propertyPath) {
        return (MetadataDatatype)((Object)EntityUtil.ra(() -> {
            PsiMember property = EntityUtil.getActualPropertyByPath(psiClass, propertyPath);
            if (property == null) {
                return null;
            }
            String propertyClass = EntityUtil.getPropertyTypeName(property);
            if (propertyClass == null) {
                return null;
            }
            if (propertyClass.equals(MetadataDatatype.DATE.getFqn())) {
                String temporalValue = EntityUtil.getAnnotationAttribute((PsiModifierListOwner)property, JpaAttributeAnnotation.Temporal.getFqn(psiClass.getProject(), ModuleUtil.findModuleForPsiElement((PsiElement)psiClass)), "value");
                return MetadataDatatype.findByTemporalValue(temporalValue);
            }
            if (Arrays.asList(Datatypes.BasicDatatype.LocalDateTime.getFqn(), Datatypes.BasicDatatype.OffsetDateTime.getFqn()).contains(propertyClass)) {
                return MetadataDatatype.DATE_TIME;
            }
            if (Datatypes.BasicDatatype.LocalDate.getFqn().equals(propertyClass)) {
                return MetadataDatatype.DATE;
            }
            if (Arrays.asList(Datatypes.BasicDatatype.LocalTime.getFqn(), Datatypes.BasicDatatype.OffsetTime.getFqn()).contains(propertyClass)) {
                return MetadataDatatype.TIME;
            }
            MetadataDatatype simpleDatatype = MetadataDatatype.findByFqn(propertyClass);
            if (simpleDatatype != null) {
                return simpleDatatype;
            }
            SearchHelper searchHelper = SearchHelper.getInstance(psiClass.getProject());
            PsiClass typeClass = searchHelper.findClass(propertyClass);
            if (typeClass == null) {
                return null;
            }
            if (typeClass.isEnum()) {
                return MetadataDatatype.ENUM;
            }
            return EntityUtil.isEntity(typeClass) ? MetadataDatatype.CLASS : null;
        }));
    }

    public static boolean isMappedSuperclass(PsiClass psiClass) {
        return EntityUtil.hasAnnotation((PsiModifierListOwner)psiClass, JpaEntityAnnotation.MappedSuperclass.getFqn(psiClass.getProject(), ModuleUtil.findModuleForPsiElement((PsiElement)psiClass)));
    }

    public static void registerEntity(@NotNull PsiClass entityClass, @NotNull XmlFile configFile) {
        XmlTag rootTag;
        if (entityClass == null) {
            EntityUtil.$$$reportNull$$$0(23);
        }
        if (configFile == null) {
            EntityUtil.$$$reportNull$$$0(24);
        }
        if ((rootTag = configFile.getRootTag()) == null) {
            log.warn("Root tag for config file: '" + String.valueOf(configFile) + "' is null");
            return;
        }
        boolean isPersistent = PERSISTENCE_ROOT_TAG.equals(rootTag.getName());
        EntityUtil.addClassTag(configFile, entityClass.getQualifiedName(), isPersistent);
    }

    public static void addClassTag(XmlFile configFile, String qualifiedName, boolean isPersistenceConfig) {
        String configElementTagName = isPersistenceConfig ? PERSISTENCE_UNIT : METADATA_MODEL;
        XmlTag rootTag = configFile.getRootTag();
        if (rootTag == null) {
            return;
        }
        XmlTag configTag = rootTag.findFirstSubTag(configElementTagName);
        if (configTag == null) {
            configTag = rootTag.addSubTag(rootTag.createChildTag(configElementTagName, "", null, false), true);
        }
        XmlTag[] classTags = configTag.findSubTags("class");
        XmlTag lastClassTag = null;
        if (classTags.length != 0) {
            lastClassTag = classTags[classTags.length - 1];
        }
        XmlTag newClassTag = configTag.createChildTag("class", "", qualifiedName, false);
        if (lastClassTag == null) {
            configTag.addSubTag(newClassTag, true);
        } else {
            configTag.addAfter((PsiElement)newClassTag, (PsiElement)lastClassTag);
        }
    }

    public static <T> T ra(Computable<T> computation) {
        return (T)ApplicationManager.getApplication().runReadAction(computation);
    }

    public static <T> T raPsiCached(@NotNull PsiElement psiElement, @NotNull Computable<T> computation) {
        if (psiElement == null) {
            EntityUtil.$$$reportNull$$$0(25);
        }
        if (computation == null) {
            EntityUtil.$$$reportNull$$$0(26);
        }
        return (T)((AtomicReference)EntityUtil.ra(() -> (AtomicReference)CachedValuesManager.getCachedValue((PsiElement)psiElement, EntityUtil.getKeyForClass(computation.getClass()), () -> {
            AtomicReference<Object> result = new AtomicReference<Object>(computation.compute());
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{EntityUtil.getCacheDependency(psiElement)});
        }))).get();
    }

    public static <T> T raPsiCached(PsiElement psiElement, String id, Computable<T> computation) {
        return (T)((AtomicReference)EntityUtil.ra(() -> (AtomicReference)CachedValuesManager.getCachedValue((PsiElement)psiElement, EntityUtil.getKeyForClassWithId(computation.getClass(), id), () -> {
            AtomicReference<Object> result = new AtomicReference<Object>(computation.compute());
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{EntityUtil.getCacheDependency(psiElement)});
        }))).get();
    }

    public static <T> T raPsiCachedWithDependencies(PsiElement psiElement, String id, Computable<ResultWithDependenciesWrapper<T>> computation) {
        return (T)((AtomicReference)EntityUtil.ra(() -> (AtomicReference)CachedValuesManager.getCachedValue((PsiElement)psiElement, EntityUtil.getKeyForClassWithId(computation.getClass(), id), () -> {
            ResultWithDependenciesWrapper wrapper = (ResultWithDependenciesWrapper)computation.compute();
            AtomicReference result = new AtomicReference(wrapper.result);
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{EntityUtil.getCacheDependency(psiElement), wrapper.dependencies.toArray()});
        }))).get();
    }

    public static PsiElement getCacheDependency(PsiElement psiElement) {
        try {
            Class<?> ktLightElement = Class.forName("org.jetbrains.kotlin.asJava.elements.KtLightElement");
            if (ktLightElement.isAssignableFrom(psiElement.getClass())) {
                return psiElement.getNavigationElement();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return psiElement;
    }

    @NotNull
    private static <T> Key<CachedValue<T>> getKeyForClass(@NotNull Class<?> providerClass) {
        if (providerClass == null) {
            EntityUtil.$$$reportNull$$$0(27);
        }
        String name = providerClass.getName();
        assert (name != null) : String.valueOf(providerClass) + " doesn't have a name; can't be used for cache value provider";
        return EntityUtil.getKeyForName(name, globalKeyForProvider);
    }

    @NotNull
    private static <T> Key<CachedValue<T>> getKeyForName(@NotNull String name, ConcurrentMap<String, Key<CachedValue>> keyForProvider) {
        Key key;
        if (name == null) {
            EntityUtil.$$$reportNull$$$0(28);
        }
        if ((key = (Key)keyForProvider.get(name)) == null) {
            key = (Key)ConcurrencyUtil.cacheOrGet(keyForProvider, (Object)name, (Object)Key.create((String)name));
        }
        Key key2 = key;
        if (key2 == null) {
            EntityUtil.$$$reportNull$$$0(29);
        }
        return key2;
    }

    @NotNull
    private static <T> Key<CachedValue<T>> getKeyForClassWithId(@NotNull Class<?> providerClass, String id) {
        String name;
        Key key;
        if (providerClass == null) {
            EntityUtil.$$$reportNull$$$0(30);
        }
        if ((key = (Key)globalKeyForProvider.get(name = providerClass.getName() + "_" + id)) == null) {
            key = (Key)ConcurrencyUtil.cacheOrGet(globalKeyForProvider, (Object)name, (Object)Key.create((String)name));
        }
        Key key2 = key;
        if (key2 == null) {
            EntityUtil.$$$reportNull$$$0(31);
        }
        return key2;
    }

    public static String calculateIndexName(String prefix, Entity entity, List<String> columns, boolean isUnique) {
        StringBuilder text = new StringBuilder((prefix + entity.getClassName()).toUpperCase());
        String UNQ_SUFFIX = "_UNQ";
        int suffixLength = isUnique ? UNQ_SUFFIX.length() : 0;
        for (int i = 0; i < columns.size() && columns.get(i) != null && text.length() + columns.get(i).length() + 1 + suffixLength < 30; ++i) {
            text.append("_").append(columns.get(i));
        }
        if (isUnique) {
            text.append(UNQ_SUFFIX);
        }
        return text.toString();
    }

    public static void ra(Runnable action2) {
        ApplicationManager.getApplication().runReadAction(action2);
    }

    @Nullable
    public static Entity.InheritanceType getInheritanceType(PsiClass entityClass) {
        PsiAnnotation annotation = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)entityClass, JpaEntityAnnotation.Inheritance);
        if (annotation == null) {
            return null;
        }
        String strategyValue = StudioAnnotationUtil.getDeclaredEnumStringValue(annotation, "strategy");
        return strategyValue != null ? Entity.InheritanceType.valueOf(strategyValue) : null;
    }

    public String getTable_(PsiClass entityClass) {
        return EntityUtil.getTable(entityClass, true);
    }

    @Nullable
    public static String getTable(PsiClass entityClass) {
        return EntityUtil.getInstance(entityClass.getProject()).getTable_(entityClass);
    }

    @Nullable
    public static String getTable(@NotNull PsiClass entityClass, boolean isTakeNameFromHierarchyRoot) {
        String entityFqn;
        if (entityClass == null) {
            EntityUtil.$$$reportNull$$$0(32);
        }
        if (StringUtil.isEmpty((String)(entityFqn = entityClass.getQualifiedName()))) {
            return null;
        }
        String keyValue = "EntityUtil#getTable:" + entityFqn + ":" + isTakeNameFromHierarchyRoot;
        Project project = entityClass.getProject();
        Key key = CacheKeyStore.getInstance(project).getKey(keyValue);
        return (String)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)entityClass, key, () -> {
            Pair tableWithDepends = (Pair)RecursionManager.doPreventingRecursion((Object)entityClass, (boolean)false, () -> EntityUtil.getTableWithDepends(entityClass, isTakeNameFromHierarchyRoot, project));
            if (tableWithDepends == null) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{entityClass});
            }
            ArrayList<PsiClass> depends = new ArrayList<PsiClass>();
            depends.add(entityClass);
            if (tableWithDepends.second != null) {
                depends.addAll((Collection)tableWithDepends.second);
            }
            return CachedValueProvider.Result.create((Object)((String)tableWithDepends.first), depends);
        }, false);
    }

    @Nullable
    private static Pair<String, Collection<Object>> getTableWithDepends(@NotNull PsiClass entityClass, boolean isTakeNameFromHierarchyRoot, Project project) {
        EntityPsi entityPsi;
        Entity hierarchyRoot;
        PsiAnnotation tableAnnotation;
        String table;
        if (entityClass == null) {
            EntityUtil.$$$reportNull$$$0(33);
        }
        String string = table = (tableAnnotation = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)entityClass, JpaEntityAnnotation.Table)) == null ? null : EntityUtil.getAttributeValue(tableAnnotation, "name", "");
        if (isTakeNameFromHierarchyRoot && (hierarchyRoot = EntityDesignHelper.getHierarchyRoot(entityPsi = EntityPsi.getInstance(entityClass))) != entityPsi && hierarchyRoot != null && EntityDesignHelper.getInheritanceType(hierarchyRoot) == Entity.InheritanceType.SINGLE_TABLE) {
            return Pair.create((Object)hierarchyRoot.getTable(), Collections.singletonList(((EntityPsi)hierarchyRoot).getPsiClass()));
        }
        if (StringUtils.isBlank((CharSequence)table)) {
            if (!EntityUtil.isPersistentEntity(entityClass)) {
                return null;
            }
            if (entityClass.hasModifierProperty("abstract") && EntityPsi.getInstance(entityClass).getInheritanceType() == Entity.InheritanceType.TABLE_PER_CLASS && !EntitySearch.getInstance(project).getChildProjectEntities(entityClass.getQualifiedName(), true).isEmpty()) {
                return null;
            }
            Entity.InheritanceType inheritanceType = EntityUtil.getInheritanceTypeFromNearestPersistentParent(entityClass);
            if (inheritanceType == null || inheritanceType == Entity.InheritanceType.JOINED || inheritanceType == Entity.InheritanceType.TABLE_PER_CLASS) {
                String entityName = EntityUtil.getInstance(project).getEntityName(entityClass);
                return Pair.create((Object)entityName, null);
            }
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)table) && (table.contains("\"") || table.contains("'") || table.contains("`"))) {
            return Pair.create((Object)StringEscapeUtils.escapeJava((String)table), null);
        }
        return Pair.create((Object)table, null);
    }

    private static Entity.InheritanceType getInheritanceTypeFromNearestPersistentParent(PsiClass entityClass) {
        EntityPsi entity = EntityPsi.getInstance(entityClass);
        Entity persistentParent = EntityDesignHelper.getPersistentParent(entity);
        if (persistentParent == null) {
            return null;
        }
        return EntityDesignHelper.getInheritanceType(persistentParent);
    }

    public static int getAllocationSize(@NotNull PsiMember member) {
        if (member == null) {
            EntityUtil.$$$reportNull$$$0(34);
        }
        return (Integer)EntityUtil.raPsiCached((PsiElement)member, () -> EntityUtil.getParameterValue(member, "allocationSize", 50, "increment_size", EntityUtil.getHibernateDefaultIncrementSize(member.getProject())));
    }

    public static int getHibernateDefaultIncrementSize(@NotNull Project project) {
        if (project == null) {
            EntityUtil.$$$reportNull$$$0(35);
        }
        if (JpaUtils.isHibernate6Project(project) && EntityUtil.isSequencePerEntityStrategy(project)) {
            return 50;
        }
        return 1;
    }

    public static boolean isSequencePerEntityStrategy(Project project) {
        if (!JpaUtils.isHibernate6Project(project)) {
            return false;
        }
        SequenceNamingStrategyEnum strategy = JpaBuddyIdeaProjectConfig.Companion.getInstance(project).getSequenceNamingStrategy();
        if (strategy == SequenceNamingStrategyEnum.SEQUENCE_PER_ENTITY) {
            return true;
        }
        if (strategy == SequenceNamingStrategyEnum.SINGLE_SEQUENCE) {
            return false;
        }
        for (PropertySource propertySource : SpringPropertiesConfiguration.getInstance(project).loadAllPropertySources()) {
            SpringProperty property = propertySource.findProperty("spring.jpa.properties.hibernate.id.db_structure_naming_strategy");
            if (property == null) continue;
            return switch (property.getValue()) {
                case "single", "legacy" -> false;
                default -> true;
            };
        }
        return true;
    }

    public static CustomTypeModel getConverter(@NotNull PsiMember member) {
        if (member == null) {
            EntityUtil.$$$reportNull$$$0(36);
        }
        return EntityAttributeCacheProvider.getInstance(member.getProject()).getConverter(member);
    }

    public static int getInitialValue(@NotNull PsiMember member) {
        if (member == null) {
            EntityUtil.$$$reportNull$$$0(37);
        }
        return (Integer)EntityUtil.raPsiCached((PsiElement)member, () -> EntityUtil.getParameterValue(member, "initialValue", 1, "initial_value", 1));
    }

    public static int getParameterValue(@NotNull PsiMember member, @NotNull String parameterName, @NotNull Integer defaultValue, String genericGeneratorParameterName, int genericGeneratorParameterDefaultValue) {
        PsiAnnotation genericGeneratorAnn;
        Long parameterValue;
        if (member == null) {
            EntityUtil.$$$reportNull$$$0(38);
        }
        if (parameterName == null) {
            EntityUtil.$$$reportNull$$$0(39);
        }
        if (defaultValue == null) {
            EntityUtil.$$$reportNull$$$0(40);
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)member);
        PsiAnnotation annotation = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.SequenceGenerator, JpaAttributeAnnotation.TableGenerator);
        Long l = parameterValue = annotation == null || EntityUtil.isSuitableGenerator(member) == false ? null : StudioAnnotationUtil.getDeclaredLongAttributeValue(annotation, parameterName);
        if (parameterValue == null && (genericGeneratorAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{"org.hibernate.annotations.GenericGenerator"})) != null) {
            Collection<PsiAnnotation> parameterAnnotations = StudioAnnotationUtil.getArrayValueAnnotations(genericGeneratorAnn, "parameters");
            Map<String, String> parametersMap = EntityUtil.getParametersMap(parameterAnnotations);
            parameterValue = NumberUtils.toLong((String)parametersMap.get(genericGeneratorParameterName), (long)genericGeneratorParameterDefaultValue);
        }
        return parameterValue == null ? defaultValue.intValue() : parameterValue.intValue();
    }

    public static String getSequenceOrTableGeneratorName(@NotNull PsiMember member) {
        if (member == null) {
            EntityUtil.$$$reportNull$$$0(41);
        }
        return (String)EntityUtil.ra(() -> {
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)member);
            String name = "";
            if (EntityUtil.isSuitableGenerator(member).booleanValue()) {
                name = StudioAnnotationUtil.getStringAttributeValue((PsiModifierListOwner)member, JpaAttributeAnnotation.SequenceGenerator.getFqn(member.getProject(), module), "sequenceName");
            }
            if (StringUtils.isEmpty((CharSequence)name)) {
                name = StudioAnnotationUtil.getStringAttributeValue((PsiModifierListOwner)member, JpaAttributeAnnotation.TableGenerator.getFqn(member.getProject(), module), "table");
            }
            if (StringUtils.isEmpty((CharSequence)name)) {
                PsiAnnotation genericGeneratorAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{"org.hibernate.annotations.GenericGenerator"});
                if (genericGeneratorAnn == null) {
                    return null;
                }
                String generatorName = AnnotationUtil.getStringAttributeValue((PsiAnnotation)genericGeneratorAnn, (String)"name");
                String generationStrategy = AnnotationUtil.getStringAttributeValue((PsiAnnotation)genericGeneratorAnn, (String)"strategy");
                if (StringUtils.isEmpty((CharSequence)generatorName) || StringUtils.isEmpty((CharSequence)generationStrategy)) {
                    return null;
                }
                Collection<PsiAnnotation> parameterAnnotations = StudioAnnotationUtil.getArrayValueAnnotations(genericGeneratorAnn, "parameters");
                if (parameterAnnotations.isEmpty()) {
                    return null;
                }
                Map<String, String> parametersMap = EntityUtil.getParametersMap(parameterAnnotations);
                name = EntityAttribute.GENERIC_GENERATOR_SEQUENCE_STRATEGIES.contains(generationStrategy) ? EntityUtil.getSequenceNameFromGenericGenerator(member, parametersMap) : null;
            }
            return name;
        });
    }

    public static Boolean isSuitableGenerator(@NotNull PsiMember member) {
        String generatorNameSeqGen;
        if (member == null) {
            EntityUtil.$$$reportNull$$$0(42);
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)member);
        String generatorNameGenVal = StudioAnnotationUtil.getStringAttributeValue((PsiModifierListOwner)member, JpaAttributeAnnotation.GeneratedValue.getFqn(member.getProject(), module), "generator");
        if (StringUtils.isNotEmpty((CharSequence)generatorNameGenVal) && generatorNameGenVal.equals(generatorNameSeqGen = StudioAnnotationUtil.getStringAttributeValue((PsiModifierListOwner)member, JpaAttributeAnnotation.SequenceGenerator.getFqn(member.getProject(), module), "name"))) {
            return true;
        }
        return false;
    }

    @Nullable
    public static String getParamName(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            EntityUtil.$$$reportNull$$$0(43);
        }
        return StudioAnnotationUtil.getStringAttributeValue(annotation, "name", null);
    }

    @Nullable
    public static String getAnnotationValue(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            EntityUtil.$$$reportNull$$$0(44);
        }
        return StudioAnnotationUtil.getStringAttributeValue(annotation, "value", null);
    }

    public static Map<String, String> getParametersMap(Collection<PsiAnnotation> parameterAnnotations) {
        HashMap<String, String> parametersMap = new HashMap<String, String>();
        if (parameterAnnotations.isEmpty()) {
            return parametersMap;
        }
        for (PsiAnnotation parameterAnnotation : parameterAnnotations) {
            String paramName = EntityUtil.getParamName(parameterAnnotation);
            String paramValue = EntityUtil.getAnnotationValue(parameterAnnotation);
            if (StringUtil.isEmpty((String)paramName) || StringUtil.isEmpty((String)paramValue)) continue;
            parametersMap.put(paramName, paramValue);
        }
        return parametersMap;
    }

    @Nullable
    public static String getSequenceNameFromGenericGenerator(@NotNull PsiMember member, Map<String, String> parametersMap) {
        String name;
        if (member == null) {
            EntityUtil.$$$reportNull$$$0(45);
        }
        if (StringUtils.isNotEmpty((CharSequence)(name = parametersMap.get("sequence_name")))) {
            return name;
        }
        if (Boolean.parseBoolean(parametersMap.get("prefer_sequence_per_entity"))) {
            PsiClass entityClass;
            PsiClass psiClass = entityClass = member instanceof PsiClass ? (PsiClass)member : member.getContainingClass();
            if (entityClass == null || StringUtils.isEmpty((CharSequence)entityClass.getName())) {
                return name;
            }
            String suffix = parametersMap.get("sequence_per_entity_suffix");
            if (StringUtils.isEmpty((CharSequence)suffix)) {
                suffix = "_SEQ";
            }
            return entityClass.getName().concat(suffix);
        }
        return name;
    }

    @Nullable
    public static String getSequenceGeneratorName(@NotNull PsiMember member) {
        if (member == null) {
            EntityUtil.$$$reportNull$$$0(46);
        }
        return (String)EntityUtil.ra(() -> StudioAnnotationUtil.getStringAttributeValue((PsiModifierListOwner)member, JpaAttributeAnnotation.SequenceGenerator.getFqn(member.getProject(), ModuleUtil.findModuleForPsiElement((PsiElement)member)), "name"));
    }

    @Nullable
    public static GenericGenerator getGenericGenerator(PsiModifierListOwner owner) {
        return (GenericGenerator)EntityUtil.raPsiCached((PsiElement)owner, () -> {
            PsiAnnotation genericGeneratorAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{"org.hibernate.annotations.GenericGenerator"});
            if (genericGeneratorAnn == null) {
                return null;
            }
            String generatorName = StudioAnnotationUtil.getStringAttributeValue(genericGeneratorAnn, "name", null);
            String generationStrategy = StudioAnnotationUtil.getStringAttributeValue(genericGeneratorAnn, "strategy", null);
            if (StringUtils.isEmpty((CharSequence)generatorName) || StringUtils.isEmpty((CharSequence)generationStrategy)) {
                return null;
            }
            Collection<PsiAnnotation> parameterAnnotations = StudioAnnotationUtil.getArrayValueAnnotations(genericGeneratorAnn, "parameters");
            Map<String, String> parametersMap = EntityUtil.getParametersMap(parameterAnnotations);
            return new GenericGenerator(generatorName, generationStrategy, parametersMap);
        });
    }

    @Nullable
    public static PsiMember getIdMember(PsiClass entityClass) {
        return EntityUtil.getEntityMemberByPredicate(entityClass, AttributeUtil::isIdField);
    }

    @Nullable
    public static PsiMember getVersionMember(PsiClass entityClass) {
        return EntityUtil.getEntityMemberByPredicate(entityClass, AttributeUtil::isVersionField);
    }

    @Nullable
    public static PsiMember getCreatedDateMember(PsiClass entityClass) {
        return EntityUtil.getEntityMemberByPredicate(entityClass, AttributeUtil::isCreatedDateField);
    }

    @Nullable
    public static PsiMember getCreatedByMember(PsiClass entityClass) {
        return EntityUtil.getEntityMemberByPredicate(entityClass, AttributeUtil::isCreatedByField);
    }

    @Nullable
    public static PsiMember getLastModifiedDateMember(PsiClass entityClass) {
        return EntityUtil.getEntityMemberByPredicate(entityClass, AttributeUtil::isLastModifiedDateField);
    }

    @Nullable
    public static PsiMember getLastModifiedByMember(PsiClass entityClass) {
        return EntityUtil.getEntityMemberByPredicate(entityClass, AttributeUtil::isLastModifiedByField);
    }

    public static PsiMember getEntityMemberByPredicate(PsiClass entityClass, Predicate<PsiMember> predicate) {
        PsiField[] fields = entityClass.getAllFields();
        PsiMethod[] methods = entityClass.getAllMethods();
        ArrayList<PsiField> members = new ArrayList<PsiField>(Arrays.asList(fields));
        members.addAll(Arrays.asList(methods));
        for (PsiMember psiMember : members) {
            if (!predicate.test(psiMember)) continue;
            return psiMember;
        }
        return null;
    }

    public static boolean isMemberHaveAttributeAnnotations(PsiMember psiMember) {
        Object[] memberAnnotations = psiMember.getAnnotations();
        if (memberAnnotations.length == 0) {
            return false;
        }
        AnnotationHelper annotationHelper = AnnotationHelper.getInstance(psiMember.getProject());
        List fqns = StreamEx.of(annotationHelper.collectAnnotations().entrySet()).map(entry -> ((Annotation)entry.getValue()).getFqn(psiMember.getProject(), ModuleUtil.findModuleForPsiElement((PsiElement)psiMember))).toList();
        return StreamEx.of((Object[])memberAnnotations).anyMatch(it -> fqns.contains(it.getQualifiedName()));
    }

    public static Map<String, String> getAttributeOverrides(PsiAnnotation attrOverridesAnnotation, boolean isAssociation) {
        HashMap<String, String> columnOverrides = new HashMap<String, String>();
        if (attrOverridesAnnotation != null) {
            Collection<PsiAnnotation> overrideAnnotations = StudioAnnotationUtil.getArrayValueAnnotations(attrOverridesAnnotation, "value");
            for (PsiAnnotation overrideAnn : overrideAnnotations) {
                AttributeOverride attributeOverride = EntityUtil.extractAttributeOverride(overrideAnn, isAssociation);
                if (attributeOverride == null) continue;
                columnOverrides.put(attributeOverride.getName(), attributeOverride.getColumn());
            }
        }
        return columnOverrides;
    }

    @Nullable
    private static AttributeOverride extractAttributeOverride(PsiAnnotation attrOver, boolean isAssociation) {
        String fieldName = AnnotationUtil.getStringAttributeValue((PsiAnnotation)attrOver, (String)"name");
        PsiAnnotationMemberValue columnValue = attrOver.findDeclaredAttributeValue(isAssociation ? "joinColumns" : "column");
        if (fieldName != null && columnValue instanceof PsiAnnotation) {
            Long scale;
            Long precision;
            Boolean nullable;
            PsiAnnotation columnAnn = (PsiAnnotation)columnValue;
            String columnName = AnnotationUtil.getStringAttributeValue((PsiAnnotation)columnAnn, (String)"name");
            AttributeOverride attributeOverride = new AttributeOverride(fieldName, columnName == null ? "" : columnName);
            Boolean unique = AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)columnAnn, (String)"unique");
            if (unique != null) {
                attributeOverride.setUnique(unique);
            }
            if ((nullable = AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)columnAnn, (String)"nullable")) != null) {
                attributeOverride.setNullable(nullable);
            }
            attributeOverride.setColumnDefinition(AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)columnAnn, (String)"columnDefinition"));
            Long length = AnnotationUtil.getLongAttributeValue((PsiAnnotation)columnAnn, (String)"length");
            if (length != null) {
                attributeOverride.setLength(length.intValue());
            }
            if ((precision = AnnotationUtil.getLongAttributeValue((PsiAnnotation)columnAnn, (String)"precision")) != null) {
                attributeOverride.setPrecision(precision.intValue());
            }
            if ((scale = AnnotationUtil.getLongAttributeValue((PsiAnnotation)columnAnn, (String)"scale")) != null) {
                attributeOverride.setScale(scale.intValue());
            }
            return attributeOverride;
        }
        return null;
    }

    public static List<PsiField> filterActualFields(PsiField[] fields) {
        ArrayList<PsiField> result = new ArrayList<PsiField>();
        EntityUtil.ra(() -> {
            for (PsiField field : fields) {
                if (!EntityUtil.isActualEntityField(field)) continue;
                result.add(field);
            }
        });
        return result;
    }

    public static List<Index> getUniqueConstraints(PsiAnnotation annotation) {
        return new ArrayList<Index>(EntityUtil.getUniqueConstraintsMap(annotation).keySet());
    }

    public static Index getUniqueConstraint(PsiAnnotation annotation) {
        LinkedHashMap<Index, PsiAnnotation> constraints = new LinkedHashMap<Index, PsiAnnotation>();
        EntityUtil.collectUniqueIndexes(constraints, annotation);
        return constraints.isEmpty() ? null : (Index)constraints.keySet().stream().findFirst().orElse(null);
    }

    public static Map<Index, PsiAnnotation> getUniqueConstraintsMap(PsiAnnotation annotation) {
        LinkedHashMap<Index, PsiAnnotation> constraints = new LinkedHashMap<Index, PsiAnnotation>();
        Collection<PsiAnnotation> constraintAnnotations = StudioAnnotationUtil.getArrayValueAnnotations(annotation, "uniqueConstraints");
        for (PsiAnnotation constraintAnn : constraintAnnotations) {
            EntityUtil.collectUniqueIndexes(constraints, constraintAnn);
        }
        return constraints;
    }

    public static void collectUniqueIndexes(Map<Index, PsiAnnotation> constraints, PsiAnnotation anntMemberValue) {
        String idxName = AnnotationUtil.getStringAttributeValue((PsiAnnotation)anntMemberValue, (String)"name");
        LinkedHashSet<String> attrs = new LinkedHashSet<String>();
        PsiAnnotationMemberValue columnNames = anntMemberValue.findAttributeValue("columnNames");
        if (columnNames instanceof PsiArrayInitializerMemberValue) {
            for (PsiAnnotationMemberValue columnListValue : ((PsiArrayInitializerMemberValue)columnNames).getInitializers()) {
                EntityUtil.collectUniqueColumnName(attrs, columnListValue);
            }
        } else if (columnNames != null) {
            EntityUtil.collectUniqueColumnName(attrs, columnNames);
        }
        if (!attrs.isEmpty()) {
            constraints.put(new Index(idxName, attrs, true, true), anntMemberValue);
        }
    }

    private static void collectUniqueColumnName(LinkedHashSet<String> attrs, PsiAnnotationMemberValue annotationMemberValue) {
        if (annotationMemberValue instanceof PsiLiteralExpression) {
            attrs.add(String.valueOf(((PsiLiteralExpression)annotationMemberValue).getValue()));
        } else {
            attrs.add(String.valueOf(annotationMemberValue.getText()));
        }
    }

    public static LinkedHashSet<AttributeOverride> getAttributeOverrides(PsiModifierListOwner listOwner, boolean isAssociation) {
        Project project = listOwner.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)listOwner);
        String singleAnnFqn = isAssociation ? JpaAttributeAnnotation.AssociationOverride.getFqn(project, module) : JpaAttributeAnnotation.AttributeOverride.getFqn(project, module);
        String collectionAnnFqn = isAssociation ? JpaAttributeAnnotation.AssociationOverrides.getFqn(project, module) : JpaAttributeAnnotation.AttributeOverrides.getFqn(project, module);
        ArrayList<PsiAnnotation> attrOverrideAnnotations = new ArrayList<PsiAnnotation>(AnnotationUtil.findAllAnnotations((PsiModifierListOwner)listOwner, Collections.singletonList(singleAnnFqn), (boolean)false));
        PsiAnnotation attrOverridesAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)listOwner, (String[])new String[]{collectionAnnFqn});
        if (attrOverridesAnn != null) {
            attrOverrideAnnotations.addAll(StudioAnnotationUtil.getArrayValueAnnotations(attrOverridesAnn, "value"));
        }
        LinkedHashSet<AttributeOverride> columnOverrides = new LinkedHashSet<AttributeOverride>();
        for (PsiAnnotation overrideAnn : attrOverrideAnnotations) {
            AttributeOverride attributeOverride = EntityUtil.extractAttributeOverride(overrideAnn, isAssociation);
            if (attributeOverride == null) continue;
            columnOverrides.add(attributeOverride);
        }
        return columnOverrides;
    }

    public static List<NamedQuery> getNamedQueries(PsiClass entityClass) {
        Project project = entityClass.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)entityClass);
        ArrayList<PsiAnnotation> namedQueryAnnotations = new ArrayList<PsiAnnotation>(AnnotationUtil.findAllAnnotations((PsiModifierListOwner)entityClass, Collections.singletonList(JpaEntityAnnotation.NamedQuery.getFqn(project, module)), (boolean)false));
        PsiAnnotation namedQueriesAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)entityClass, (String[])new String[]{JpaEntityAnnotation.NamedQueries.getFqn(project, module)});
        if (namedQueriesAnn != null) {
            namedQueryAnnotations.addAll(StudioAnnotationUtil.getArrayValueAnnotations(namedQueriesAnn, "value"));
        }
        ArrayList<NamedQuery> result = new ArrayList<NamedQuery>();
        for (PsiAnnotation namedQueryAnn : namedQueryAnnotations) {
            NamedQuery namedQuery = EntityUtil.convertAnnotationToNamedQuery(namedQueryAnn);
            if (namedQuery == null) continue;
            result.add(namedQuery);
        }
        return result;
    }

    @Nullable
    public static NamedQuery convertAnnotationToNamedQuery(PsiAnnotation namedQueryAnn) {
        try {
            String name = AnnotationUtil.getStringAttributeValue((PsiAnnotation)namedQueryAnn, (String)"name");
            PsiAnnotationMemberValue queryAnn = namedQueryAnn.findAttributeValue("query");
            if (StringUtil.isNotEmpty((String)name) && queryAnn != null) {
                String lockModeValue = StudioAnnotationUtil.getDeclaredEnumStringValue(namedQueryAnn, "lockMode");
                LockModeType lockModeType = lockModeValue == null ? LockModeType.NONE : (LockModeType)StringUtil.parseEnum((String)lockModeValue, (Enum)LockModeType.NONE, LockModeType.class);
                return new NamedQuery(name, StudioAnnotationUtil.extractStringFromAnnotationAttrValue(queryAnn), lockModeType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static List<Index> getIndexes(PsiAnnotation annotation) {
        return new ArrayList<Index>(EntityUtil.getIndexesMap(annotation).keySet());
    }

    public static Map<Index, PsiAnnotation> getIndexesMap(PsiAnnotation annotation) {
        LinkedHashMap<Index, PsiAnnotation> indexes = new LinkedHashMap<Index, PsiAnnotation>();
        Collection<PsiAnnotation> indexAnnotations = StudioAnnotationUtil.getArrayValueAnnotations(annotation, "indexes");
        for (PsiAnnotation indexAnnotation : indexAnnotations) {
            EntityUtil.collectIndexes(indexes, indexAnnotation);
        }
        return indexes;
    }

    @Nullable
    public static Index getIndex(PsiAnnotation indexAnnotation) {
        LinkedHashMap<Index, PsiAnnotation> indexes = new LinkedHashMap<Index, PsiAnnotation>();
        EntityUtil.collectIndexes(indexes, indexAnnotation);
        if (indexes.isEmpty()) {
            return null;
        }
        return (Index)indexes.keySet().iterator().next();
    }

    public static String getComment(PsiModifierListOwner psiElement) {
        return (String)EntityUtil.raPsiCached((PsiElement)psiElement, () -> StudioAnnotationUtil.getStringAttributeValue(psiElement, "org.hibernate.annotations.Comment", "value"));
    }

    private static void collectIndexes(Map<Index, PsiAnnotation> indexes, PsiAnnotation anntMemberValue) {
        String name = AnnotationUtil.getStringAttributeValue((PsiAnnotation)anntMemberValue, (String)"name");
        String columnList = AnnotationUtil.getStringAttributeValue((PsiAnnotation)anntMemberValue, (String)"columnList");
        if (StringUtils.isNotBlank((CharSequence)columnList)) {
            LinkedHashSet attrs = Arrays.stream(StringUtils.split((String)columnList, (String)",")).map(StringUtils::trim).collect(Collectors.toCollection(LinkedHashSet::new));
            Boolean unique = AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)anntMemberValue, (String)"unique");
            indexes.put(new Index(name, attrs, unique != null && unique != false, false), anntMemberValue);
        }
    }

    @Nullable
    private static HibernateCustomTypeModel collectTypes(PsiAnnotation anntMemberValue) {
        String fqn = StudioAnnotationUtil.getDeclaredReferenceFqnStringValue(anntMemberValue, "typeClass");
        String name = AnnotationUtil.getStringAttributeValue((PsiAnnotation)anntMemberValue, (String)"name");
        String defaultForType = StudioAnnotationUtil.getDeclaredReferenceFqnStringValue(anntMemberValue, "defaultForType");
        if (StringUtils.isNotBlank((CharSequence)fqn)) {
            HibernateCustomTypeModel customTypeModel = HibernateCustomTypeService.getInstance(anntMemberValue.getProject()).getCustomTypeByFqn(fqn);
            if (customTypeModel != null) {
                customTypeModel.setName(name);
                customTypeModel.setDefaultForType(defaultForType != null);
            }
            return customTypeModel;
        }
        return null;
    }

    public static boolean isContainEntity(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            EntityUtil.$$$reportNull$$$0(47);
        }
        return psiFile instanceof PsiClassOwner && ContainerUtil.or((Object[])((PsiClassOwner)psiFile).getClasses(), EntityUtil::isEntity);
    }

    @Contract(value="null -> null")
    @Nullable
    public static EntityPsi getFirstEntity(@Nullable PsiFile psiFile) {
        if (!(psiFile instanceof PsiClassOwner)) {
            return null;
        }
        return StreamEx.of((Object[])((PsiClassOwner)psiFile).getClasses()).findFirst(EntityUtil::isEntity).map(EntityPsi::getInstance).orElse(null);
    }

    public static String getPackageName(PsiClass psiClass) {
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName == null) {
            return "";
        }
        return ClassUtil.extractPackageName((String)qualifiedName);
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiClass getEntityClass(@Nullable PsiFile file) {
        return EntityUtil.getEntityClass(file, true);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static PsiClass getEntityClass(@Nullable PsiFile file, Boolean checkIsEntity) {
        if (!(file instanceof PsiClassOwner) || ((PsiClassOwner)file).getClasses().length == 0) {
            return null;
        }
        PsiClass[] classes = ((PsiClassOwner)file.getNavigationElement()).getClasses();
        if (classes.length == 0) {
            return null;
        }
        PsiClass psiClass = classes[0];
        return checkIsEntity.booleanValue() ? (EntityUtil.isEntity(psiClass) ? psiClass : null) : psiClass;
    }

    public static PsiClass getPsiClass(String classFqn, Project project) {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        return javaPsiFacade.findClass(classFqn, GlobalSearchScope.allScope((Project)project));
    }

    public static PsiClass getPsiClass(Entity entity, Project project) {
        if (entity instanceof EntityPsi) {
            return ((EntityPsi)entity).getPsiClass();
        }
        return EntityUtil.getPsiClass(entity.getFqn(), project);
    }

    public static String getPluralFormEntityName(String entityName, EntityAttribute.Cardinality cardinality) {
        String invName = StringUtil.decapitalize((String)entityName);
        if (cardinality != null && cardinality.isMany()) {
            invName = StringUtil.pluralize((String)invName);
        }
        return invName;
    }

    public static void makeAttributeOwner(EntityAttributeModel attributeModel, EntityAttribute relatedAttribute, Entity entity, Project project) {
        attributeModel.setOwner(true);
        EntityPsi type = (EntityPsi)attributeModel.getType();
        EntityAttribute idAttribute = type.getIdAttributeOrNull();
        EntityAttribute.Cardinality cardinality = attributeModel.getCardinality();
        if (idAttribute != null && idAttribute.isEmbedded()) {
            attributeModel.setJoinColumns(EntityUtil.generateJoinColumns(attributeModel, type));
        } else if (cardinality == EntityAttribute.Cardinality.MANY_TO_MANY) {
            attributeModel.setJoinTable(new JoinTable());
            EntityUtil.fillJoinTable(attributeModel, relatedAttribute, entity, project);
        } else if (cardinality == EntityAttribute.Cardinality.ONE_TO_ONE) {
            EntityUtil.fillJoinColumn(attributeModel, relatedAttribute, entity, project);
        }
        attributeModel.setMappedBy(null);
    }

    public static LinkedHashMap<String, String> generateJoinColumns(EntityAttribute attr, Entity attrType) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (attrType.getCompKeyType() == null) {
            return result;
        }
        String attrName = JpaUtils.toUnderscore(attr.getName());
        attrType.getCompKeyType().getAttributes().stream().filter(it -> !it.isTransient() && StringUtils.isNotBlank((CharSequence)it.getColumn())).forEach(it -> {
            String embColumn = it.getColumn().toUpperCase();
            result.put(attrName + "_" + embColumn, embColumn);
        });
        return result;
    }

    public static void fillJoinTable(EntityAttributeModel attribute, EntityAttribute relatedAttribute, Entity entity, Project project) {
        if (relatedAttribute != null && relatedAttribute.isOwner() && relatedAttribute.getJoinTable() != JoinTable.NULL_ANNOTATION) {
            JoinTable relatedJoinTable = relatedAttribute.getJoinTable();
            JoinTable joinTable = new JoinTable(relatedJoinTable.getName(), relatedJoinTable.getInverseJoinColumns(), relatedJoinTable.getJoinColumns());
            attribute.setJoinTable(joinTable);
        } else {
            Entity relatedEntity = (Entity)attribute.getType();
            EntityDesignHelper entityDesignHelper = EntityDesignHelper.getInstance(project);
            String joinTableName = entityDesignHelper.generateJoinTableName(entity.getTable(), attribute.getName());
            boolean isItselfRef = Objects.equals(entity.getFqn(), relatedEntity.getFqn());
            JoinColumn joinColumn = new JoinColumn(entityDesignHelper.generateJoinColumnName(entity, isItselfRef ? "_1" : ""), entityDesignHelper.generateInverseJoinColumnName(attribute, isItselfRef ? "_2" : ""));
            JoinTable joinTable = new JoinTable(joinTableName);
            joinTable.getJoinColumns().add(joinColumn);
            attribute.setJoinTable(joinTable);
        }
    }

    public static void fillJoinColumn(EntityAttributeModel attribute, EntityAttribute relatedAttribute, Entity entity, Project project) {
        boolean isEmbedded;
        EntityAttribute idAttribute = entity.getIdAttributeOrNull();
        boolean bl = isEmbedded = idAttribute != null && idAttribute.isEmbedded();
        if (relatedAttribute != null && relatedAttribute.isOwner() && !relatedAttribute.getJoinColumns().isEmpty() && !isEmbedded) {
            LinkedHashMap<String, String> joinColumns = relatedAttribute.getJoinColumns();
            attribute.setJoinColumns(joinColumns);
        } else {
            Entity relatedEntity = (Entity)attribute.getType();
            boolean isItselfRef = Objects.equals(entity.getFqn(), relatedEntity.getFqn());
            attribute.setColumnPhysical(EntityDesignHelper.getInstance(project).generateJoinColumnName(entity, isItselfRef ? "_1" : ""));
        }
    }

    public static Boolean isIdAttrWithSequenceOrAutoStrategy(EntityAttribute attribute, Project project) {
        return attribute.isId() && (attribute.getGeneratedStrategy() == EntityAttribute.GeneratedStrategy.SEQUENCE || attribute.getGeneratedStrategy() == EntityAttribute.GeneratedStrategy.AUTO && JpaUtils.isHibernateProject(project));
    }

    public static Map<String, String> getNamedEntityGraphs(PsiClass entityClass) {
        Project project = entityClass.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)entityClass);
        ArrayList<PsiAnnotation> namedEntityGraphAnnotations = new ArrayList<PsiAnnotation>(AnnotationUtil.findAllAnnotations((PsiModifierListOwner)entityClass, Collections.singletonList(JpaEntityAnnotation.NamedEntityGraph.getFqn(project, module)), (boolean)false));
        PsiAnnotation namedEntityGraphsAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)entityClass, (String[])new String[]{JpaEntityAnnotation.NamedEntityGraphs.getFqn(project, module)});
        if (namedEntityGraphsAnn != null) {
            namedEntityGraphAnnotations.addAll(StudioAnnotationUtil.getArrayValueAnnotations(namedEntityGraphsAnn, "value"));
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((Project)project);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        PsiFile tempFile = PsiFileFactory.getInstance((Project)project).createFileFromText("temp.java", (FileType)JavaFileType.INSTANCE, (CharSequence)"");
        for (PsiAnnotation annotation : namedEntityGraphAnnotations) {
            String name = AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, (String)"name");
            if (!StringUtil.isNotEmpty((String)name)) continue;
            String annotationText = annotation.getText();
            if (annotation.getLanguage() == JavaLanguage.INSTANCE) {
                PsiElement tempAnn = tempFile.add((PsiElement)annotation);
                CodeStyle.runWithLocalSettings((Project)project, (CodeStyleSettings)codeStyleSettings, () -> codeStyleManager.reformat((PsiElement)tempFile));
                result.put(name, tempAnn.getText());
                tempAnn.delete();
                continue;
            }
            result.put(name, annotationText);
        }
        return result;
    }

    public static void makeUniqueAttrNames(Entity entity, List<EntityAttributeModel> attributes) {
        Set<String> allAttrNames = entity.getAllAttributes().stream().map(EntityAttribute::getName).collect(Collectors.toSet());
        for (EntityAttributeModel attribute : attributes) {
            String attrName = attribute.getName();
            if (allAttrNames.add(attrName)) continue;
            attribute.setName(EntityUtil.makeUniqueAttrName(attrName, 1, allAttrNames));
        }
    }

    private static String makeUniqueAttrName(String name, Integer idx, Set<String> allAttrNames) {
        String newName = name + idx;
        if (allAttrNames.add(newName)) {
            return newName;
        }
        return EntityUtil.makeUniqueAttrName(name, idx + 1, allAttrNames);
    }

    public static String getRevisionNumberType(Project project, TemplateHelper templateHelper) {
        EntityAttribute entityAttribute;
        Optional<EntityAttribute> revisionNumberAttribute;
        PsiClass projectRevisionEntity;
        String revisionNumberType = Datatypes.BasicDatatype.Integer.getFqn();
        Query<PsiClass> projectRevisionEntities = JpaAnnotationHelper.Companion.findAnnotatedClasses("org.hibernate.envers.RevisionEntity", GlobalSearchScope.projectScope((Project)project), project);
        PsiClass psiClass = projectRevisionEntity = projectRevisionEntities != null ? (PsiClass)projectRevisionEntities.findFirst() : null;
        if (!(projectRevisionEntity == null || !(revisionNumberAttribute = EntityPsi.getInstance(projectRevisionEntity).getAllAttributes().stream().filter(it -> it instanceof EntityAttributePsi && ((EntityAttributePsi)it).getMember().hasAnnotation("org.hibernate.envers.RevisionNumber")).findFirst()).isPresent() || (entityAttribute = revisionNumberAttribute.get()).getType() instanceof Datatypes.BasicDatatype && ((Datatypes.BasicDatatype)entityAttribute.getType()).isPrimitive())) {
            revisionNumberType = entityAttribute.getType().getFqn();
        }
        return templateHelper.convertType(revisionNumberType, project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 29, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 4: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/util/EntityUtil";
                break;
            }
            case 9: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClasses";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_class";
                break;
            }
            case 15: 
            case 16: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 23: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityClass";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerClass";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/util/EntityUtil";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNameByGetter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntityName";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyForName";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyForClassWithId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCollectionType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generateDefaultColumnName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 29: 
            case 31: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasOneOfAnnotationsLight";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasOneOfAnnotations";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isEnum";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isEnum_";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isEntity_";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getActualProperty";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getActualProperty_";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isActualEntityField";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isActualEntityField_";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isActualEntityMethod";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "suggestGetterName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isPersistentEntity";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isPersistentEntity_";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "registerEntity";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "raPsiCached";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getKeyForClass";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getKeyForName";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getKeyForClassWithId";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getTable";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getTableWithDepends";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getAllocationSize";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getHibernateDefaultIncrementSize";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getConverter";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getInitialValue";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getParameterValue";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getSequenceOrTableGeneratorName";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableGenerator";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getParamName";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationValue";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getSequenceNameFromGenericGenerator";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getSequenceGeneratorName";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isContainEntity";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 29, 31 -> new IllegalStateException(string);
        };
    }

    public static class ResultWithDependenciesWrapper<T> {
        private T result;
        private List<Object> dependencies;

        public ResultWithDependenciesWrapper(T result, List<Object> dependencies) {
            this.result = result;
            this.dependencies = dependencies;
        }

        public T getResult() {
            return this.result;
        }

        public void setResult(T result) {
            this.result = result;
        }

        public List<Object> getDependencies() {
            return this.dependencies;
        }

        public void setDependencies(List<Object> dependencies) {
            this.dependencies = dependencies;
        }
    }
}

