/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.configurations.yaml.reference.provider.value.reference.env;

import com.intellij.ktor.configurations.meta.key.reference.value.env.EnvVariable;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0003H\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ktor/configurations/yaml/reference/provider/value/reference/env/YamlEnvVariable;", "Lcom/intellij/ktor/configurations/meta/key/reference/value/env/EnvVariable;", "fullText", "", "fullTextRange", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;)V", "getFullTextRange", "()Lcom/intellij/openapi/util/TextRange;", "property", "getProperty", "()Ljava/lang/String;", "propertyRange", "getPropertyRange", "getPropertyText", "getStartOffset", "", "getEndOffset", "intellij.ktor"})
final class YamlEnvVariable
extends EnvVariable {
    @NotNull
    private final String fullText;
    @NotNull
    private final TextRange fullTextRange;
    @NotNull
    private final String property;
    @NotNull
    private final TextRange propertyRange;

    public YamlEnvVariable(@NotNull String fullText, @NotNull TextRange fullTextRange) {
        Intrinsics.checkNotNullParameter((Object)fullText, (String)"fullText");
        Intrinsics.checkNotNullParameter((Object)fullTextRange, (String)"fullTextRange");
        this.fullText = fullText;
        this.fullTextRange = fullTextRange;
        this.property = this.getPropertyText();
        this.propertyRange = new TextRange(this.getFullTextRange().getStartOffset() + this.getStartOffset(), this.getFullTextRange().getEndOffset() - this.getEndOffset());
    }

    @Override
    @NotNull
    public TextRange getFullTextRange() {
        return this.fullTextRange;
    }

    @Override
    @NotNull
    public String getProperty() {
        return this.property;
    }

    @Override
    @NotNull
    public TextRange getPropertyRange() {
        return this.propertyRange;
    }

    private final String getPropertyText() {
        int startOffset = this.getStartOffset();
        int endOffset = this.getEndOffset();
        String string = this.fullText.substring(startOffset, this.fullText.length() - endOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private final int getStartOffset() {
        boolean hasLeftBracket = StringsKt.startsWith$default((String)this.fullText, (String)"${", (boolean)false, (int)2, null);
        return hasLeftBracket ? 2 : 1;
    }

    private final int getEndOffset() {
        boolean hasRightBracket = StringsKt.endsWith$default((CharSequence)this.fullText, (char)'}', (boolean)false, (int)2, null);
        return hasRightBracket ? 1 : 0;
    }
}

