/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.run.dashboard;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.dashboard.RunDashboardCustomizationBuilder;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.BrowserUtil;
import com.intellij.ktor.run.KtorRunConfiguration;
import com.intellij.ktor.run.task.state.KtorServerConfiguration;
import com.intellij.ktor.run.task.state.KtorServerConfigurationKt;
import com.intellij.ui.SimpleTextAttributes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\"\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ktor/run/dashboard/KtorRunDashboardCustomizer;", "Lcom/intellij/execution/dashboard/RunDashboardCustomizer;", "<init>", "()V", "isApplicable", "", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "descriptor", "Lcom/intellij/execution/ui/RunContentDescriptor;", "updatePresentation", "customizationBuilder", "Lcom/intellij/execution/dashboard/RunDashboardCustomizationBuilder;", "configurationSettings", "ApplicationLinkListener", "intellij.ktor"})
public final class KtorRunDashboardCustomizer
extends RunDashboardCustomizer {
    public boolean isApplicable(@NotNull RunnerAndConfigurationSettings settings, @Nullable RunContentDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return settings.getConfiguration() instanceof KtorRunConfiguration;
    }

    public boolean updatePresentation(@NotNull RunDashboardCustomizationBuilder customizationBuilder, @NotNull RunnerAndConfigurationSettings configurationSettings, @Nullable RunContentDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)customizationBuilder, (String)"customizationBuilder");
        Intrinsics.checkNotNullParameter((Object)configurationSettings, (String)"configurationSettings");
        if (!(configurationSettings.getConfiguration() instanceof KtorRunConfiguration)) {
            return false;
        }
        RunContentDescriptor runContentDescriptor = descriptor;
        if (runContentDescriptor == null || (runContentDescriptor = runContentDescriptor.getProcessHandler()) == null) {
            return true;
        }
        RunContentDescriptor handler = runContentDescriptor;
        if (!handler.isProcessTerminated()) {
            KtorServerConfiguration ktorServerConfiguration = (KtorServerConfiguration)handler.getUserData(KtorServerConfigurationKt.getSERVER_CONFIGURATION_KEY());
            if (ktorServerConfiguration == null) {
                return true;
            }
            KtorServerConfiguration serverConfiguration2 = ktorServerConfiguration;
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
            customizationBuilder.addText(" ", simpleTextAttributes);
            String applicationLink = ":" + serverConfiguration2.getServerPort();
            SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"REGULAR_ATTRIBUTES");
            customizationBuilder.addText(applicationLink, simpleTextAttributes2);
            customizationBuilder.addLink(applicationLink, (Runnable)new ApplicationLinkListener(serverConfiguration2));
        }
        return true;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\t\u0010\b\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0083\u0004J\n\u0010\u000e\u001a\u00020\u000fH\u00d6\u0081\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ktor/run/dashboard/KtorRunDashboardCustomizer$ApplicationLinkListener;", "Ljava/lang/Runnable;", "serverConfiguration", "Lcom/intellij/ktor/run/task/state/KtorServerConfiguration;", "<init>", "(Lcom/intellij/ktor/run/task/state/KtorServerConfiguration;)V", "run", "", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.ktor"})
    private static final class ApplicationLinkListener
    implements Runnable {
        @NotNull
        private final KtorServerConfiguration serverConfiguration;

        public ApplicationLinkListener(@NotNull KtorServerConfiguration serverConfiguration2) {
            Intrinsics.checkNotNullParameter((Object)serverConfiguration2, (String)"serverConfiguration");
            this.serverConfiguration = serverConfiguration2;
        }

        @Override
        public void run() {
            BrowserUtil.browse((String)this.serverConfiguration.getApplicationUrl());
        }

        private final KtorServerConfiguration component1() {
            return this.serverConfiguration;
        }

        @NotNull
        public final ApplicationLinkListener copy(@NotNull KtorServerConfiguration serverConfiguration2) {
            Intrinsics.checkNotNullParameter((Object)serverConfiguration2, (String)"serverConfiguration");
            return new ApplicationLinkListener(serverConfiguration2);
        }

        public static /* synthetic */ ApplicationLinkListener copy$default(ApplicationLinkListener applicationLinkListener, KtorServerConfiguration ktorServerConfiguration, int n, Object object) {
            if ((n & 1) != 0) {
                ktorServerConfiguration = applicationLinkListener.serverConfiguration;
            }
            return applicationLinkListener.copy(ktorServerConfiguration);
        }

        @NotNull
        public String toString() {
            return "ApplicationLinkListener(serverConfiguration=" + this.serverConfiguration + ")";
        }

        public int hashCode() {
            return this.serverConfiguration.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ApplicationLinkListener)) {
                return false;
            }
            ApplicationLinkListener applicationLinkListener = (ApplicationLinkListener)other;
            return Intrinsics.areEqual((Object)this.serverConfiguration, (Object)applicationLinkListener.serverConfiguration);
        }
    }
}

