/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.navbar.frontend.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.platform.navbar.frontend.ui.NavBarItemComponent;
import com.intellij.platform.navbar.frontend.ui.NewNavBarPanel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/navbar/frontend/ui/NavBarDialogFocusListener;", "Ljava/awt/event/FocusListener;", "panel", "Lcom/intellij/platform/navbar/frontend/ui/NewNavBarPanel;", "<init>", "(Lcom/intellij/platform/navbar/frontend/ui/NewNavBarPanel;)V", "shouldFocusEditor", "", "focusGained", "", "e", "Ljava/awt/event/FocusEvent;", "focusLost", "intellij.platform.navbar.frontend"})
public final class NavBarDialogFocusListener
implements FocusListener {
    @NotNull
    private final NewNavBarPanel panel;
    private boolean shouldFocusEditor;

    public NavBarDialogFocusListener(@NotNull NewNavBarPanel panel) {
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        this.panel = panel;
    }

    @Override
    public void focusGained(@NotNull FocusEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (NavBarItemComponent.Companion.isItemComponentFocusable$intellij_platform_navbar_frontend() && UIUtil.isAncestor((Component)this.panel, (Component)e.getOppositeComponent())) {
            return;
        }
        if (e.getOppositeComponent() == null && this.shouldFocusEditor) {
            this.shouldFocusEditor = false;
            ToolWindowManager.Companion.getInstance(this.panel.getProject()).activateEditorComponent();
            return;
        }
    }

    @Override
    public void focusLost(@NotNull FocusEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (NavBarItemComponent.Companion.isItemComponentFocusable$intellij_platform_navbar_frontend() && UIUtil.isAncestor((Component)this.panel, (Component)e.getOppositeComponent())) {
            return;
        }
        DialogWrapper dialog = DialogWrapper.findInstance((Component)e.getOppositeComponent());
        if (dialog != null) {
            if (dialog.isDisposed()) {
                this.shouldFocusEditor = dialog.getExitCode() != 1;
            } else {
                this.shouldFocusEditor = true;
                Disposer.register((Disposable)dialog.getDisposable(), () -> NavBarDialogFocusListener.focusLost$lambda$0(dialog, this));
            }
        }
    }

    private static final void focusLost$lambda$0(DialogWrapper $dialog, NavBarDialogFocusListener this$0) {
        if ($dialog.getExitCode() == 1) {
            this$0.shouldFocusEditor = false;
        }
    }
}

