/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.com.github.weisj.jsvg.geometry;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.MeasurableShape;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.SVGCircle;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.SVGEllipse;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.size.Length;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.size.MeasureContext;
import org.jetbrains.relocated.com.github.weisj.jsvg.renderer.RenderContext;

public final class SVGRoundRectangle
implements MeasurableShape {
    @NotNull
    private final RoundRectangle2D.Float rect = new RoundRectangle2D.Float();
    @NotNull
    private final Length x;
    @NotNull
    private final Length y;
    @NotNull
    private final Length w;
    @NotNull
    private final Length h;
    @NotNull
    private final Length rx;
    @NotNull
    private final Length ry;

    public SVGRoundRectangle(@NotNull Length x2, @NotNull Length y2, @NotNull Length w, @NotNull Length h, @NotNull Length rx, @NotNull Length ry) {
        this.x = x2;
        this.y = y2;
        this.w = w;
        this.h = h;
        this.rx = rx;
        this.ry = ry;
    }

    private void validateShape(@NotNull MeasureContext measureContext) {
        this.rect.setRoundRect(this.x.resolveWidth(measureContext), this.y.resolveHeight(measureContext), this.w.resolveWidth(measureContext), this.h.resolveHeight(measureContext), this.rx.resolveWidth(measureContext) * 2.0f, this.ry.resolveHeight(measureContext) * 2.0f);
    }

    @Override
    @NotNull
    public Shape shape(@NotNull RenderContext context, boolean validate) {
        if (validate) {
            this.validateShape(context.measureContext());
        }
        return this.rect;
    }

    @Override
    @NotNull
    public Rectangle2D bounds(@NotNull RenderContext context, boolean validate) {
        if (validate) {
            this.validateShape(context.measureContext());
        }
        return this.rect.getBounds2D();
    }

    @Override
    public double pathLength(@NotNull MeasureContext measureContext) {
        float a2 = this.rx.resolveWidth(measureContext);
        float b2 = this.ry.resolveHeight(measureContext);
        double l = 2.0f * (this.w.resolveWidth(measureContext) - 2.0f * a2 + (this.h.resolveHeight(measureContext) - 2.0f * b2));
        if (a2 == b2) {
            return l + SVGCircle.circumference(a2);
        }
        return l + SVGEllipse.ellipseCircumference(a2, b2);
    }
}

