/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.com.github.weisj.jsvg.geometry.path;

import java.awt.geom.Point2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.mesh.Bezier;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.path.BezierPathCommand;

final class CubicBezierCommand
implements BezierPathCommand {
    private final boolean relative;
    private final float bx;
    private final float by;
    private final float cx;
    private final float cy;
    private final float dx;
    private final float dy;

    public CubicBezierCommand(boolean relative, float bx, float by, float cx, float cy, float dx, float dy) {
        this.relative = relative;
        this.bx = bx;
        this.by = by;
        this.cx = cx;
        this.cy = cy;
        this.dx = dx;
        this.dy = dy;
    }

    @Override
    @NotNull
    public Bezier createBezier(@NotNull Point2D.Float start2) {
        if (this.relative) {
            return new Bezier(start2, new Point2D.Float(start2.x + this.bx, start2.y + this.by), new Point2D.Float(start2.x + this.cx, start2.y + this.cy), new Point2D.Float(start2.x + this.dx, start2.y + this.dy));
        }
        return new Bezier(start2, new Point2D.Float(this.bx, this.by), new Point2D.Float(this.cx, this.cy), new Point2D.Float(this.dx, this.dy));
    }

    public String toString() {
        return "CubicBezierCommand{relative=" + this.relative + ", bx=" + this.bx + ", by=" + this.by + ", cx=" + this.cx + ", cy=" + this.cy + ", dx=" + this.dx + ", dy=" + this.dy + '}';
    }
}

