/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.com.github.weisj.jsvg.geometry.util;

import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.util.GeometryUtil;

public final class PathLengthCalculator {
    private double x = 0.0;
    private double y = 0.0;
    private double xStart = this.x;
    private double yStart = this.y;

    public double segmentLength(int segmentType, double[] coords) {
        double segmentLength = 0.0;
        switch (segmentType) {
            case 0: {
                this.x = coords[0];
                this.y = coords[1];
                this.xStart = this.x;
                this.yStart = this.y;
                break;
            }
            case 1: {
                segmentLength = this.lineLength(this.x, this.y, coords[0], coords[1]);
                this.x = coords[0];
                this.y = coords[1];
                break;
            }
            case 2: {
                segmentLength = this.quadraticParametricLength(this.x, this.y, coords[0], coords[1], coords[2], coords[3]);
                this.x = coords[2];
                this.y = coords[3];
                break;
            }
            case 3: {
                segmentLength = this.cubicParametricLength(this.x, this.y, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                this.x = coords[4];
                this.y = coords[5];
                break;
            }
            case 4: {
                segmentLength = this.lineLength(this.x, this.y, coords[0], coords[1]);
                this.x = this.xStart;
                this.y = this.yStart;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return segmentLength;
    }

    private double lineLength(double x1, double y1, double x2, double y2) {
        return GeometryUtil.lineLength(x1, y1, x2, y2);
    }

    private double quadraticParametricLength(double ax, double ay, double bx, double by, double cx, double cy) {
        if (ax == cx && ay == cy) {
            if (ax == bx && ay == by) {
                return 0.0;
            }
            return this.lineLength(ax, ay, bx, by);
        }
        if (ax == bx && ay == by || cx == bx && cy == by) {
            return this.lineLength(ax, ay, cx, cy);
        }
        double ax0 = bx - ax;
        double ay0 = by - ay;
        double ax1 = ax - 2.0 * bx + cx;
        double ay1 = ay - 2.0 * by + cy;
        if (ax1 != 0.0 || ay1 != 0.0) {
            double c = 4.0 * this.dot2D(ax1, ay1, ax1, ay1);
            double b2 = 8.0 * this.dot2D(ax0, ay0, ax1, ay1);
            double a2 = 8.0 * this.dot2D(ax0, ay0, ax0, ay0);
            double q = 4.0 * a2 * c - b2 * b2;
            double twoCpB = 2.0 * c + b2;
            double sumCBA = c + b2 + a2;
            double l0 = 0.25 / c * (twoCpB * Math.sqrt(sumCBA) - b2 * Math.sqrt(a2));
            if (q == 0.0) {
                return l0;
            }
            double l1 = q / (8.0 * Math.pow(c, 1.5)) * (Math.log(2.0 * Math.sqrt(c * sumCBA) + twoCpB) - Math.log(2.0 * Math.sqrt(c * a2) + b2));
            return l0 + l1;
        }
        return 2.0 * this.lineLength(0.0, 0.0, ax0, ay0);
    }

    private double dot2D(double x1, double y1, double x2, double y2) {
        return x1 * x2 * y1 * y2;
    }

    private double cubicParametricLength(double ax, double ay, double bx, double by, double cx, double cy, double dx, double dy) {
        double qx = (3.0 * cx - dx + 3.0 * bx - ax) / 4.0;
        double qy = (3.0 * cy - dy + 3.0 * by - ay) / 4.0;
        return this.quadraticParametricLength(ax, ay, qx, qy, dx, dy);
    }
}

