/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.com.github.weisj.jsvg.nodes;

import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.relocated.com.github.weisj.jsvg.attributes.FillRule;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.AWTSVGShape;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.MeasurableShape;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.ShapeNode;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.prototype.HasFillRule;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.prototype.spec.Category;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import org.jetbrains.relocated.com.github.weisj.jsvg.parser.AttributeNode;
import org.jetbrains.relocated.com.github.weisj.jsvg.util.PathUtil;

@ElementCategories(value={Category.Graphic, Category.Shape})
@PermittedContent(categories={Category.Animation, Category.Descriptive})
public final class Path
extends ShapeNode
implements HasFillRule {
    public static final String TAG = "path";
    private FillRule fillRule;

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    @Override
    @NotNull
    public FillRule fillRule() {
        return this.fillRule;
    }

    @Override
    @NotNull
    protected MeasurableShape buildShape(@NotNull AttributeNode attributeNode) {
        this.fillRule = FillRule.parse(attributeNode);
        String pathValue = attributeNode.getValue("d");
        if (pathValue == null) {
            return new AWTSVGShape<Rectangle>(new Rectangle());
        }
        return PathUtil.parseFromPathData(pathValue, this.fillRule);
    }

    @Override
    protected boolean shouldPaintStartEndMarkersInMiddle() {
        return false;
    }
}

