/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.com.github.weisj.jsvg.nodes;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.MeasurableShape;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.SVGRectangle;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.SVGRoundRectangle;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.size.Length;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.ShapeNode;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.prototype.spec.Category;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import org.jetbrains.relocated.com.github.weisj.jsvg.parser.AttributeNode;

@ElementCategories(value={Category.BasicShape, Category.Graphic, Category.Shape})
@PermittedContent(categories={Category.Animation, Category.Descriptive})
public final class Rect
extends ShapeNode {
    public static final String TAG = "rect";

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    @Override
    @NotNull
    protected MeasurableShape buildShape(@NotNull AttributeNode node) {
        Length x2 = node.getLength("x", 0.0f);
        Length y2 = node.getLength("y", 0.0f);
        Length width2 = node.getLength("width", 0.0f);
        Length height = node.getLength("height", 0.0f);
        Length rx = node.getLength("rx", Length.UNSPECIFIED);
        Length ry = node.getLength("ry", rx);
        if (rx.isUnspecified()) {
            rx = ry;
        }
        rx = rx.coerceNonNegative().orElseIfUnspecified(0.0f);
        ry = ry.coerceNonNegative().orElseIfUnspecified(0.0f);
        if (rx.isZero() && ry.isZero()) {
            return new SVGRectangle(x2, y2, width2, height);
        }
        return new SVGRoundRectangle(x2, y2, width2, height, rx, ry);
    }
}

