/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.TextMateCapture;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001BA\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u0005\u0018\u00010\u0005\u0012\u0010\u0010\u0007\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001f\u0010\u0012\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\n\u0010\u0019\u001a\u00020\u001aH\u0096\u0080\u0004R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\"\u0010\u0004\u001a\u0014\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u0005\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u001a\u0010\u0007\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/textmate/language/syntax/SyntaxNodeDescriptorImpl;", "Lorg/jetbrains/plugins/textmate/language/syntax/SyntaxNodeDescriptor;", "children", "", "captures", "", "Lorg/jetbrains/plugins/textmate/language/syntax/TextMateCapture;", "stringAttributes", "", "<init>", "(Ljava/util/List;[[Lorg/jetbrains/plugins/textmate/language/syntax/TextMateCapture;[Ljava/lang/CharSequence;)V", "getChildren", "()Ljava/util/List;", "[[Lorg/jetbrains/plugins/textmate/language/syntax/TextMateCapture;", "[Ljava/lang/CharSequence;", "getStringAttribute", "key", "Lorg/jetbrains/plugins/textmate/Constants$StringKey;", "getCaptureRules", "Lorg/jetbrains/plugins/textmate/Constants$CaptureKey;", "(Lorg/jetbrains/plugins/textmate/Constants$CaptureKey;)[Lorg/jetbrains/plugins/textmate/language/syntax/TextMateCapture;", "hasBackReference", "", "group", "", "toString", "", "intellij.textmate.core"})
public final class SyntaxNodeDescriptorImpl
implements SyntaxNodeDescriptor {
    @NotNull
    private final List<SyntaxNodeDescriptor> children;
    @Nullable
    private final TextMateCapture[][] captures;
    @Nullable
    private final CharSequence[] stringAttributes;

    public SyntaxNodeDescriptorImpl(@NotNull List<? extends SyntaxNodeDescriptor> children, @Nullable TextMateCapture[][] captures, @Nullable CharSequence[] stringAttributes) {
        Intrinsics.checkNotNullParameter(children, (String)"children");
        this.children = children;
        this.captures = captures;
        this.stringAttributes = stringAttributes;
        if (!(this.stringAttributes == null || this.stringAttributes.length == Constants.StringKey.getEntries().size())) {
            boolean $i$a$-require-SyntaxNodeDescriptorImpl$32 = false;
            String $i$a$-require-SyntaxNodeDescriptorImpl$32 = "stringAttributes must be either null or define all StringKey entries";
            throw new IllegalArgumentException($i$a$-require-SyntaxNodeDescriptorImpl$32.toString());
        }
        if (!(this.captures == null || ((Object[])this.captures).length == Constants.CaptureKey.getEntries().size())) {
            boolean bl = false;
            String string = "captures must be either null or define all CaptureKey entries";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public List<SyntaxNodeDescriptor> getChildren() {
        return this.children;
    }

    @Override
    @Nullable
    public CharSequence getStringAttribute(@NotNull Constants.StringKey key) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        return this.stringAttributes != null ? (CharSequence)ArraysKt.getOrNull((Object[])this.stringAttributes, (int)key.ordinal()) : null;
    }

    @Override
    @Nullable
    public TextMateCapture[] getCaptureRules(@NotNull Constants.CaptureKey key) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        return this.captures != null ? (TextMateCapture[])ArraysKt.getOrNull((Object[])((Object[])this.captures), (int)key.ordinal()) : null;
    }

    @Override
    public boolean hasBackReference(@NotNull Constants.StringKey key) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        return true;
    }

    @Override
    public boolean hasBackReference(@NotNull Constants.CaptureKey key, int group) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        return true;
    }

    @NotNull
    public String toString() {
        CharSequence name;
        CharSequence charSequence = name = this.getStringAttribute(Constants.StringKey.NAME);
        return charSequence != null ? "Syntax rule: " + charSequence : super.toString();
    }
}

