/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn.pnp;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.javascript.HelperFilesLocator;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptionsKt;
import com.intellij.javascript.nodejs.execution.ProcessWithCmdLine;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpFile;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpWorkspace;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpWorkspaceList;
import com.intellij.javascript.nodejs.library.yarn.pnp.model.YarnPnpDependencyTreeReader;
import com.intellij.javascript.nodejs.library.yarn.pnp.model.YarnPnpDependencyTreeTargetPathConverter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.TimeoutUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpDependencyTreeLoader;", "", "pnpFile", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpFile;", "<init>", "(Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpFile;)V", "load", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpWorkspaceList;", "getShortFilePath", "", "createTargetRun", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "parseDependencyTree", "stdout", "targetRun", "Companion", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nYarnPnpDependencyTreeLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YarnPnpDependencyTreeLoader.kt\ncom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpDependencyTreeLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,109:1\n1586#2:110\n1661#2,3:111\n13#3:114\n*S KotlinDebug\n*F\n+ 1 YarnPnpDependencyTreeLoader.kt\ncom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpDependencyTreeLoader\n*L\n51#1:110\n51#1:111,3\n103#1:114\n*E\n"})
public final class YarnPnpDependencyTreeLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final YarnPnpFile pnpFile;
    @NotNull
    private static final Logger LOG;
    private static final int TIMEOUT_MILLIS = 30000;
    @NotNull
    private static final String PREFIX = "##intellij-yarn-pnp-deps-tree-start";
    @NotNull
    private static final String SUFFIX = "##intellij-yarn-pnp-deps-tree-end";

    public YarnPnpDependencyTreeLoader(@NotNull YarnPnpFile pnpFile) {
        Intrinsics.checkNotNullParameter((Object)pnpFile, (String)"pnpFile");
        this.pnpFile = pnpFile;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final YarnPnpWorkspaceList load() throws ExecutionException {
        Object object;
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        long startNano = System.nanoTime();
        NodeTargetRun targetRun = this.createTargetRun();
        ProcessWithCmdLine processWithCmdLine = targetRun.startProcessEx();
        ProcessHandler processHandler = (ProcessHandler)processWithCmdLine.getProcessHandler();
        CapturingProcessRunner runner = new CapturingProcessRunner(processHandler);
        ProcessOutput processOutput = runner.runProcess(30000, true);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        ProcessOutput output = processOutput;
        if (!processHandler.isProcessTerminated()) {
            boolean bl = output.isTimeout();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            ScriptRunnerUtil.terminateProcessHandler((ProcessHandler)processHandler, (long)1000L, null);
        }
        String commandLineText = processWithCmdLine.getCommandLinePresentation();
        if (output.getExitCode() != 0 || output.isTimeout()) {
            throw new ExecutionException("Cannot fetch Yarn PnP dependency tree for " + this.getShortFilePath() + ", command: " + commandLineText + ", " + output);
        }
        YarnPnpWorkspaceList workspaceList = null;
        Exception cause = null;
        try {
            String string = output.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
            workspaceList = this.parseDependencyTree(string, targetRun);
        }
        catch (Exception e) {
            cause = e;
        }
        if (workspaceList == null) {
            throw new ExecutionException("Cannot fetch Yarn PnP dependency tree for " + this.getShortFilePath() + ": " + output, (Throwable)cause);
        }
        Iterable iterable = workspaceList.getWorkspaces();
        int n = workspaceList.getWorkspaces().size();
        String string = this.getShortFilePath();
        boolean $i$f$map = false;
        void var14_18 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            YarnPnpWorkspace yarnPnpWorkspace = (YarnPnpWorkspace)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDependencies().size());
        }
        collection = (List)destination$iv$iv;
        long l = TimeoutUtil.getDurationMillis((long)startNano);
        String string2 = output.getStderr();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStderr(...)");
        if (((CharSequence)string2).length() == 0) {
            object = "";
        } else {
            String string3 = output.getStderr();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getStderr(...)");
            object = ", stderr: " + ((Object)StringsKt.trim((CharSequence)string3)).toString();
        }
        String message = "Yarn PnP dependency tree for " + string + " has " + n + " workspaces with " + (List)collection + " deps, loaded in " + l + " ms, command: " + commandLineText + (String)object;
        if (LOG.isDebugEnabled()) {
            message = message + output;
        }
        LOG.info(message);
        return workspaceList;
    }

    private final String getShortFilePath() {
        String string = this.pnpFile.getPnpFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String path2 = string;
        if (LOG.isDebugEnabled()) {
            return path2;
        }
        int ind = path2.length();
        for (int i = 0; i < 3; ++i) {
            ind = StringsKt.lastIndexOf$default((CharSequence)path2, (char)'/', (int)(ind - 1), (boolean)false, (int)4, null);
        }
        String string2 = path2.substring(ind + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string2;
    }

    private final NodeTargetRun createTargetRun() throws ExecutionException {
        NodeJsInterpreter nodeJsInterpreter = NodeJsInterpreterManager.getInstance(this.pnpFile.getProject()).getInterpreterOrThrow();
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreter, (String)"getInterpreterOrThrow(...)");
        NodeJsInterpreter interpreter2 = nodeJsInterpreter;
        Project project = this.pnpFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        NodeTargetRun targetRun = new NodeTargetRun(interpreter2, project, null, NodeTargetRunOptionsKt.targetRunOptions$default(false, null, null, 6, null), null, 16, null);
        VirtualFile virtualFile = this.pnpFile.getPnpFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getPnpFile(...)");
        VirtualFile pnpVirtualFile = virtualFile;
        String string = PathUtil.getParentPath((String)pnpVirtualFile.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParentPath(...)");
        String parentPath = string;
        if (((CharSequence)parentPath).length() == 0) {
            throw new ExecutionException("No parent for " + pnpVirtualFile.getPath());
        }
        targetRun.setEnableWrappingWithYarnNode(true);
        TargetedCommandLineBuilder commandLine = targetRun.getCommandLineBuilder();
        commandLine.setWorkingDirectory(targetRun.path(parentPath));
        commandLine.addParameter(targetRun.path(HelperFilesLocator.resolvePathForExecution("nodejs/library/yarn/intellij-yarn-pnp-deps-tree-loader.js")));
        return targetRun;
    }

    private final YarnPnpWorkspaceList parseDependencyTree(String stdout, NodeTargetRun targetRun) throws IOException {
        int prefixInd = StringsKt.indexOf$default((CharSequence)stdout, (String)PREFIX, (int)0, (boolean)false, (int)6, null);
        int suffixInd = StringsKt.lastIndexOf$default((CharSequence)stdout, (String)SUFFIX, (int)0, (boolean)false, (int)6, null);
        if (prefixInd < 0 || suffixInd < 0) {
            return null;
        }
        String string = stdout.substring(prefixInd + 35, suffixInd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String jsonOutput = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String jsonWithLocalPaths = new YarnPnpDependencyTreeTargetPathConverter(jsonOutput, targetRun).getJsonWithLocalPaths();
        return new YarnPnpDependencyTreeReader(this.pnpFile, (Function1<? super String, String>)((Function1)arg_0 -> YarnPnpDependencyTreeLoader.parseDependencyTree$lambda$0(this, arg_0))).read(jsonWithLocalPaths);
    }

    private static final String parseDependencyTree$lambda$0(YarnPnpDependencyTreeLoader this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Project project = this$0.pnpFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return YarnPnpWorkspace.Companion.buildLibraryName(project, it);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(YarnPnpDependencyTreeLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpDependencyTreeLoader$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "TIMEOUT_MILLIS", "", "PREFIX", "", "SUFFIX", "intellij.javascript.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

