/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.web.js;

import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u0005H\u0007J\u0012\u0010\r\u001a\u00020\t*\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\"\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/javascript/web/js/WebJSTypesUtil;", "", "<init>", "()V", "HTML_ELEMENT_TAG_NAME_MAP_CLASS_NAME", "", "HTML_ELEMENT_TAG_NAME_MAP_CLASS_NAME_DEPRECATED", "HTML_ELEMENT_CLASS_NAME", "getHtmlElementClassType", "Lcom/intellij/lang/javascript/psi/JSType;", "typeSource", "Lcom/intellij/lang/javascript/psi/types/JSTypeSource;", "tagName", "wrapWithUndefinedIfOptional", "property", "Lcom/intellij/lang/javascript/psi/JSRecordType$PropertySignature;", "getPropertyTypeFromNamespace", "mapClass", "intellij.javascript.web"})
public final class WebJSTypesUtil {
    @NotNull
    public static final WebJSTypesUtil INSTANCE = new WebJSTypesUtil();
    @NotNull
    private static final String HTML_ELEMENT_TAG_NAME_MAP_CLASS_NAME = "HTMLElementTagNameMap";
    @NotNull
    private static final String HTML_ELEMENT_TAG_NAME_MAP_CLASS_NAME_DEPRECATED = "HTMLElementDeprecatedTagNameMap";
    @NotNull
    private static final String HTML_ELEMENT_CLASS_NAME = "HTMLElement";

    private WebJSTypesUtil() {
    }

    @JvmStatic
    @NonNls
    @NotNull
    public static final JSType getHtmlElementClassType(@NotNull JSTypeSource typeSource, @NonNls @NotNull String tagName) {
        Intrinsics.checkNotNullParameter((Object)typeSource, (String)"typeSource");
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        JSTypeEvaluationLocationProvider.assertLocationIsSet();
        JSType jSType = INSTANCE.getPropertyTypeFromNamespace(HTML_ELEMENT_TAG_NAME_MAP_CLASS_NAME, typeSource, tagName);
        if (jSType == null && (jSType = INSTANCE.getPropertyTypeFromNamespace(HTML_ELEMENT_TAG_NAME_MAP_CLASS_NAME_DEPRECATED, typeSource, tagName)) == null) {
            JSType jSType2 = JSNamedTypeFactory.createType((String)HTML_ELEMENT_CLASS_NAME, (JSTypeSource)typeSource, (JSContext)JSContext.INSTANCE);
            jSType = jSType2;
            Intrinsics.checkNotNullExpressionValue((Object)jSType2, (String)"createType(...)");
        }
        return jSType;
    }

    @NotNull
    public final JSType wrapWithUndefinedIfOptional(@NotNull JSType $this$wrapWithUndefinedIfOptional, @NotNull JSRecordType.PropertySignature property) {
        JSType jSType;
        Intrinsics.checkNotNullParameter((Object)$this$wrapWithUndefinedIfOptional, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (property.isOptional()) {
            JSType jSType2 = JSTypeGuardUtil.wrapWithUndefined((JSType)$this$wrapWithUndefinedIfOptional, null);
            jSType = jSType2;
            Intrinsics.checkNotNull((Object)jSType2);
        } else {
            jSType = $this$wrapWithUndefinedIfOptional;
        }
        return jSType;
    }

    private final JSType getPropertyTypeFromNamespace(String mapClass, JSTypeSource typeSource, String tagName) {
        JSType jSType;
        JSRecordType.PropertySignature propertySignature = JSNamedTypeFactory.createType((String)mapClass, (JSTypeSource)typeSource, (JSContext)JSContext.INSTANCE).asRecordType().findPropertySignature(StringUtil.toLowerCase((String)tagName));
        return propertySignature != null && (jSType = propertySignature.getJSType()) != null ? jSType.withNewSource(typeSource) : null;
    }
}

