/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettingsTracker;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.lang.typescript.compiler.TypeScriptServiceHolder;
import com.intellij.lang.typescript.compiler.VirtualFileAndTypeScriptService;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.lsp.TypeScriptGoTypeEvaluationLspServiceKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptLanguageServiceAnnotatorCheckerProvider
extends TypeScriptAnnotatorCheckerProvider {
    public static final Key<CachedValue<Boolean>> USE_SERVICE_INFO = Key.create((String)"use.service.info");
    private final Project myProject;
    @Nullable
    private final TypeScriptCompilerSettings mySettings;
    private final TypeScriptCompilerSettingsTracker myTracker;

    public TypeScriptLanguageServiceAnnotatorCheckerProvider(@NotNull Project project) {
        if (project == null) {
            TypeScriptLanguageServiceAnnotatorCheckerProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.mySettings = TypeScriptCompilerSettings.getSettings(project);
        this.myTracker = TypeScriptCompilerSettingsTracker.getInstance(project);
    }

    @Override
    protected boolean isAvailable(@NotNull PsiElement context2) {
        PsiFile file;
        if (context2 == null) {
            TypeScriptLanguageServiceAnnotatorCheckerProvider.$$$reportNull$$$0(1);
        }
        return Boolean.TRUE == CachedValuesManager.getCachedValue((PsiElement)(file = context2.getContainingFile().getOriginalFile()), USE_SERVICE_INFO, () -> CachedValueProvider.Result.create((Object)this.isAvailableImpl(file), (Object[])new Object[]{this.myTracker, VirtualFileManager.getInstance()}));
    }

    private boolean isAvailableImpl(@NotNull PsiFile context2) {
        if (context2 == null) {
            TypeScriptLanguageServiceAnnotatorCheckerProvider.$$$reportNull$$$0(2);
        }
        if (this.mySettings == null || ApplicationManager.getApplication().isUnitTestMode() && TypeScriptLanguageServiceUtil.ourUseService != TypeScriptLanguageServiceUtil.TypeScriptUseServiceState.DEFAULT && TypeScriptLanguageServiceUtil.ourUseService != TypeScriptLanguageServiceUtil.TypeScriptUseServiceState.USE_FOR_EVERYTHING) {
            return false;
        }
        TypeScriptService service = TypeScriptLanguageServiceAnnotatorCheckerProvider.getService((PsiElement)context2);
        if (service == null) {
            return false;
        }
        return TypeScriptLanguageServiceAnnotatorCheckerProvider.checkServiceIsAvailable(this.myProject, service, this.mySettings) && service.isAcceptableForHighlighting(context2);
    }

    public static boolean checkServiceIsAvailable(@NotNull Project project, @Nullable TypeScriptService service, @NotNull TypeScriptCompilerSettings settings) {
        JSLanguageServiceBase jsLanguageService;
        if (project == null) {
            TypeScriptLanguageServiceAnnotatorCheckerProvider.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            TypeScriptLanguageServiceAnnotatorCheckerProvider.$$$reportNull$$$0(4);
        }
        if (service == null || !TypeScriptLanguageServiceUtil.isServiceEnabled(project)) {
            return false;
        }
        if (service instanceof JSLanguageServiceBase && !(jsLanguageService = (JSLanguageServiceBase)((Object)service)).checkCanUseService()) {
            return false;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return TypeScriptLanguageServiceUtil.ourUseService == TypeScriptLanguageServiceUtil.TypeScriptUseServiceState.DEFAULT || TypeScriptLanguageServiceUtil.ourUseService == TypeScriptLanguageServiceUtil.TypeScriptUseServiceState.USE_FOR_EVERYTHING;
        }
        return true;
    }

    @Nullable
    private static TypeScriptService getService(@Nullable PsiElement context2) {
        if (context2 == null) {
            return null;
        }
        PsiFile file = context2.getContainingFile();
        return (TypeScriptService)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create((Object)TypeScriptLanguageServiceAnnotatorCheckerProvider.getServiceNoCache(file), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS}));
    }

    @Nullable
    private static TypeScriptService getServiceNoCache(@NotNull PsiFile file) {
        if (file == null) {
            TypeScriptLanguageServiceAnnotatorCheckerProvider.$$$reportNull$$$0(5);
        }
        return (TypeScriptService)ObjectUtils.doIfNotNull((Object)TypeScriptServiceHolder.getForElement((PsiElement)file, false), it -> it.getService());
    }

    @Override
    public boolean useEmptyTypeChecker() {
        return true;
    }

    @Override
    @Nullable
    protected PsiElement getAdjustedTypeCheckProblemPlace(PsiElement psiElement) {
        if (psiElement instanceof JSExpression) {
            PsiElement parent = psiElement.getParent();
            if (parent instanceof JSReturnStatement) {
                JSReturnStatement returnStatement = (JSReturnStatement)parent;
                ASTNode returnKeywordNode = returnStatement.getNode().findChildByType(JSTokenTypes.RETURN_KEYWORD);
                return returnKeywordNode != null ? returnKeywordNode.getPsi() : parent;
            }
            if (parent instanceof JSVariable) {
                return ((JSNamedElement)parent).getNameIdentifier();
            }
            if (parent instanceof JSAssignmentExpression) {
                return ((JSAssignmentExpression)parent).getDefinitionExpression();
            }
        }
        return null;
    }

    @Override
    public boolean skipErrors(@Nullable PsiElement context2) {
        if (context2 == null) {
            return false;
        }
        TypeScriptService service = TypeScriptLanguageServiceAnnotatorCheckerProvider.getService(context2);
        if (service == null) {
            return false;
        }
        return service.skipInternalErrors(context2);
    }

    @Override
    public boolean isRunAfterServiceErrorsOptimizationEnabled(PsiFile file) {
        VirtualFileAndTypeScriptService tsGoEvalService = TypeScriptGoTypeEvaluationLspServiceKt.getTsGoTypeService(file.getProject(), (PsiElement)file);
        return tsGoEvalService == null || !tsGoEvalService.getService().isTypeEvaluationEnabled();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceAnnotatorCheckerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkServiceIsAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getServiceNoCache";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

