/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.modules;

import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.lang.javascript.frameworks.modules.JSModuleReferenceContributorUtil;
import com.intellij.lang.javascript.index.JSIndexKeys;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.javascript.psi.stubs.ES6SideEffectImportIndexKt;
import com.intellij.lang.typescript.resolve.TypeScriptAugmentationUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\fH\u0016J\u001c\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J,\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u0014H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/lang/typescript/modules/TypeScriptAugmentationReferenceContributor;", "Lcom/intellij/lang/javascript/psi/resolve/JSModuleReferenceContributor$JSModuleReferenceMergeContributor;", "<init>", "()V", "getAllReferences", "", "Lcom/intellij/psi/PsiReference;", "unquotedEscapedText", "", "host", "Lcom/intellij/psi/PsiElement;", "offset", "", "provider", "Lcom/intellij/psi/PsiReferenceProvider;", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;ILcom/intellij/psi/PsiReferenceProvider;)[Lcom/intellij/psi/PsiReference;", "isApplicable", "", "getDefaultWeight", "getDependencies", "", "unquoted", "resolveReferences", "context", "path", "elements", "intellij.javascript.backend"})
public final class TypeScriptAugmentationReferenceContributor
implements JSModuleReferenceContributor.JSModuleReferenceMergeContributor {
    @NotNull
    public PsiReference[] getAllReferences(@NotNull String unquotedEscapedText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        Intrinsics.checkNotNullParameter((Object)unquotedEscapedText, (String)"unquotedEscapedText");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return new PsiReference[0];
    }

    public boolean isApplicable(@NotNull PsiElement host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Project project = host.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return !DumbService.Companion.isDumb(project) && (!(host instanceof TypeScriptModule) || !((TypeScriptModule)host).isAugmentation());
    }

    public int getDefaultWeight() {
        return JSModuleBaseReference.ModuleTypes.TS_MODULE.weight();
    }

    @NotNull
    public Collection<?> getDependencies(@NotNull String unquoted, @NotNull PsiElement host) {
        Intrinsics.checkNotNullParameter((Object)unquoted, (String)"unquoted");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Object[] objectArray = new Object[]{JSModuleReferenceContributorUtil.getIndexModificationTracker(host, JSIndexKeys.TS_MODULE_NAME_INDEX_KEY), JSModuleReferenceContributorUtil.getIndexModificationTracker(host, ES6SideEffectImportIndexKt.sideEffectImportIndexKey)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public Collection<PsiElement> resolveReferences(@NotNull PsiElement context2, @NotNull String path2, @NotNull Collection<? extends PsiElement> elements) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return TypeScriptAugmentationUtil.getAugmentations((PsiElement)context2, elements);
    }
}

