/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.typescript.settings.exclude.TypeScriptExcludeManager;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigIndex;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002\u001a\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002\u001a\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002\u001a\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014H\u0003\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014H\u0002\u001a\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0004H\u0002\"\u0010\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0002\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"UPDATE_TIME", "Lkotlin/time/Duration;", "J", "DEPRECATED_TSCONFIG_LIBRARY", "", "addRootDirs", "Lkotlin/sequences/Sequence;", "Lcom/intellij/openapi/vfs/VirtualFile;", "value", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptConfigIndex$TypeScriptExternalPaths;", "configDir", "getBaseUrlRelativePaths", "", "getBaseUrlFile", "baseUrl", "checkNeedUpdate", "", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "getDeprecatedLibrary", "Lcom/intellij/openapi/roots/libraries/Library;", "updateLibrary", "", "pathCanBeProcessed", "pattern", "intellij.javascript.backend"})
public final class TypeScriptConfigLibraryUpdaterKt {
    private static final long UPDATE_TIME = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS);
    @NotNull
    private static final String DEPRECATED_TSCONFIG_LIBRARY = "tsconfig$roots";

    private static final Sequence<VirtualFile> addRootDirs(TypeScriptConfigIndex.TypeScriptExternalPaths value, VirtualFile configDir) {
        List<String> list = value.rootDirs;
        Intrinsics.checkNotNullExpressionValue(list, (String)"rootDirs");
        return SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), arg_0 -> TypeScriptConfigLibraryUpdaterKt.addRootDirs$lambda$0(configDir, arg_0)), TypeScriptConfigLibraryUpdaterKt::addRootDirs$lambda$1);
    }

    private static final List<VirtualFile> getBaseUrlRelativePaths(TypeScriptConfigIndex.TypeScriptExternalPaths value, VirtualFile configDir) {
        String url = value.baseUrl;
        VirtualFile virtualFile = JSPathMappingsUtil.getRelativeOrAbsoluteFilePath((String)url, (VirtualFile)configDir);
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile baseUrl = virtualFile;
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (String path2 : value.pathsInMappings) {
            String canonicalPath;
            String string;
            Intrinsics.checkNotNull((Object)path2);
            if (!TypeScriptConfigLibraryUpdaterKt.pathCanBeProcessed(path2)) {
                return TypeScriptConfigLibraryUpdaterKt.getBaseUrlFile(baseUrl);
            }
            boolean endsWithStar = StringsKt.contains$default((CharSequence)path2, (CharSequence)"*", (boolean)false, (int)2, null);
            if (endsWithStar) {
                String string2 = path2.substring(0, StringsKt.indexOf$default((CharSequence)path2, (char)'*', (int)0, (boolean)false, (int)6, null));
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = path2;
            }
            String normalizedPath = string;
            VirtualFile pathUrl = JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute((VirtualFile)baseUrl, (String)normalizedPath);
            if (!endsWithStar && pathUrl == null) {
                String extension;
                Intrinsics.checkNotNullExpressionValue((Object)TypeScriptUtil.TYPESCRIPT_EXTENSIONS, (String)"TYPESCRIPT_EXTENSIONS");
                String[] stringArray = TypeScriptUtil.TYPESCRIPT_EXTENSIONS;
                int n = stringArray.length;
                for (int i = 0; i < n && (pathUrl = JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute((VirtualFile)baseUrl, (String)(normalizedPath + (extension = stringArray[i])))) == null; ++i) {
                }
            }
            if (pathUrl == null || (canonicalPath = pathUrl.getCanonicalPath()) == null || canonicalPath.length() <= 2) continue;
            result2.add(pathUrl);
        }
        return result2;
    }

    private static final List<VirtualFile> getBaseUrlFile(VirtualFile baseUrl) {
        List list;
        String path2 = baseUrl.getCanonicalPath();
        if (path2 == null || path2.length() <= 2) {
            List list2 = ContainerUtil.emptyList();
            list = list2;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"emptyList(...)");
        } else {
            list = CollectionsKt.listOfNotNull((Object)baseUrl);
        }
        return list;
    }

    @RequiresReadLock
    private static final boolean checkNeedUpdate(Project project, Collection<? extends VirtualFile> files) {
        Library deprecatedLibrary = TypeScriptConfigLibraryUpdaterKt.getDeprecatedLibrary(project);
        if (deprecatedLibrary != null) {
            return true;
        }
        TypeScriptExcludeManager typeScriptExcludeManager = TypeScriptExcludeManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)typeScriptExcludeManager, (String)"getInstance(...)");
        TypeScriptExcludeManager manager = typeScriptExcludeManager;
        return !Intrinsics.areEqual(new HashSet<VirtualFile>(files), new HashSet<VirtualFile>(manager.getAdditionalRoots()));
    }

    private static final Library getDeprecatedLibrary(Project project) {
        JSLibraryManager jSLibraryManager = JSLibraryManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)jSLibraryManager), (String)"getInstance(...)");
        JSLibraryManager libraryManager = jSLibraryManager;
        LibraryTable libraryTable = libraryManager.getLibraryTable(ScriptingLibraryModel.LibraryLevel.PROJECT);
        Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"getLibraryTable(...)");
        LibraryTable libTable = libraryTable;
        return libTable.getLibraryByName(DEPRECATED_TSCONFIG_LIBRARY);
    }

    private static final void updateLibrary(Project project, Collection<? extends VirtualFile> files) {
        if (project.isDisposed()) {
            return;
        }
        TypeScriptExcludeManager typeScriptExcludeManager = TypeScriptExcludeManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)typeScriptExcludeManager, (String)"getInstance(...)");
        TypeScriptExcludeManager manager = typeScriptExcludeManager;
        Library deprecatedLibrary = TypeScriptConfigLibraryUpdaterKt.getDeprecatedLibrary(project);
        JSLibraryManager jSLibraryManager = JSLibraryManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)jSLibraryManager), (String)"getInstance(...)");
        ScriptingLibraryManager libraryManager = jSLibraryManager;
        if (deprecatedLibrary != null) {
            ScriptingLibraryModel deprecatedModule = libraryManager.getScriptingLibraryTable().getModel(deprecatedLibrary);
            libraryManager.removeLibrary(deprecatedModule);
        }
        libraryManager.getLibraryByName("tsconfig$paths");
        manager.updateAdditionalRoots(files);
        libraryManager.commitChanges(RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED);
    }

    private static final boolean pathCanBeProcessed(String pattern) {
        return JSPathMappingsUtil.isPatternOrMappingEndsWithStar((String)pattern) || StringsKt.contains$default((CharSequence)pattern, (CharSequence)"/*", (boolean)false, (int)2, null) || !StringsKt.contains$default((CharSequence)pattern, (char)'*', (boolean)false, (int)2, null);
    }

    private static final VirtualFile addRootDirs$lambda$0(VirtualFile $configDir, String it) {
        return JSPathMappingsUtil.getRelativeOrAbsoluteFilePath((String)it, (VirtualFile)$configDir);
    }

    private static final boolean addRootDirs$lambda$1(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPath().length() > 2;
    }

    public static final /* synthetic */ long access$getUPDATE_TIME$p() {
        return UPDATE_TIME;
    }

    public static final /* synthetic */ boolean access$checkNeedUpdate(Project project, Collection files) {
        return TypeScriptConfigLibraryUpdaterKt.checkNeedUpdate(project, files);
    }

    public static final /* synthetic */ Sequence access$addRootDirs(TypeScriptConfigIndex.TypeScriptExternalPaths value, VirtualFile configDir) {
        return TypeScriptConfigLibraryUpdaterKt.addRootDirs(value, configDir);
    }

    public static final /* synthetic */ List access$getBaseUrlRelativePaths(TypeScriptConfigIndex.TypeScriptExternalPaths value, VirtualFile configDir) {
        return TypeScriptConfigLibraryUpdaterKt.getBaseUrlRelativePaths(value, configDir);
    }

    public static final /* synthetic */ void access$updateLibrary(Project project, Collection files) {
        TypeScriptConfigLibraryUpdaterKt.updateLibrary(project, files);
    }
}

