/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.model.DasColumn;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0082\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\f0\t\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/data/types/DasColumnRef;", "Lcom/intellij/database/data/types/ColumnRef;", "col", "Lcom/intellij/database/model/DasColumn;", "<init>", "(Lcom/intellij/database/model/DasColumn;)V", "getCol", "()Lcom/intellij/database/model/DasColumn;", "name", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "getName", "()Ljava/lang/String;", "typeName", "getTypeName", "equals", "", "other", "", "hashCode", "", "intellij.database.core.impl"})
public final class DasColumnRef
extends ColumnRef {
    @NotNull
    private final DasColumn col;
    @NotNull
    private final String name;
    @NotNull
    private final String typeName;

    public DasColumnRef(@NotNull DasColumn col) {
        Intrinsics.checkNotNullParameter((Object)col, (String)"col");
        super(null);
        this.col = col;
        String string = this.col.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.name = string;
        DasType dasType = this.col.getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        this.typeName = DasTypeUtilsKt.getTypeName(dasType);
    }

    @NotNull
    public final DasColumn getCol() {
        return this.col;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getTypeName() {
        return this.typeName;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof DasColumnRef && Intrinsics.areEqual((Object)this.col, (Object)((DasColumnRef)other).col);
    }

    public int hashCode() {
        return this.col.hashCode();
    }
}

