/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection.query;

import com.intellij.database.util.common.TextTable;
import com.intellij.openapi.util.NlsSafe;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\b\u0005\u0018\u0000 %2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002$%B\u001d\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0002J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0002J\u0006\u0010\u000e\u001a\u00020\u0002J\u0012\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0096\u0081\u0004J\u0012\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0003H\u0096\u0081\u0004J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u0002H\u0096\u0083\u0004J\n\u0010\u0015\u001a\u00020\u0010H\u0096\u0081\u0004R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R%\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00180\u0017X\u0096\u0085\b\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0019\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017X\u0096\u0085\b\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0013\u0010\u001d\u001a\u00020\tX\u0096\u0085\b\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0019\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030!X\u0096\u0085\b\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006&"}, d2={"Lcom/intellij/database/introspection/query/QueryStats;", "", "", "Lcom/intellij/database/introspection/query/QueryStats$StatEntry;", "stats", "", "<init>", "(Ljava/util/Map;)V", "turnSequence", "", "registerStart", "name", "getSortedList", "", "getSortedText", "containsKey", "", "key", "containsValue", "value", "get", "isEmpty", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "size", "getSize", "()I", "values", "", "getValues", "()Ljava/util/Collection;", "StatEntry", "Companion", "intellij.database.core.impl"})
public final class QueryStats
implements Map<String, StatEntry>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, StatEntry> stats;
    private volatile int turnSequence;
    public static final int prettyTextWidth = 140;

    public QueryStats(@NotNull Map<String, StatEntry> stats) {
        Intrinsics.checkNotNullParameter(stats, (String)"stats");
        this.stats = stats;
    }

    public /* synthetic */ QueryStats(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = new HashMap();
        }
        this(map);
    }

    @NotNull
    public final StatEntry registerStart(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        StatEntry statEntry = this.stats.computeIfAbsent(name, arg_0 -> QueryStats.registerStart$lambda$1(arg_0 -> QueryStats.registerStart$lambda$0(this, name, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)statEntry, (String)"computeIfAbsent(...)");
        StatEntry e = statEntry;
        e.registerStart();
        return e;
    }

    private final List<StatEntry> getSortedList() {
        return CollectionsKt.sortedWith((Iterable)this.stats.values(), (Comparator)StatEntry.DurationComparator.INSTANCE);
    }

    @NotNull
    public final String getSortedText() {
        StringBuilder stringBuilder;
        List<StatEntry> rows = this.getSortedList();
        Ref.LongRef totalDuration = new Ref.LongRef();
        for (StatEntry row : rows) {
            totalDuration.element += row.getDurationSum();
        }
        TextTable.Column[] columnArray = new TextTable.Column[]{new TextTable.Column("##", TextTable.Align.RIGHT, QueryStats::getSortedText$lambda$0), new TextTable.Column("count", TextTable.Align.RIGHT, QueryStats::getSortedText$lambda$1), new TextTable.Column("err", TextTable.Align.RIGHT, QueryStats::getSortedText$lambda$2), new TextTable.Column("T.min", TextTable.Align.RIGHT, QueryStats::getSortedText$lambda$3), new TextTable.Column("T.avg", TextTable.Align.RIGHT, QueryStats::getSortedText$lambda$4), new TextTable.Column("T.max", TextTable.Align.RIGHT, QueryStats::getSortedText$lambda$5), new TextTable.Column("T.sum", TextTable.Align.RIGHT, QueryStats::getSortedText$lambda$6), new TextTable.Column("%", TextTable.Align.RIGHT, arg_0 -> QueryStats.getSortedText$lambda$7(totalDuration, arg_0)), new TextTable.Column("rows", TextTable.Align.RIGHT, QueryStats::getSortedText$lambda$8), new TextTable.Column("packs", TextTable.Align.RIGHT, QueryStats::getSortedText$lambda$9), new TextTable.Column("Query", null, QueryStats::getSortedText$lambda$10, 2, null)};
        TextTable tt = new TextTable(columnArray);
        int n = 1000;
        StringBuilder $this$getSortedText_u24lambda_u2411 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        $this$getSortedText_u24lambda_u2411.append("Query Performance Statistics:\n");
        tt.processContent((Iterable)rows, $this$getSortedText_u24lambda_u2411);
        $this$getSortedText_u24lambda_u2411.append("Total duration of all queries: ").append(QueryStats.Companion.formatToSeconds(totalDuration.element)).append(" s.");
        return stringBuilder.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.stats.isEmpty();
    }

    public boolean containsKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.stats.containsKey(key);
    }

    public boolean containsValue(@NotNull StatEntry value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.stats.containsValue(value);
    }

    @Nullable
    public StatEntry get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.stats.get(key);
    }

    public int getSize() {
        return this.stats.size();
    }

    @NotNull
    public Set<String> getKeys() {
        return this.stats.keySet();
    }

    @NotNull
    public Collection<StatEntry> getValues() {
        return this.stats.values();
    }

    @NotNull
    public Set<Map.Entry<String, StatEntry>> getEntries() {
        return this.stats.entrySet();
    }

    @Override
    public StatEntry put(String key, StatEntry value) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public StatEntry remove(Object key) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void putAll(Map<? extends String, ? extends StatEntry> from) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super StatEntry, ? extends StatEntry> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public StatEntry putIfAbsent(String p0, StatEntry p1) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean replace(String p0, StatEntry p1, StatEntry p2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public StatEntry replace(String p0, StatEntry p1) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public StatEntry computeIfAbsent(String p0, Function<? super String, ? extends StatEntry> p1) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public StatEntry computeIfPresent(String p0, BiFunction<? super String, ? super StatEntry, ? extends StatEntry> p1) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public StatEntry compute(String p0, BiFunction<? super String, ? super StatEntry, ? extends StatEntry> p1) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public StatEntry merge(String p0, StatEntry p1, BiFunction<? super StatEntry, ? super StatEntry, ? extends StatEntry> p2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    private static final StatEntry registerStart$lambda$0(QueryStats this$0, String $name, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ++this$0.turnSequence;
        return new StatEntry(this$0.turnSequence, $name);
    }

    private static final StatEntry registerStart$lambda$1(Function1 $tmp0, Object p0) {
        return (StatEntry)$tmp0.invoke(p0);
    }

    private static final int getSortedText$percentOfTotalDuration(Ref.LongRef totalDuration, long durationSum) {
        return totalDuration.element == 0L ? 0 : MathKt.roundToInt((double)(100.0 * (double)durationSum / (double)totalDuration.element));
    }

    private static final CharSequence getSortedText$lambda$0(StatEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return String.valueOf(it.getTurn());
    }

    private static final CharSequence getSortedText$lambda$1(StatEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return String.valueOf(it.getNumberOfFinishes());
    }

    private static final CharSequence getSortedText$lambda$2(StatEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return QueryStats.Companion.toStringIfNotZero(it.getNumberOfFails());
    }

    private static final CharSequence getSortedText$lambda$3(StatEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return QueryStats.Companion.formatToSeconds(it.getDurationMin());
    }

    private static final CharSequence getSortedText$lambda$4(StatEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return QueryStats.Companion.formatToSeconds(it.getDurationAvg());
    }

    private static final CharSequence getSortedText$lambda$5(StatEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return QueryStats.Companion.formatToSeconds(it.getDurationMax());
    }

    private static final CharSequence getSortedText$lambda$6(StatEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return QueryStats.Companion.formatToSeconds(it.getDurationSum());
    }

    private static final CharSequence getSortedText$lambda$7(Ref.LongRef $totalDuration, StatEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return String.valueOf(QueryStats.getSortedText$percentOfTotalDuration($totalDuration, it.getDurationSum()));
    }

    private static final CharSequence getSortedText$lambda$8(StatEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return QueryStats.Companion.toStringIfNotZero(it.getFetchedRows());
    }

    private static final CharSequence getSortedText$lambda$9(StatEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return QueryStats.Companion.toStringIfNotZero(it.getFetchedPacks());
    }

    private static final CharSequence getSortedText$lambda$10(StatEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    public QueryStats() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0006\u001a\u00020\u0007*\u00020\u0005H\u0002J\f\u0010\b\u001a\u00020\u0007*\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/introspection/query/QueryStats$Companion;", "", "<init>", "()V", "prettyTextWidth", "", "toStringIfNotZero", "", "formatToSeconds", "", "intellij.database.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final String toStringIfNotZero(int $this$toStringIfNotZero) {
            return $this$toStringIfNotZero != 0 ? String.valueOf($this$toStringIfNotZero) : "";
        }

        private final String formatToSeconds(long $this$formatToSeconds) {
            return $this$formatToSeconds / (long)1000 + "." + StringsKt.padStart((String)String.valueOf($this$formatToSeconds % (long)1000), (int)3, (char)'0');
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00010B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010(\u001a\u00020)J(\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00032\b\b\u0002\u0010.\u001a\u00020/R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\t\"\u0004\b\u0013\u0010\u0010R\u001a\u0010\u0014\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\t\"\u0004\b\u0016\u0010\u0010R\u001a\u0010\u0017\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\t\"\u0004\b\u0019\u0010\u0010R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fR\u001a\u0010#\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001d\"\u0004\b%\u0010\u001fR\u0011\u0010&\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001d\u00a8\u00061"}, d2={"Lcom/intellij/database/introspection/query/QueryStats$StatEntry;", "", "turn", "", "name", "", "<init>", "(ILjava/lang/String;)V", "getTurn", "()I", "getName", "()Ljava/lang/String;", "numberOfStarts", "numberOfFinishes", "getNumberOfFinishes", "setNumberOfFinishes", "(I)V", "numberOfFails", "getNumberOfFails", "setNumberOfFails", "fetchedPacks", "getFetchedPacks", "setFetchedPacks", "fetchedRows", "getFetchedRows", "setFetchedRows", "durationMin", "", "getDurationMin", "()J", "setDurationMin", "(J)V", "durationMax", "getDurationMax", "setDurationMax", "durationSum", "getDurationSum", "setDurationSum", "durationAvg", "getDurationAvg", "registerStart", "", "registerFinish", "duration", "packs", "rows", "failed", "", "DurationComparator", "intellij.database.core.impl"})
    public static final class StatEntry {
        private final int turn;
        @NotNull
        private final String name;
        private int numberOfStarts;
        private int numberOfFinishes;
        private int numberOfFails;
        private int fetchedPacks;
        private int fetchedRows;
        private long durationMin;
        private long durationMax;
        private long durationSum;

        public StatEntry(int turn, @NlsSafe @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.turn = turn;
            this.name = name;
        }

        public final int getTurn() {
            return this.turn;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final int getNumberOfFinishes() {
            return this.numberOfFinishes;
        }

        public final void setNumberOfFinishes(int n) {
            this.numberOfFinishes = n;
        }

        public final int getNumberOfFails() {
            return this.numberOfFails;
        }

        public final void setNumberOfFails(int n) {
            this.numberOfFails = n;
        }

        public final int getFetchedPacks() {
            return this.fetchedPacks;
        }

        public final void setFetchedPacks(int n) {
            this.fetchedPacks = n;
        }

        public final int getFetchedRows() {
            return this.fetchedRows;
        }

        public final void setFetchedRows(int n) {
            this.fetchedRows = n;
        }

        public final long getDurationMin() {
            return this.durationMin;
        }

        public final void setDurationMin(long l) {
            this.durationMin = l;
        }

        public final long getDurationMax() {
            return this.durationMax;
        }

        public final void setDurationMax(long l) {
            this.durationMax = l;
        }

        public final long getDurationSum() {
            return this.durationSum;
        }

        public final void setDurationSum(long l) {
            this.durationSum = l;
        }

        public final long getDurationAvg() {
            return this.durationSum / (long)this.numberOfFinishes;
        }

        public final void registerStart() {
            int n = this.numberOfStarts;
            this.numberOfStarts = n + 1;
        }

        public final void registerFinish(long duration, int packs, int rows, boolean failed) {
            long d;
            long l = d = duration >= 0L ? duration : 1L;
            if (this.durationMin == 0L) {
                this.durationMin = d;
                this.durationMax = d;
                this.durationSum = d;
            } else {
                this.durationMin = Math.min(this.durationMin, d);
                this.durationMax = Math.max(this.durationMax, d);
                this.durationSum += d;
            }
            this.fetchedPacks += packs;
            this.fetchedRows += rows;
            int n = this.numberOfFinishes;
            this.numberOfFinishes = n + 1;
            if (failed) {
                n = this.numberOfFails;
                this.numberOfFails = n + 1;
            }
        }

        public static /* synthetic */ void registerFinish$default(StatEntry statEntry, long l, int n, int n2, boolean bl, int n3, Object object) {
            if ((n3 & 8) != 0) {
                bl = false;
            }
            statEntry.registerFinish(l, n, n2, bl);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/database/introspection/query/QueryStats$StatEntry$DurationComparator;", "Ljava/util/Comparator;", "Lcom/intellij/database/introspection/query/QueryStats$StatEntry;", "Lkotlin/Comparator;", "<init>", "()V", "compare", "", "o1", "o2", "intellij.database.core.impl"})
        public static final class DurationComparator
        implements Comparator<StatEntry> {
            @NotNull
            public static final DurationComparator INSTANCE = new DurationComparator();

            private DurationComparator() {
            }

            @Override
            public int compare(@NotNull StatEntry o1, @NotNull StatEntry o2) {
                Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
                if (o1.getDurationSum() < o2.getDurationSum()) {
                    return 1;
                }
                if (o1.getDurationSum() > o2.getDurationSum()) {
                    return -1;
                }
                if (o1.getDurationMax() < o2.getDurationMax()) {
                    return 1;
                }
                if (o1.getDurationMax() > o2.getDurationMax()) {
                    return -1;
                }
                if (o1.getTurn() < o2.getTurn()) {
                    return -1;
                }
                if (o1.getTurn() > o2.getTurn()) {
                    return 1;
                }
                return 0;
            }
        }
    }
}

