/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties.references;

import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.NameValueGetter;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaReferenceDesc;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.references.BasicRefImporter;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicAndReference
implements BasicReference {
    public final BasicReference ref1;
    public final BasicReference ref2;

    private BasicAndReference(@NotNull BasicReference ref1, @NotNull BasicReference ref2) {
        if (ref1 == null) {
            BasicAndReference.$$$reportNull$$$0(0);
        }
        if (ref2 == null) {
            BasicAndReference.$$$reportNull$$$0(1);
        }
        this.ref1 = ref1;
        this.ref2 = ref2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasicAndReference)) {
            return false;
        }
        BasicAndReference reference = (BasicAndReference)o;
        return this.ref1.equals(reference.ref1) && this.ref2.equals(reference.ref2);
    }

    public int hashCode() {
        return Objects.hash(this.ref1, this.ref2);
    }

    @Nullable
    public static BasicReference create(@Nullable BasicReference ref1, @Nullable BasicReference ref2) {
        if (ref1 == null) {
            return ref2;
        }
        if (ref2 == null) {
            return ref1;
        }
        return new BasicAndReference(ref1, ref2);
    }

    @Override
    @NotNull
    public <S extends BasicElement> BasicReference simplify(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, ?> meta, @NotNull BasicResolveAssistant assistant) {
        if (source == null) {
            BasicAndReference.$$$reportNull$$$0(2);
        }
        if (meta == null) {
            BasicAndReference.$$$reportNull$$$0(3);
        }
        if (assistant == null) {
            BasicAndReference.$$$reportNull$$$0(4);
        }
        BasicReference s1 = this.ref1.simplify(source, meta, assistant);
        BasicReference s2 = this.ref2.simplify(source, meta, assistant);
        BasicReference basicReference = s1 == this.ref1 && s2 == this.ref2 ? this : BasicAndReference.create(s1, s2);
        if (basicReference == null) {
            BasicAndReference.$$$reportNull$$$0(5);
        }
        return basicReference;
    }

    @Override
    @NotNull
    public <S extends BasicElement, T extends BasicElement> JBIterable<T> multiResolve(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> meta, @NotNull BasicResolveAssistant assistant) {
        if (source == null) {
            BasicAndReference.$$$reportNull$$$0(6);
        }
        if (meta == null) {
            BasicAndReference.$$$reportNull$$$0(7);
        }
        if (assistant == null) {
            BasicAndReference.$$$reportNull$$$0(8);
        }
        JBIterable jBIterable = this.ref1.multiResolve(source, meta, assistant).filter(t -> this.ref2.matches(source, meta, t));
        if (jBIterable == null) {
            BasicAndReference.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @Override
    public <S extends BasicElement, T extends BasicElement> boolean matches(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> meta, @NotNull T target) {
        if (source == null) {
            BasicAndReference.$$$reportNull$$$0(10);
        }
        if (meta == null) {
            BasicAndReference.$$$reportNull$$$0(11);
        }
        if (target == null) {
            BasicAndReference.$$$reportNull$$$0(12);
        }
        return this.ref1.matches(source, meta, target) && this.ref2.matches(source, meta, target);
    }

    @Override
    @Nullable
    public String getName() {
        String name = this.ref1.getName();
        return name == null ? this.ref2.getName() : name;
    }

    @Override
    public long getObjectId() {
        long id = this.ref1.getObjectId();
        return id == Long.MIN_VALUE ? this.ref2.getObjectId() : id;
    }

    @Override
    @Nullable
    public String getParentName(int i2) {
        String name = this.ref1.getParentName(i2);
        return name == null ? this.ref2.getParentName(i2) : name;
    }

    @Override
    @Nullable
    public BasicReference subReference() {
        BasicReference res = this.ref1.subReference();
        if (res == null) {
            res = this.ref2.subReference();
        }
        return res;
    }

    @Override
    public void exportProperties(@NotNull NameValueConsumer<? super String> consumer) {
        if (consumer == null) {
            BasicAndReference.$$$reportNull$$$0(13);
        }
        this.ref1.exportProperties(BasicRefImporter.wrap(consumer, "And1"));
        this.ref2.exportProperties(BasicRefImporter.wrap(consumer, "And2"));
    }

    @Override
    public boolean isEquivalent(BasicReference ref) {
        return this.ref1.isEquivalent(ref) && this.ref2.isEquivalent(ref);
    }

    @Nullable
    public static BasicReference importProperties(@NotNull NameValueGetter<String> properties, @NotNull Function<? super NameValueGetter<String>, ? extends BasicReference> sub) {
        NameValueGetter<String> w1;
        BasicReference ref1;
        if (properties == null) {
            BasicAndReference.$$$reportNull$$$0(14);
        }
        if (sub == null) {
            BasicAndReference.$$$reportNull$$$0(15);
        }
        BasicReference basicReference = ref1 = (w1 = BasicRefImporter.wrap(properties, "And1")) == null ? null : (BasicReference)sub.fun(w1);
        if (ref1 == null) {
            return null;
        }
        NameValueGetter<String> w2 = BasicRefImporter.wrap(properties, "And2");
        BasicReference ref2 = w2 == null ? null : (BasicReference)sub.fun(w2);
        return BasicAndReference.create(ref1, ref2);
    }

    public String toString() {
        return "[" + String.valueOf(this.ref1) + "] && [" + String.valueOf(this.ref2) + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref2";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assistant";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/properties/references/BasicAndReference";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/properties/references/BasicAndReference";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "simplify";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "simplify";
                break;
            }
            case 5: 
            case 9: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "multiResolve";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 9 -> new IllegalStateException(string);
        };
    }
}

