/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization.converters;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.serialization.Converter;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.model.serialization.ModelSerializationFun;
import com.intellij.database.model.serialization.MutableNameAndValue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/model/serialization/converters/Converter_4_29;", "Lcom/intellij/database/model/serialization/Converter;", "<init>", "()V", "convertMem", "", "modelMem", "Lcom/intellij/database/model/serialization/ModelMem;", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nConverter_4_29.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Converter_4_29.kt\ncom/intellij/database/model/serialization/converters/Converter_4_29\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,32:1\n1#2:33\n*E\n"})
public final class Converter_4_29
extends Converter {
    @NotNull
    public static final Converter_4_29 INSTANCE = new Converter_4_29();

    private Converter_4_29() {
        int[] nArray = new int[]{4, 29};
        super(nArray);
    }

    @Override
    public void convertMem(@NotNull ModelMem modelMem) {
        Intrinsics.checkNotNullParameter((Object)modelMem, (String)"modelMem");
        String fk = ObjectKind.FOREIGN_KEY.code();
        String idx = ObjectKind.INDEX.code();
        Dbms it = modelMem.getDbms();
        boolean bl = false;
        boolean hasOwner = it.in(Dbms.POSTGRES_LIKE) || Intrinsics.areEqual((Object)it, (Object)Dbms.EXASOL) || Intrinsics.areEqual((Object)it, (Object)Dbms.VERTICA) || Intrinsics.areEqual((Object)it, (Object)Dbms.HIVE);
        for (ModelElementMem node : modelMem.getNodes()) {
            if (Intrinsics.areEqual((Object)node.getKind(), (Object)fk)) {
                MutableNameAndValue mutableNameAndValue = ModelSerializationFun.find(node.getProperties(), "RefSchemaName");
                if (mutableNameAndValue != null) {
                    mutableNameAndValue.setName("RefTableParentName");
                }
            }
            if (Intrinsics.areEqual((Object)node.getKind(), (Object)idx) && Intrinsics.areEqual((Object)modelMem.getDbms(), (Object)Dbms.ORACLE)) {
                MutableNameAndValue mutableNameAndValue = ModelSerializationFun.find(node.getProperties(), "IndextypeOwner");
                if (mutableNameAndValue != null) {
                    mutableNameAndValue.setName("IndextypeParentName");
                }
            }
            if (!hasOwner) continue;
            MutableNameAndValue mutableNameAndValue = ModelSerializationFun.find(node.getProperties(), "Owner");
            if (mutableNameAndValue == null) continue;
            mutableNameAndValue.setName("OwnerName");
        }
    }
}

