/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\n"}, d2={"getCodeStyleName", "", "ds", "Lcom/intellij/database/model/DasDataSource;", "extractProject", "Lcom/intellij/openapi/project/Project;", "getCodeStyle", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "getSqlCodeStyle", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "intellij.database.core.impl"})
public final class ScriptingTaskBuilderKt {
    @Nullable
    public static final String getCodeStyleName(@NotNull DasDataSource ds) {
        String string;
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        DasDataSource dasDataSource = ds;
        if (dasDataSource instanceof DbDataSource) {
            RawDataSource rawDataSource = ((DbDataSource)ds).getDelegate();
            Intrinsics.checkNotNullExpressionValue((Object)rawDataSource, (String)"getDelegate(...)");
            string = ScriptingTaskBuilderKt.getCodeStyleName((DasDataSource)rawDataSource);
        } else {
            string = dasDataSource instanceof LocalDataSource ? ((LocalDataSource)ds).getCodeStyleName() : (dasDataSource instanceof SqlDataSource ? ((SqlDataSource)ds).getCodeStyleName() : null);
        }
        return string;
    }

    private static final Project extractProject(DasDataSource ds) {
        DasDataSource dasDataSource = ds;
        return dasDataSource instanceof DbDataSource ? ((DbDataSource)ds).getProject() : (dasDataSource instanceof SqlDataSource ? ((SqlDataSource)ds).getProject() : null);
    }

    @NotNull
    public static final CodeStyleSettings getCodeStyle(@NotNull DasDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        CodeStyleSettings codeStyleSettings = SqlCodeStyles.getSettings((Project)ScriptingTaskBuilderKt.extractProject(ds), (String)ScriptingTaskBuilderKt.getCodeStyleName(ds));
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getSettings(...)");
        return codeStyleSettings;
    }

    @NotNull
    public static final SqlCodeStyleSettings getSqlCodeStyle(@NotNull DasDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        SqlCodeStyleSettings sqlCodeStyleSettings = SqlCodeStyles.getSqlSettings((Project)ScriptingTaskBuilderKt.extractProject(ds), (String)ScriptingTaskBuilderKt.getCodeStyleName(ds), (SqlLanguageDialect)DbSqlUtilCore.getSqlDialect(ds));
        Intrinsics.checkNotNullExpressionValue((Object)sqlCodeStyleSettings, (String)"getSqlSettings(...)");
        return sqlCodeStyleSettings;
    }
}

