/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mcpserver.clients.impl;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.mcpserver.McpServerBundle;
import com.intellij.mcpserver.clients.McpClient;
import com.intellij.mcpserver.clients.McpClientInfo;
import com.intellij.mcpserver.clients.configs.ClaudeCodeSSEConfig;
import com.intellij.mcpserver.clients.configs.ServerConfig;
import com.intellij.mcpserver.clients.impl.ClaudeCodeClient;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.platform.ide.progress.TaskCancellation;
import com.intellij.platform.ide.progress.TasksKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/mcpserver/clients/impl/ClaudeCodeClient;", "Lcom/intellij/mcpserver/clients/McpClient;", "scope", "Lcom/intellij/mcpserver/clients/McpClientInfo$Scope;", "configPath", "Ljava/nio/file/Path;", "<init>", "(Lcom/intellij/mcpserver/clients/McpClientInfo$Scope;Ljava/nio/file/Path;)V", "isConfigured", "", "()Ljava/lang/Boolean;", "configure", "", "getSSEConfig", "Lcom/intellij/mcpserver/clients/configs/ServerConfig;", "intellij.mcpserver"})
public final class ClaudeCodeClient
extends McpClient {
    public ClaudeCodeClient(@NotNull McpClientInfo.Scope scope, @NotNull Path configPath) {
        Intrinsics.checkNotNullParameter((Object)((Object)scope), (String)"scope");
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        super(new McpClientInfo(McpClientInfo.Name.CLAUDE_CODE, scope), configPath);
    }

    @Override
    @Nullable
    public Boolean isConfigured() {
        Boolean bl = this.isStdIOConfigured();
        if (bl == null) {
            return null;
        }
        boolean stdio = bl;
        Boolean bl2 = this.isSSEConfigured();
        if (bl2 == null) {
            return null;
        }
        boolean sse = bl2;
        return stdio || sse;
    }

    @Override
    public void configure() {
        ModalTaskOwner modalTaskOwner = ModalTaskOwner.guess();
        Intrinsics.checkNotNullExpressionValue((Object)modalTaskOwner, (String)"guess(...)");
        TasksKt.runWithModalProgressBlocking((ModalTaskOwner)modalTaskOwner, (String)McpServerBundle.INSTANCE.message("autoconfigure.progress.title", new Object[0]), (TaskCancellation)((TaskCancellation)TaskCancellation.Companion.nonCancellable()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ClaudeCodeClient this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        String prod = ClaudeCodeClient.access$jetBrainsServerKey(this.this$0);
                        configure.1.invokeSuspend$add(prod, ClaudeCodeClient.access$getSseUrl(this.this$0));
                        if (McpClient.Companion.writeLegacy() && !Intrinsics.areEqual((Object)"jetbrains", (Object)prod)) {
                            configure.1.invokeSuspend$add("jetbrains", ClaudeCodeClient.access$getSseUrl(this.this$0));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$add(String name, String url) {
                String[] stringArray = new String[]{"mcp", "add", "--scope", "user", "--transport", "sse", name, url};
                GeneralCommandLine generalCommandLine = new GeneralCommandLine().withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withExePath("claude").withParameters(stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withParameters(...)");
                GeneralCommandLine cmd = generalCommandLine;
                ProcessOutput out = ExecUtil.execAndGetOutput((GeneralCommandLine)cmd, (int)1000);
                if (out.getExitCode() != 0) {
                    throw new IllegalStateException(("Claude failed with exit code " + out.getExitCode() + ": " + out.getStderr()).toString());
                }
            }
        }));
    }

    @Override
    @NotNull
    protected ServerConfig getSSEConfig() {
        String string = this.getSseUrl();
        return new ClaudeCodeSSEConfig(string, "sse");
    }

    public static final /* synthetic */ String access$jetBrainsServerKey(ClaudeCodeClient $this) {
        return $this.jetBrainsServerKey();
    }

    public static final /* synthetic */ String access$getSseUrl(ClaudeCodeClient $this) {
        return $this.getSseUrl();
    }
}

