/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.task.ui;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemNode;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemTasksTreeModel;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.event.ActionEvent;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ExternalSystemTasksTree
extends Tree
implements Supplier<ExternalTaskExecutionInfo> {
    private static final int COLLAPSE_STATE_PROCESSING_DELAY_MILLIS = 200;
    @NotNull
    private static final Comparator<TreePath> PATH_COMPARATOR = (o1, o2) -> o2.getPathCount() - o1.getPathCount();
    @NotNull
    private final Alarm myCollapseStateAlarm;
    @NotNull
    private final Set<TreePath> myPathsToProcessCollapseState;
    @NotNull
    private final Map<String, Boolean> myExpandedStateHolder;
    private boolean mySuppressCollapseTracking;

    public ExternalSystemTasksTree(@NotNull ExternalSystemTasksTreeModel model, @NotNull Map<String, Boolean> expandedStateHolder, final @NotNull Project project, final @NotNull ProjectSystemId externalSystemId) {
        if (model == null) {
            ExternalSystemTasksTree.$$$reportNull$$$0(0);
        }
        if (expandedStateHolder == null) {
            ExternalSystemTasksTree.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ExternalSystemTasksTree.$$$reportNull$$$0(2);
        }
        if (externalSystemId == null) {
            ExternalSystemTasksTree.$$$reportNull$$$0(3);
        }
        super((TreeModel)model);
        this.myCollapseStateAlarm = new Alarm();
        this.myPathsToProcessCollapseState = new HashSet<TreePath>();
        this.myExpandedStateHolder = expandedStateHolder;
        this.setRootVisible(false);
        this.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) {
                if (!ExternalSystemTasksTree.this.mySuppressCollapseTracking) {
                    ExternalSystemTasksTree.this.myExpandedStateHolder.put(ExternalSystemTasksTree.getPath(event.getPath()), true);
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) {
                if (!ExternalSystemTasksTree.this.mySuppressCollapseTracking) {
                    ExternalSystemTasksTree.this.myExpandedStateHolder.put(ExternalSystemTasksTree.getPath(event.getPath()), false);
                }
            }
        });
        model.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            public void treeStructureChanged(TreeModelEvent e) {
                ExternalSystemTasksTree.this.scheduleCollapseStateAppliance(e.getTreePath());
            }

            public void treeNodesInserted(TreeModelEvent e) {
                ExternalSystemTasksTree.this.scheduleCollapseStateAppliance(e.getTreePath());
            }
        });
        TreeUIHelper.getInstance().installTreeSpeedSearch((JTree)((Object)this));
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "Enter");
        this.getActionMap().put("Enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalTaskExecutionInfo task = ExternalSystemTasksTree.this.get();
                if (task == null) {
                    return;
                }
                ExternalSystemUtil.runTask(task.getSettings(), task.getExecutorId(), project, externalSystemId, null, ProgressExecutionMode.NO_PROGRESS_ASYNC);
            }
        });
    }

    private void scheduleCollapseStateAppliance(@NotNull TreePath path) {
        if (path == null) {
            ExternalSystemTasksTree.$$$reportNull$$$0(4);
        }
        this.myPathsToProcessCollapseState.add(path);
        this.myCollapseStateAlarm.cancelAllRequests();
        this.myCollapseStateAlarm.addRequest(() -> {
            ArrayList<TreePath> paths = new ArrayList<TreePath>(this.myPathsToProcessCollapseState);
            this.myPathsToProcessCollapseState.clear();
            paths.sort(PATH_COMPARATOR);
            for (TreePath treePath : paths) {
                this.applyCollapseState(treePath);
            }
            TreePath rootPath = new TreePath(this.getModel().getRoot());
            if (this.isCollapsed(rootPath)) {
                this.expandPath(rootPath);
            }
        }, 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyCollapseState(@NotNull TreePath path) {
        String key;
        Boolean expanded;
        if (path == null) {
            ExternalSystemTasksTree.$$$reportNull$$$0(5);
        }
        if ((expanded = this.myExpandedStateHolder.get(key = ExternalSystemTasksTree.getPath(path))) == null) {
            return;
        }
        boolean s = this.mySuppressCollapseTracking;
        this.mySuppressCollapseTracking = true;
        try {
            if (expanded.booleanValue()) {
                this.expandPath(path);
            } else {
                this.collapsePath(path);
            }
        }
        finally {
            this.mySuppressCollapseTracking = s;
        }
    }

    @NotNull
    private static String getPath(@NotNull TreePath path) {
        if (path == null) {
            ExternalSystemTasksTree.$$$reportNull$$$0(6);
        }
        StringBuilder buffer = new StringBuilder();
        for (TreePath current = path; current != null; current = current.getParentPath()) {
            buffer.append(current.getLastPathComponent().toString()).append('/');
        }
        buffer.setLength(buffer.length() - 1);
        String string = buffer.toString();
        if (string == null) {
            ExternalSystemTasksTree.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @Nullable
    public ExternalTaskExecutionInfo get() {
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length == 0) {
            return null;
        }
        HashMap<CallSite, ExternalTaskExecutionInfo> map = new HashMap<CallSite, ExternalTaskExecutionInfo>();
        for (TreePath selectionPath : selectionPaths) {
            Object element;
            Object component = selectionPath.getLastPathComponent();
            if (!(component instanceof ExternalSystemNode) || !((element = ((ExternalSystemNode)component).getDescriptor().getElement()) instanceof ExternalTaskExecutionInfo)) continue;
            ExternalTaskExecutionInfo taskExecutionInfo = (ExternalTaskExecutionInfo)element;
            ExternalSystemTaskExecutionSettings executionSettings = taskExecutionInfo.getSettings();
            String key = executionSettings.getExternalSystemIdString() + executionSettings.getExternalProjectPath() + executionSettings.getVmOptions();
            ExternalTaskExecutionInfo executionInfo = (ExternalTaskExecutionInfo)map.get(key);
            if (executionInfo == null) {
                ExternalSystemTaskExecutionSettings taskExecutionSettings = new ExternalSystemTaskExecutionSettings();
                taskExecutionSettings.setExternalProjectPath(executionSettings.getExternalProjectPath());
                taskExecutionSettings.setExternalSystemIdString(executionSettings.getExternalSystemIdString());
                taskExecutionSettings.setVmOptions(executionSettings.getVmOptions());
                taskExecutionSettings.setScriptParameters(executionSettings.getScriptParameters());
                taskExecutionSettings.setExecutionName(executionSettings.getExecutionName());
                executionInfo = new ExternalTaskExecutionInfo(taskExecutionSettings, taskExecutionInfo.getExecutorId());
                map.put((CallSite)((Object)key), executionInfo);
            }
            executionInfo.getSettings().getTaskNames().addAll(executionSettings.getTaskNames());
            executionInfo.getSettings().getTaskDescriptions().addAll(executionSettings.getTaskDescriptions());
        }
        if (map.size() != 1) {
            return null;
        }
        return (ExternalTaskExecutionInfo)map.values().iterator().next();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expandedStateHolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTree";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "scheduleCollapseStateAppliance";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyCollapseState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

