/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.formatter;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0003J\n\u0010\u000f\u001a\u00020\u0003H\u0096\u0080\u0004J\u0014\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u0096\u0080\u0004R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntry;", "", "packageName", "", "withSubpackages", "", "<init>", "(Ljava/lang/String;Z)V", "getWithSubpackages", "()Z", "getPackageName", "()Ljava/lang/String;", "matchesPackageName", "otherPackageName", "isSpecial", "toString", "equals", "other", "hashCode", "", "Companion", "intellij.kotlin.formatter.minimal"})
public final class KotlinPackageEntry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean withSubpackages;
    @NotNull
    private final String packageName;
    @JvmField
    @NotNull
    public static final KotlinPackageEntry ALL_OTHER_IMPORTS_ENTRY = new KotlinPackageEntry("<all other imports>", true);
    @JvmField
    @NotNull
    public static final KotlinPackageEntry ALL_OTHER_ALIAS_IMPORTS_ENTRY = new KotlinPackageEntry("<all other alias imports>", true);

    public KotlinPackageEntry(@NotNull String packageName, boolean withSubpackages) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        this.withSubpackages = withSubpackages;
        this.packageName = StringsKt.removeSuffix((String)packageName, (CharSequence)".*");
    }

    public final boolean getWithSubpackages() {
        return this.withSubpackages;
    }

    @NotNull
    public final String getPackageName() {
        return this.packageName;
    }

    public final boolean matchesPackageName(@NotNull String otherPackageName) {
        Intrinsics.checkNotNullParameter((Object)otherPackageName, (String)"otherPackageName");
        if (StringsKt.startsWith$default((String)otherPackageName, (String)this.packageName, (boolean)false, (int)2, null)) {
            if (otherPackageName.length() == this.packageName.length()) {
                return true;
            }
            if (this.withSubpackages && otherPackageName.charAt(this.packageName.length()) == '.') {
                return true;
            }
        }
        return false;
    }

    public final boolean isSpecial() {
        return Intrinsics.areEqual((Object)this, (Object)ALL_OTHER_IMPORTS_ENTRY) || Intrinsics.areEqual((Object)this, (Object)ALL_OTHER_ALIAS_IMPORTS_ENTRY);
    }

    @NotNull
    public String toString() {
        return this.packageName;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KotlinPackageEntry)) {
            return false;
        }
        return this.withSubpackages == ((KotlinPackageEntry)other).withSubpackages && Intrinsics.areEqual((Object)this.packageName, (Object)((KotlinPackageEntry)other).packageName);
    }

    public int hashCode() {
        return this.packageName.hashCode();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntry$Companion;", "", "<init>", "()V", "ALL_OTHER_IMPORTS_ENTRY", "Lorg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntry;", "ALL_OTHER_ALIAS_IMPORTS_ENTRY", "intellij.kotlin.formatter.minimal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

